/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.common.util;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.CodeRuleServiceHelper;
import kd.scm.common.ORMUtil;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.common.util.DynamicObjectUtil;

public class PmmSupplierAuditUtil {
    private static final String NAME = "name";
    private static final String MALLSTATUS = "mallstatus";
    private static final String MALLDATE = "malldate";
    private static final String SUPPLIER = "supplier";
    private static final String GROUP = "group";

    public static DynamicObject[] getPmmBillForSave(List<Long> allBillId) {
        String selectFields = DynamicObjectUtil.getSelectfields((String)"pmm_supplieraudit", (boolean)false);
        selectFields = DynamicObjectUtil.getEntrySelectfields((String)selectFields, (String)"pmm_supplieraudit", (String)"entryentity", (boolean)false);
        DynamicObject[] objs = BusinessDataServiceHelper.load((String)"pmm_supplieraudit", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", allBillId)});
        return objs.length == 0 ? null : objs;
    }

    public static void updateSup(Object supplierId, boolean agree, String bizType, Date currDate, DynamicObject billObj, Map<String, List<DynamicObject>> saveDynMap) {
        DynamicObject supplierObj = new DynamicObject();
        supplierObj = BusinessDataServiceHelper.loadSingle((Object)supplierId, (String)"bd_supplier");
        if (supplierObj != null) {
            if (agree) {
                switch (bizType) {
                    case "1": {
                        supplierObj.set(MALLSTATUS, (Object)"B");
                        break;
                    }
                    case "2": {
                        supplierObj.set(MALLSTATUS, (Object)"C");
                        break;
                    }
                    case "3": {
                        supplierObj.set(MALLSTATUS, (Object)"B");
                        break;
                    }
                    case "4": {
                        supplierObj.set(MALLSTATUS, (Object)"D");
                        break;
                    }
                }
                supplierObj.set(MALLDATE, (Object)currDate);
            } else {
                supplierObj.set(MALLSTATUS, (Object)" ");
                supplierObj.set(MALLDATE, (Object)" ");
            }
            List billObjList = saveDynMap.computeIfAbsent("billObj", k -> new ArrayList());
            billObjList.add(billObj);
            if (bizType.equals("1")) {
                PmmSupplierAuditUtil.updateSupplier(billObj, supplierObj, saveDynMap);
            } else {
                List supplierObjList = saveDynMap.computeIfAbsent("supplierObj", k -> new ArrayList());
                supplierObjList.add(supplierObj);
            }
        }
    }

    private static void updateSupplier(DynamicObject billObj, DynamicObject supplierObj, Map<String, List<DynamicObject>> saveDynMap) {
        String supplierId = supplierObj.getPkValue().toString();
        DynamicObject group = billObj.getDynamicObject(GROUP);
        supplierObj.set(GROUP, (Object)group);
        List supplierObjList = saveDynMap.computeIfAbsent("supplierObj", k -> new ArrayList());
        supplierObjList.add(supplierObj);
        PmmSupplierAuditUtil.updateBizPartners(billObj, supplierId, saveDynMap);
        PmmSupplierAuditUtil.updateSrmSupplier(billObj, supplierId, saveDynMap);
    }

    private static void updateBizPartners(DynamicObject billObj, Object supplierId, Map<String, List<DynamicObject>> saveDynMap) {
        Long bizPartnerId = BizPartnerUtil.getBizPartnerBySupplier((Object)Long.valueOf((String)supplierId));
        DynamicObject bizPartner = BusinessDataServiceHelper.loadSingle((Object)bizPartnerId, (String)"bd_bizpartner");
        bizPartner.set("linkman", (Object)billObj.getString("linkman"));
        bizPartner.set("address", (Object)billObj.getString("address"));
        bizPartner.set("phone", (Object)billObj.getString("phone"));
        bizPartner.set("societycreditcode", (Object)billObj.getString("societycreditcode"));
        bizPartner.set("orgcode", (Object)billObj.getString("orgcode"));
        bizPartner.set("tx_register_no", (Object)billObj.getString("txregisterno"));
        List bizPartnerList = saveDynMap.computeIfAbsent("bizPartner", k -> new ArrayList());
        bizPartnerList.add(bizPartner);
    }

    private static void updateSrmSupplier(DynamicObject billObj, Object supplierId, Map<String, List<DynamicObject>> saveDynMap) {
        DynamicObject supplier = billObj.getDynamicObject(SUPPLIER);
        DynamicObjectCollection entry = billObj.getDynamicObjectCollection("entryentity");
        QFilter supFilter = new QFilter(SUPPLIER, "=", (Object)Long.parseLong(String.valueOf(supplierId)));
        QFilter[] filters = new QFilter[]{supFilter};
        String selectFields = DynamicObjectUtil.getSelectfields((String)"srm_supplierreg", (boolean)false);
        selectFields = DynamicObjectUtil.getEntrySelectfields((String)selectFields, (String)"srm_supplierreg", (String)"entry_aptitude", (boolean)false);
        DynamicObject srmSupplier = BusinessDataServiceHelper.loadSingle((String)"srm_supplierreg", (String)(selectFields = DynamicObjectUtil.getEntrySelectfields((String)selectFields, (String)"srm_supplierreg", (String)"entry_bank", (boolean)false)), (QFilter[])filters);
        if (null == srmSupplier) {
            srmSupplier = ORMUtil.newDynamicObject((String)"srm_supplierreg");
            srmSupplier.set(SUPPLIER, supplierId);
            srmSupplier.set("org", (Object)billObj.getDynamicObject("org"));
            String number = CodeRuleServiceHelper.getNumber((String)"srm_supplierreg", (DynamicObject)srmSupplier, (String)((DynamicObject)srmSupplier.get("org")).getPkValue().toString());
            srmSupplier.set("number", (Object)number);
            srmSupplier.set(NAME, supplier.get(NAME));
        }
        srmSupplier.set(GROUP, (Object)billObj.getDynamicObject(GROUP));
        srmSupplier.set("linkman", (Object)billObj.getString("linkman"));
        srmSupplier.set("phone", (Object)billObj.getString("phone"));
        srmSupplier.set("address", (Object)billObj.getString("address"));
        srmSupplier.set("txregisterno", (Object)billObj.getString("txregisterno"));
        srmSupplier.set("societycreditcode", (Object)billObj.getString("societycreditcode"));
        srmSupplier.set("orgcode", (Object)billObj.getString("orgcode"));
        srmSupplier.set("centralpurtype", (Object)billObj.getString("centralpurtype"));
        srmSupplier.set("bizscope", (Object)billObj.getString("bizscope"));
        srmSupplier.set("invoicetype", (Object)billObj.getString("invoicetype"));
        srmSupplier.set("type", (Object)"1");
        srmSupplier.set("status", (Object)"C");
        srmSupplier.set("enable", (Object)"1");
        srmSupplier.set("auditstatus", (Object)"E");
        DynamicObjectCollection entryaptitude = srmSupplier.getDynamicObjectCollection("entry_aptitude");
        entryaptitude.clear();
        for (DynamicObject row : entry) {
            DynamicObject aptEntry = ORMUtil.newDynamicObject((DynamicObjectType)entryaptitude.getDynamicObjectType());
            int rowSize = 11;
            for (int i = 1; i < rowSize; ++i) {
                aptEntry.set(i, row.get(i));
            }
            entryaptitude.add((Object)aptEntry);
        }
        boolean isExist = false;
        DynamicObjectCollection entrybank = srmSupplier.getDynamicObjectCollection("entry_bank");
        for (DynamicObject bank : entrybank) {
            if (!bank.getString("account").equals(billObj.getString("account"))) continue;
            bank.set("bank", (Object)billObj.getString("bank"));
            bank.set("accountname", (Object)billObj.getString("accountname"));
            isExist = true;
        }
        if (!isExist) {
            DynamicObject bankEntry = ORMUtil.newDynamicObject((DynamicObjectType)entrybank.getDynamicObjectType());
            bankEntry.set("seq", (Object)(entrybank.size() + 1));
            bankEntry.set("accounttype", (Object)"1");
            bankEntry.set("bank", (Object)billObj.getString("bank"));
            bankEntry.set("accountname", (Object)billObj.getString("accountname"));
            bankEntry.set("account", (Object)billObj.getString("account"));
            entrybank.add((Object)bankEntry);
        }
        List srmSupplierList = saveDynMap.computeIfAbsent("srmSupplier", k -> new ArrayList());
        srmSupplierList.add(srmSupplier);
    }
}

