/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.business.model.product;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.plugin.support.util.ReflectionUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.es.storage.EsFilterField;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.pmm.business.service.PmmProductObtainService;

public class PmmProdObtain {
    private static final Log log = LogFactory.getLog((String)PmmProdObtain.class.getName());
    private final DynamicObject dyn;

    public PmmProdObtain(Long id) {
        this.dyn = BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)"pmm_product_obtain");
    }

    public PmmProdObtain(DynamicObject dyn) {
        this.dyn = dyn;
    }

    public List<Long> getCategoryIds() {
        DynamicObjectCollection categorys = this.dyn.getDynamicObjectCollection("categorys");
        ArrayList<Long> res = new ArrayList<Long>(categorys.size());
        for (DynamicObject categoryDyn : categorys) {
            res.add(categoryDyn.getLong("fbasedataid_id"));
        }
        return res;
    }

    public Long getSupplierId() {
        DynamicObject supplierDyn = this.dyn.getDynamicObject("supplier");
        if (supplierDyn != null) {
            return supplierDyn.getLong("id");
        }
        return 0L;
    }

    public List<QFilter> getFilters() {
        String filterConditonJson = this.dyn.getString("filtercondition");
        if (StringUtils.isBlank((CharSequence)filterConditonJson)) {
            return new ArrayList<QFilter>();
        }
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterConditonJson, FilterCondition.class);
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)this.getEntityNumber());
        FilterBuilder filterBuilder = new FilterBuilder(entityType, filterCondition);
        filterBuilder.buildFilter();
        return filterBuilder.getQFilters();
    }

    public String getEntityNumber() {
        String platform = this.getPlatform();
        if (StringUtils.isNotBlank((CharSequence)platform)) {
            if ("1".equals(platform)) {
                return "pmm_prodpool";
            }
            return "pbd_mallgoods_status";
        }
        throw new KDBizException("platform not exist.");
    }

    public String getPlatform() {
        return this.dyn.getString("platform");
    }

    public String getAcquisitionMode() {
        return this.dyn.getString("acquisition_mode");
    }

    public PmmProductObtainService getPlugin() {
        String plugin = this.dyn.getString("plugin");
        if (StringUtils.isNotBlank((CharSequence)plugin)) {
            try {
                return (PmmProductObtainService)ReflectionUtils.accessibleConstructor(Class.forName(plugin), (Class[])new Class[]{PmmProdObtain.class}).newInstance(this);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                log.warn("kd.scm.pmm.business.model.product.PmmProductAcquisition.getPlugin:" + ExceptionUtil.getStackTrace((Throwable)e));
            }
        }
        return null;
    }

    public String getOrderBy() {
        return this.dyn.getString("orderby");
    }

    public int getLimit() {
        return this.dyn.getInt("limit");
    }

    public int getCountRows() {
        return this.dyn.getInt("count_rows");
    }

    public Long getGoodsEsConfigId() {
        return this.dyn.getLong("goodsesconfig.id");
    }

    public Long getSalesEsConfigId() {
        return this.dyn.getLong("salesesconfig.id");
    }

    public List<EsFilterField> getEsFilterFieldsByCustom() {
        DynamicObject goodsEsConfigDyn = BusinessDataServiceHelper.loadSingleFromCache((Object)this.getGoodsEsConfigId(), (String)"pbd_esconfig");
        if (goodsEsConfigDyn == null) {
            log.warn("\u5546\u54c1\u5168\u6587\u68c0\u7d22\u914d\u7f6e\u4e3a\u7a7a");
            return new ArrayList<EsFilterField>();
        }
        HashMap mappingField2EsFieldMap = new HashMap(64);
        QFilter indexentityFilter = new QFilter("indexentity.id", "=", (Object)goodsEsConfigDyn.getString("indexentity.id"));
        String indexKey = "";
        try (DataSet esMappingPropDs = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)"pbd_esconfig", (String)"indexkey", (QFilter[])new QFilter[]{indexentityFilter}, null);){
            for (Row row2 : esMappingPropDs) {
                indexKey = row2.getString("indexkey");
            }
        }
        esMappingPropDs = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)"pbd_esconfig", (String)"entryentity.esmapping.number,entryentity.esmapping.mappingfield", (QFilter[])new QFilter[]{new QFilter("indexkey", "=", (Object)indexKey)}, null);
        var6_6 = null;
        try {
            esMappingPropDs.forEach(row -> mappingField2EsFieldMap.put(row.getString("entryentity.esmapping.mappingfield"), row.getString("entryentity.esmapping.number")));
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
        finally {
            if (esMappingPropDs != null) {
                if (var6_6 != null) {
                    try {
                        esMappingPropDs.close();
                    }
                    catch (Throwable throwable) {
                        var6_6.addSuppressed(throwable);
                    }
                } else {
                    esMappingPropDs.close();
                }
            }
        }
        ArrayList<EsFilterField> res = new ArrayList<EsFilterField>();
        List<QFilter> filters = this.getFilters();
        for (QFilter qFilter : filters) {
            String number = (String)mappingField2EsFieldMap.get(qFilter.getProperty());
            if (!StringUtils.isNotBlank((CharSequence)number)) continue;
            Object value = qFilter.getValue();
            if ("in".equalsIgnoreCase(qFilter.getCP())) {
                res.add(new EsFilterField(number, qFilter.getCP(), ((List)value).toArray()));
                continue;
            }
            res.add(new EsFilterField(number, qFilter.getCP(), new Object[]{qFilter.getValue()}));
        }
        return res;
    }

    public List<Long> getGoodsIdByCustomSelect() {
        DynamicObjectCollection entryCol = this.dyn.getDynamicObjectCollection("entryentity");
        ArrayList<Long> res = new ArrayList<Long>(entryCol.size());
        for (DynamicObject entry : entryCol) {
            res.add(entry.getLong("goods.id"));
        }
        return res;
    }

    public boolean isSortInCategory() {
        return this.dyn.getBoolean("sort_in_category");
    }
}

