/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.business.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.es.storage.EsFilterField;
import kd.scm.malcore.domain.PmmCategoryMappingInfo;

public class PmmCategoryMappingService {
    private static final String SELCTORS = "selfclass.number,ecclass.number,selfclass.id,ecclass.id,ecclass.name,platform,selfclass.longnumber,ecclass.longnumber,selfclass.name";

    public Map<String, Set<PmmCategoryMappingInfo>> getEcCategoryMapBySelf(Set<String> classNos) {
        HashMap<String, Set<PmmCategoryMappingInfo>> categoryMap = new HashMap<String, Set<PmmCategoryMappingInfo>>(16);
        if (classNos.size() > 0) {
            QFilter qFilter = new QFilter("selfclass.longnumber", "in", classNos);
            DynamicObjectCollection infoCols = QueryServiceHelper.query((String)"pmm_categoryunion", (String)SELCTORS, (QFilter[])qFilter.toArray());
            for (DynamicObject info : infoCols) {
                String srcClassNo = info.getString("selfclass.longnumber");
                Set<Object> classIds = new HashSet<PmmCategoryMappingInfo>(16);
                if (null != categoryMap.get(srcClassNo)) {
                    classIds = (Set)categoryMap.get(srcClassNo);
                }
                classIds.add(this.getEcInfo(info));
                categoryMap.put(srcClassNo, classIds);
            }
        }
        return categoryMap;
    }

    private Set<String> getEnableStandardPlats() {
        QFilter qFilter = new QFilter("enable", "=", (Object)Boolean.TRUE).and(new QFilter("openstatus", "!=", (Object)"2").and(new QFilter("tenantid", "=", (Object)RequestContext.getOrCreate().getTenantId())));
        Map ecadmits = BusinessDataServiceHelper.loadFromCache((String)"pmm_ecadmit", (String)"platform", (QFilter[])new QFilter[]{qFilter});
        HashSet<String> platformSet = new HashSet<String>(16);
        for (Map.Entry infoMap : ecadmits.entrySet()) {
            platformSet.add(((DynamicObject)infoMap.getValue()).getString("platform"));
        }
        return platformSet;
    }

    public Map<String, PmmCategoryMappingInfo> getSelfCategoryMapByEc(Set<String> classNos, String sources) {
        HashMap<String, PmmCategoryMappingInfo> categoryMap = new HashMap<String, PmmCategoryMappingInfo>(16);
        if (classNos.size() > 0) {
            QFilter qFilter = new QFilter("ecclass.longnumber", "in", classNos);
            qFilter.and(new QFilter("platform", "=", (Object)sources));
            DynamicObjectCollection infoCols = QueryServiceHelper.query((String)"pmm_categoryunion", (String)SELCTORS, (QFilter[])qFilter.toArray());
            for (DynamicObject info : infoCols) {
                String srcClassNo = info.getString("ecclass.longnumber");
                categoryMap.put(srcClassNo, this.getSelfInfo(info));
            }
        }
        return categoryMap;
    }

    public Set<PmmCategoryMappingInfo> getMappingCategorysByClassId(Set<Long> classIds) {
        HashSet<PmmCategoryMappingInfo> categoryInfos = new HashSet<PmmCategoryMappingInfo>(16);
        if (classIds.size() > 0) {
            QFilter qFilter = new QFilter("ecclass.id", "in", classIds);
            qFilter.or(new QFilter("selfclass.id", "in", classIds));
            Set<String> enableStandardPlats = this.getEnableStandardPlats();
            qFilter.and(new QFilter("platform", "not in", enableStandardPlats));
            DynamicObjectCollection infoCols = QueryServiceHelper.query((String)"pmm_categoryunion", (String)SELCTORS, (QFilter[])qFilter.toArray());
            for (DynamicObject info : infoCols) {
                categoryInfos.add(this.getEcInfo(info));
                categoryInfos.add(this.getSelfInfo(info));
            }
        }
        return categoryInfos;
    }

    @Deprecated
    public Set<PmmCategoryMappingInfo> getCategorysBySearchText(String classField, String searchText, String sources) {
        QFilter qFilter = new QFilter("selfclass.name", "=", (Object)searchText);
        qFilter.or(new QFilter("ecclass.name", "=", (Object)searchText));
        if (classField.contains("like")) {
            qFilter = new QFilter("selfclass.name", "like", (Object)("%" + searchText + "%"));
            qFilter.or(new QFilter("ecclass.name", "like", (Object)("%" + searchText + "%")));
        }
        if (classField.contains("classnumber")) {
            qFilter = new QFilter("selfclass.number", "=", (Object)searchText);
            qFilter.or(new QFilter("ecclass.number", "=", (Object)searchText));
            if (classField.contains("like")) {
                qFilter = new QFilter("selfclass.number", "like", (Object)("%" + searchText + "%"));
                qFilter.or(new QFilter("ecclass.number", "like", (Object)("%" + searchText + "%")));
            }
        }
        if (classField.contains("classlongnumber")) {
            qFilter = new QFilter("selfclass.longnumber", "=", (Object)searchText);
            qFilter.or(new QFilter("ecclass.longnumber", "=", (Object)searchText));
            if (classField.contains("like")) {
                qFilter = new QFilter("selfclass.longnumber", "like", (Object)("%" + searchText + "%"));
                qFilter.or(new QFilter("ecclass.longnumber", "like", (Object)("%" + searchText + "%")));
            }
        }
        boolean isContainSelf = true;
        ArrayList<String> keyWords = new ArrayList<String>(8);
        if (!StringUtils.isEmpty((CharSequence)sources)) {
            for (String source : sources.split(",")) {
                if (!StringUtils.isNotBlank((CharSequence)source)) continue;
                keyWords.add(source);
            }
            if (!keyWords.contains("1")) {
                isContainSelf = false;
            }
        }
        DynamicObjectCollection infoCols = QueryServiceHelper.query((String)"pmm_categoryunion", (String)SELCTORS, (QFilter[])qFilter.toArray());
        HashSet<PmmCategoryMappingInfo> classInfos = new HashSet<PmmCategoryMappingInfo>(16);
        for (DynamicObject info : infoCols) {
            String selfClassName = info.getString("selfclass.name");
            String platform = info.getString("platform");
            if (StringUtils.isEmpty((CharSequence)sources)) {
                classInfos.add(this.getEcInfo(info));
                classInfos.add(this.getSelfInfo(info));
                continue;
            }
            if (isContainSelf) {
                if (selfClassName.contains(searchText)) {
                    classInfos.add(this.getEcInfo(info));
                    classInfos.add(this.getSelfInfo(info));
                    continue;
                }
                if (!keyWords.contains(platform)) continue;
                classInfos.add(this.getSelfInfo(info));
                classInfos.add(this.getEcInfo(info));
                continue;
            }
            if (!keyWords.contains(platform)) continue;
            classInfos.add(this.getSelfInfo(info));
            classInfos.add(this.getEcInfo(info));
        }
        HashSet<PmmCategoryMappingInfo> newClassInfos = new HashSet<PmmCategoryMappingInfo>(16);
        Set<String> enableStandardPlats = this.getEnableStandardPlats();
        for (PmmCategoryMappingInfo info : classInfos) {
            if (enableStandardPlats.contains(info.getPalform())) continue;
            newClassInfos.add(info);
        }
        return newClassInfos;
    }

    public Set<PmmCategoryMappingInfo> getCategorySetCustomEsFilterFields(List<EsFilterField> newEsFilterFields) {
        HashSet<PmmCategoryMappingInfo> categorySet = new HashSet<PmmCategoryMappingInfo>(16);
        List<QFilter> qFilters = this.getQFiltreByCustomEsFilterFields(newEsFilterFields, true);
        if (qFilters.size() == 0) {
            return categorySet;
        }
        DynamicObjectCollection infoCols = QueryServiceHelper.query((String)"pmm_categoryunion", (String)SELCTORS, (QFilter[])qFilters.toArray(new QFilter[0]));
        for (DynamicObject info : infoCols) {
            this.setCategorySet(info, categorySet);
        }
        return categorySet;
    }

    private List<QFilter> getQFiltreByCustomEsFilterFields(List<EsFilterField> newEsFilterFields, boolean isContainEc) {
        QFilter classNoQFilter = this.getClassNoQFilter(newEsFilterFields, isContainEc);
        QFilter classNameQFilter = this.getClassNameQFilter(newEsFilterFields, isContainEc);
        QFilter classIdQFilter = this.getClassIdQFilter(newEsFilterFields, isContainEc);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
        if (null != classNoQFilter) {
            qFilters.add(classNoQFilter);
        }
        if (null != classNameQFilter) {
            qFilters.add(classNameQFilter);
        }
        if (null != classIdQFilter) {
            qFilters.add(classIdQFilter);
        }
        return qFilters;
    }

    private QFilter getClassIdQFilter(List<EsFilterField> newEsFilterFields, boolean isContainEc) {
        QFilter qFilter = null;
        for (EsFilterField esFilterField : newEsFilterFields) {
            if (!"classid".equals(esFilterField.getName())) continue;
            QFilter classQNoqFilter = new QFilter("selfclass.id", esFilterField.getCp(), (Object)esFilterField.getKeywords());
            if (isContainEc) {
                classQNoqFilter.or(new QFilter("ecclass.id", esFilterField.getCp(), (Object)esFilterField.getKeywords()));
            }
            if ((esFilterField.getCp().equals("=") || esFilterField.getCp().equals("match") || esFilterField.getCp().equals("like") || esFilterField.getCp().equals("not like") || esFilterField.getCp().equals("!=")) && esFilterField.getKeywords().length > 0) {
                classQNoqFilter = new QFilter("selfclass.id", esFilterField.getCp(), esFilterField.getKeywords()[0]);
                if (isContainEc) {
                    classQNoqFilter.or(new QFilter("ecclass.id", esFilterField.getCp(), esFilterField.getKeywords()[0]));
                }
            }
            if (null == qFilter) {
                qFilter = classQNoqFilter;
                continue;
            }
            qFilter.and(classQNoqFilter);
        }
        return qFilter;
    }

    private QFilter getClassNoQFilter(List<EsFilterField> newEsFilterFields, boolean isContainEc) {
        QFilter qFilter = null;
        for (EsFilterField esFilterField : newEsFilterFields) {
            if (!"classnumber".equals(esFilterField.getName())) continue;
            QFilter classQNoqFilter = new QFilter("selfclass.number", esFilterField.getCp(), (Object)esFilterField.getKeywords());
            if (isContainEc) {
                classQNoqFilter.or(new QFilter("ecclass.number", esFilterField.getCp(), (Object)esFilterField.getKeywords()));
            }
            if ((esFilterField.getCp().equals("=") || esFilterField.getCp().equals("match") || esFilterField.getCp().equals("like") || esFilterField.getCp().equals("not like") || esFilterField.getCp().equals("!=")) && esFilterField.getKeywords().length > 0) {
                classQNoqFilter = new QFilter("selfclass.number", esFilterField.getCp(), esFilterField.getKeywords()[0]);
                if (isContainEc) {
                    classQNoqFilter.or(new QFilter("ecclass.number", esFilterField.getCp(), esFilterField.getKeywords()[0]));
                }
            }
            if (null == qFilter) {
                qFilter = classQNoqFilter;
                continue;
            }
            qFilter.and(classQNoqFilter);
        }
        return qFilter;
    }

    private QFilter getClassNameQFilter(List<EsFilterField> newEsFilterFields, boolean isContainEc) {
        QFilter qFilter = null;
        for (EsFilterField esFilterField : newEsFilterFields) {
            if (!"classname".equals(esFilterField.getName())) continue;
            QFilter classQNameqFilter = new QFilter("selfclass.name", esFilterField.getCp(), (Object)esFilterField.getKeywords());
            if (isContainEc) {
                classQNameqFilter.or(new QFilter("ecclass.name", esFilterField.getCp(), (Object)esFilterField.getKeywords()));
            }
            if ((esFilterField.getCp().equals("=") || esFilterField.getCp().equals("match") || esFilterField.getCp().equals("like") || esFilterField.getCp().equals("not like") || esFilterField.getCp().equals("!=")) && esFilterField.getKeywords().length > 0) {
                classQNameqFilter = new QFilter("selfclass.name", esFilterField.getCp(), esFilterField.getKeywords()[0]);
                if (isContainEc) {
                    classQNameqFilter.or(new QFilter("ecclass.name", esFilterField.getCp(), esFilterField.getKeywords()[0]));
                }
            }
            if (null == qFilter) {
                qFilter = classQNameqFilter;
                continue;
            }
            qFilter.and(classQNameqFilter);
        }
        return qFilter;
    }

    private void setCategorySet(DynamicObject info, Set<PmmCategoryMappingInfo> categorySet) {
        PmmCategoryMappingInfo selfInfo = this.getSelfInfo(info);
        categorySet.add(selfInfo);
        PmmCategoryMappingInfo ecInfo = this.getEcInfo(info);
        categorySet.add(ecInfo);
    }

    private PmmCategoryMappingInfo getEcInfo(DynamicObject info) {
        PmmCategoryMappingInfo ecInfo = new PmmCategoryMappingInfo();
        ecInfo.setId(Long.valueOf(info.getLong("ecclass.id")));
        ecInfo.setName(info.getString("ecclass.name"));
        ecInfo.setLongNumber(info.getString("ecclass.longnumber"));
        ecInfo.setNumber(info.getString("ecclass.number"));
        ecInfo.setPalform(info.getString("platform"));
        ecInfo.setMappingSelfClassId(Long.valueOf(info.getLong("selfclass.id")));
        return ecInfo;
    }

    private PmmCategoryMappingInfo getSelfInfo(DynamicObject info) {
        PmmCategoryMappingInfo selfInfo = new PmmCategoryMappingInfo();
        selfInfo.setId(Long.valueOf(info.getLong("selfclass.id")));
        selfInfo.setName(info.getString("selfclass.name"));
        selfInfo.setNumber(info.getString("selfclass.number"));
        selfInfo.setLongNumber(info.getString("selfclass.longnumber"));
        selfInfo.setPalform("1");
        HashSet<Long> ecIds = new HashSet<Long>(16);
        ecIds.add(info.getLong("ecclass.id"));
        selfInfo.setMappingEcClassIds(ecIds);
        return selfInfo;
    }
}

