/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.business.service.impl;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.util.MalOrderParamUtil;
import kd.scm.common.util.ParamUtil;
import kd.scm.malcore.domain.GoodsMonitorLog;
import kd.scm.malcore.domain.GoodsMonitorRuleLog;
import kd.scm.pmm.business.service.IPmmGoodsMonitorLogService;
import kd.scm.pmm.business.service.impl.ProdPoolCommandServiceImpl;
import kd.sdk.scm.pmm.extpoint.MonitorRuleServiceParam;
import kd.sdk.scm.pmm.extpoint.MonitorRuleServiceResult;

public class PmmGoodsMonitorLogServiceImpl
implements IPmmGoodsMonitorLogService {
    private static final Log log = LogFactory.getLog((String)PmmGoodsMonitorLogServiceImpl.class.getName());
    private static final long SAMERULEID = 1893437194405041152L;

    private boolean getIsGoodsMonitor() {
        String selectors = "isgoodsmonitor";
        QFilter qFilter = new QFilter("id", "=", (Object)1893437194405041152L);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"pmm_samegoodsrule", (String)selectors, (QFilter[])qFilter.toArray());
        if (null != dynamicObject) {
            return dynamicObject.getBoolean("isgoodsmonitor");
        }
        return false;
    }

    @Override
    public Collection<GoodsMonitorLog> queryMonitorLogsByGoods(List<String> goodsIds, List<Long> goodsPoolIds) {
        log.info("queryMonitorLogsByGoods_param_goodsIds=" + SerializationUtils.toJsonString(goodsIds));
        log.info("queryMonitorLogsByGoods_param_goodsPoolIds=" + SerializationUtils.toJsonString(goodsPoolIds));
        if (!this.getIsGoodsMonitor()) {
            return null;
        }
        HashSet<Long> newGoodsIds = new HashSet<Long>(16);
        for (String goodId : goodsIds) {
            newGoodsIds.add(Long.parseLong(goodId));
        }
        QFilter qFilter = new QFilter("dealstatus", "=", (Object)"A");
        qFilter.and(new QFilter("goodsid", "in", newGoodsIds));
        String selectors = "goodsid,goodsnum,goodspool.id,rulelogentry.controltype,rulelogentry.rule.id,rulelogentry.rule.name,platform";
        DynamicObjectCollection pmmGoodsruleLogs = QueryServiceHelper.query((String)"pmm_goodsrulelog", (String)selectors, (QFilter[])qFilter.toArray());
        HashMap<String, GoodsMonitorLog> resultMap = new HashMap<String, GoodsMonitorLog>(16);
        for (DynamicObject row : pmmGoodsruleLogs) {
            ArrayList<GoodsMonitorRuleLog> goodsMonitorRuleLogs;
            String controltype;
            String platform = row.getString("platform");
            long goodsPoolId = row.getLong("goodspool.id");
            String goodsid = row.getString("goodsid");
            GoodsMonitorLog goodsMonitorLog = new GoodsMonitorLog();
            if (EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(platform) && !goodsPoolIds.contains(goodsPoolId) || !"1".equals(controltype = row.getString("rulelogentry.controltype")) && !"2".equals(controltype)) continue;
            if (null != resultMap.get(goodsid)) {
                goodsMonitorLog = (GoodsMonitorLog)resultMap.get(goodsid);
            }
            if (!StringUtils.isEmpty((CharSequence)goodsid)) {
                goodsMonitorLog.setGoodsId(Long.parseLong(goodsid));
            }
            goodsMonitorLog.setGoodsNum(row.getString("goodsnum"));
            goodsMonitorLog.setSource(platform);
            if (0L != goodsPoolId) {
                goodsMonitorLog.setGoodsPoolId(goodsPoolId);
            }
            if (null == (goodsMonitorRuleLogs = goodsMonitorLog.getGoodsMonitorRuleLogs())) {
                goodsMonitorRuleLogs = new ArrayList<GoodsMonitorRuleLog>(16);
            }
            GoodsMonitorRuleLog goodsMonitorRuleLog = new GoodsMonitorRuleLog();
            goodsMonitorRuleLog.setRuleId(row.getLong("rulelogentry.rule.id"));
            goodsMonitorRuleLog.setRuleName(row.getString("rulelogentry.rule.name"));
            goodsMonitorRuleLog.setControlType(row.getString("rulelogentry.controltype"));
            goodsMonitorRuleLogs.add(goodsMonitorRuleLog);
            goodsMonitorLog.setGoodsMonitorRuleLogs(goodsMonitorRuleLogs);
            resultMap.put(goodsid, goodsMonitorLog);
        }
        log.info("queryMonitorLogsByGoods_resultMap=" + SerializationUtils.toJsonString(resultMap.values()));
        return resultMap.values();
    }

    @Override
    public void addMonitorLogInfos(MonitorRuleServiceParam param, List<MonitorRuleServiceResult> results) {
        log.info("param=" + SerializationUtils.toJsonString((Object)param));
        log.info("results=" + SerializationUtils.toJsonString(results));
        DynamicObjectCollection goodsInfo = this.getGoodsInfo(param);
        String defaultCurrency = null;
        Long ecSupplierId = 0L;
        if (!EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(param.getPlatform())) {
            defaultCurrency = MalOrderParamUtil.getDefaultCurrency();
            ecSupplierId = this.getEcSupplierId(param);
        }
        if (null != goodsInfo && goodsInfo.size() > 0 && results.size() > 0) {
            String ecProductOpStr;
            boolean ecProductOp;
            boolean isDown = false;
            ArrayList<DynamicObject> addLogInfos = new ArrayList<DynamicObject>(16);
            for (MonitorRuleServiceResult result : results) {
                if (!result.getIsAutoDown()) continue;
                isDown = true;
                break;
            }
            if (!EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(param.getPlatform()) && !(ecProductOp = Boolean.parseBoolean(ecProductOpStr = ParamUtil.getSysCtrlParam((String)"UUPIH+47DAK", (String)"ec_product_op")))) {
                isDown = false;
            }
            DynamicObject info = this.getLogInfo(param, results, (DynamicObject)goodsInfo.get(0), defaultCurrency);
            if (!EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(param.getPlatform())) {
                if (null != defaultCurrency) {
                    info.set("curr_id", (Object)Long.parseLong(defaultCurrency));
                }
                info.set("supplier_id", (Object)ecSupplierId);
            }
            addLogInfos.add(info);
            try (TXHandle t = TX.required();){
                if (isDown) {
                    info.set("dealstatus", (Object)"B");
                    info.set("result", (Object)"1");
                    this.goodsAutoDown(param, goodsInfo, ecSupplierId);
                }
                OperateOption option = OperateOption.create();
                option.setVariableValue("ishasright", String.valueOf(true));
                option.setVariableValue("isStrict", String.valueOf(false));
                OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)"pmm_goodsrulelog", (DynamicObject[])addLogInfos.toArray(new DynamicObject[0]), (OperateOption)option);
                if (!saveResult.isSuccess()) {
                    log.info(ExceptionUtil.getErrorInfoDetails((List)saveResult.getAllErrorOrValidateInfo()));
                    throw new KDBizException(ExceptionUtil.getErrorInfoDetails((List)saveResult.getAllErrorOrValidateInfo()));
                }
            }
        }
    }

    private void goodsAutoDown(MonitorRuleServiceParam param, DynamicObjectCollection goodsInfo, Long ecSupplierId) {
        DynamicObject downReq = this.createDownReq(param, goodsInfo, ecSupplierId);
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", String.valueOf(true));
        option.setVariableValue("isStrict", String.valueOf(false));
        option.setVariableValue("isStrict", String.valueOf(false));
        option.setVariableValue("WF", String.valueOf(false));
        String formId = "";
        formId = !EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(param.getPlatform()) ? "pmm_ecprodaudit" : "pmm_prodaudit";
        OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)formId, (DynamicObject[])new DynamicObject[]{downReq}, (OperateOption)option);
        List successPkIds = new ArrayList(16);
        if (saveResult.isSuccess()) {
            successPkIds = saveResult.getSuccessPkIds();
            OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)formId, (Object[])successPkIds.toArray(), (OperateOption)option);
            if (!submitResult.isSuccess()) {
                OperationResult deleteResult = OperationServiceHelper.executeOperate((String)"delete", (String)formId, (Object[])successPkIds.toArray(), (OperateOption)option);
                if (!deleteResult.isSuccess()) {
                    log.info(ExceptionUtil.getErrorInfoDetails((List)saveResult.getAllErrorOrValidateInfo()));
                    throw new KDBizException(ExceptionUtil.getErrorInfoDetails((List)deleteResult.getAllErrorOrValidateInfo()));
                }
                log.info(ExceptionUtil.getErrorInfoDetails((List)saveResult.getAllErrorOrValidateInfo()));
                throw new KDBizException(ExceptionUtil.getErrorInfoDetails((List)submitResult.getAllErrorOrValidateInfo()));
            }
        } else {
            log.info(ExceptionUtil.getErrorInfoDetails((List)saveResult.getAllErrorOrValidateInfo()));
            throw new KDBizException(ExceptionUtil.getErrorInfoDetails((List)saveResult.getAllErrorOrValidateInfo()));
        }
        if (!EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(param.getPlatform())) {
            OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)formId, (Object[])successPkIds.toArray(), (OperateOption)option);
            if (!auditResult.isSuccess()) {
                log.info(ExceptionUtil.getErrorInfoDetails((List)saveResult.getAllErrorOrValidateInfo()));
                throw new KDBizException(ExceptionUtil.getErrorInfoDetails((List)auditResult.getAllErrorOrValidateInfo()));
            }
        } else {
            ProdPoolCommandServiceImpl prodPoolCommandService = new ProdPoolCommandServiceImpl();
            ArrayList<Long> idList = new ArrayList<Long>(saveResult.getSuccessPkIds().size());
            for (Object id : saveResult.getSuccessPkIds()) {
                idList.add(Long.parseLong(String.valueOf(id)));
            }
            if (idList.size() > 0) {
                DynamicObject[] pmmProdAudits;
                QFilter qFilter = new QFilter("id", "in", idList);
                for (DynamicObject pmmProdAudit : pmmProdAudits = BusinessDataServiceHelper.load((String)formId, (String)"cfmstatus,cfm,suggestion,cfmdate,entryentity.entryresult", (QFilter[])qFilter.toArray())) {
                    pmmProdAudit.set("cfmstatus", (Object)"B");
                    pmmProdAudit.set("cfm", (Object)RequestContext.get().getCurrUserId());
                    pmmProdAudit.set("cfmdate", (Object)TimeServiceHelper.now());
                    DynamicObjectCollection entryCols = pmmProdAudit.getDynamicObjectCollection("entryentity");
                    for (DynamicObject row : entryCols) {
                        row.set("entryresult", (Object)"1");
                    }
                }
                if (pmmProdAudits.length > 0) {
                    SaveServiceHelper.save((DynamicObject[])pmmProdAudits);
                }
            }
            prodPoolCommandService.prodAuditCfm(idList);
        }
    }

    private DynamicObject createDownReq(MonitorRuleServiceParam param, DynamicObjectCollection goodsInfo, Long ecSupplierId) {
        DynamicObject prodReq = null;
        if (!EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(param.getPlatform())) {
            prodReq = ORM.create().newDynamicObject("pmm_ecprodaudit");
            this.setEcProdInfo(prodReq, (DynamicObject)goodsInfo.get(0), ecSupplierId);
        } else {
            prodReq = ORM.create().newDynamicObject("pmm_prodaudit");
            this.setSelfProdInfo(prodReq, goodsInfo);
        }
        return prodReq;
    }

    private void setEcProdInfo(DynamicObject prodReq, DynamicObject goodsInfo, Long ecSupplierId) {
        prodReq.set("org_id", (Object)RequestContext.get().getOrgId());
        prodReq.set("billdate", (Object)TimeServiceHelper.now());
        prodReq.set("supplier_id", (Object)ecSupplierId);
        prodReq.set("biztype", (Object)"2");
        prodReq.set("billstatus", (Object)"A");
        String msg = ResManager.loadKDString((String)"\u7cfb\u7edf\u81ea\u52a8\u5de1\u68c0\u89e6\u53d1\u9608\u503c\u540e\u751f\u6210\u4e0b\u67b6\u5355\u3002", (String)"PmmGoodsMonitorLogService_0", (String)"scm-pmm-business", (Object[])new Object[0]);
        prodReq.set("remark", (Object)msg);
        prodReq.set("platform", (Object)goodsInfo.getString("source"));
        DynamicObjectCollection entryentity = prodReq.getDynamicObjectCollection("entryentity");
        DynamicObject row = entryentity.addNew();
        row.set("seq", (Object)1);
        row.set("goods_id", (Object)goodsInfo.getLong("id"));
        row.set("barcode", (Object)goodsInfo.getString("barcode"));
        row.set("unit_id", (Object)goodsInfo.getLong("unitid"));
        row.set("class_id", (Object)goodsInfo.getLong("category"));
        row.set("taxprice", (Object)goodsInfo.getBigDecimal("taxprice"));
        row.set("price", (Object)goodsInfo.getBigDecimal("price"));
        row.set("shopprice", (Object)goodsInfo.getBigDecimal("mallprice"));
    }

    private void setSelfProdInfo(DynamicObject prodReq, DynamicObjectCollection goodsInfos) {
        DynamicObject goodsInfo = (DynamicObject)goodsInfos.get(0);
        prodReq.set("org_id", (Object)goodsInfo.getLong("auditorg"));
        prodReq.set("billdate", (Object)TimeServiceHelper.now());
        prodReq.set("supplier_id", (Object)goodsInfo.getLong("supplier"));
        prodReq.set("person_id", (Object)RequestContext.get().getUserId());
        prodReq.set("biztype", (Object)"2");
        prodReq.set("billstatus", (Object)"A");
        String msg = ResManager.loadKDString((String)"\u7cfb\u7edf\u81ea\u52a8\u5de1\u68c0\u89e6\u53d1\u9608\u503c\u540e\u751f\u6210\u4e0b\u67b6\u5355\u3002", (String)"PmmGoodsMonitorLogService_0", (String)"scm-pmm-business", (Object[])new Object[0]);
        prodReq.set("remark", (Object)msg);
        prodReq.set("protocolid_id", (Object)goodsInfo.getLong("protocol"));
        prodReq.set("bizpartner_id", (Object)goodsInfo.getLong("goods.supplier.bizpartner"));
        prodReq.set("origin", (Object)"2");
        prodReq.set("platform", (Object)EcPlatformEnum.ECPLATFORM_SELF.getVal());
        DynamicObjectCollection entryentity = prodReq.getDynamicObjectCollection("entryentity");
        DynamicObject row = entryentity.addNew();
        row.set("seq", (Object)1);
        row.set("goods_id", (Object)goodsInfo.getLong("id"));
        row.set("barcode", (Object)goodsInfo.getString("goods.barcode"));
        row.set("unit_id", (Object)goodsInfo.getLong("goods.unit"));
        row.set("class_id", (Object)goodsInfo.getLong("category"));
        row.set("priceinvaliddate", (Object)goodsInfo.getDate("priceinvaliddate"));
        row.set("priceeffectdate", (Object)goodsInfo.getDate("priceeffectdate"));
        row.set("pricetype", (Object)goodsInfo.getString("pricetype"));
        row.set("taxprice", (Object)goodsInfo.getBigDecimal("taxprice"));
        row.set("price", (Object)goodsInfo.getBigDecimal("price"));
        row.set("minorderqty", (Object)goodsInfo.getBigDecimal("minorderqty"));
        row.set("leadtime", (Object)goodsInfo.getInt("leadtime"));
        if (0L != goodsInfo.getLong("protocolentry")) {
            row.set("protocolentry_id", (Object)goodsInfo.getLong("protocolentry"));
            row.set("material_id", (Object)goodsInfo.getLong("protocolentry.material"));
            row.set("auxpty_id", goodsInfo.get("protocolentry.auxpty"));
        }
        row.set("shopprice", (Object)goodsInfo.getBigDecimal("taxprice"));
        row.set("entryresult", (Object)"B");
        row.set("note", (Object)"");
        if ("B".equals(goodsInfo.getString("pricetype"))) {
            DynamicObjectCollection subentryentity = row.getDynamicObjectCollection("subentryentity");
            for (DynamicObject subRow : goodsInfos) {
                DynamicObject sub = subentryentity.addNew();
                sub.set("qtyfrom", (Object)subRow.getBigDecimal("qtyfrom"));
                sub.set("qtyto", (Object)subRow.getBigDecimal("qtyto"));
                sub.set("ladprice", (Object)subRow.getBigDecimal("ladprice"));
            }
        }
    }

    private Long getEcSupplierId(MonitorRuleServiceParam param) {
        DynamicObjectCollection standardDyos;
        if (!param.getPlatform().equals(EcPlatformEnum.ECPLATFORM_SELF.getVal()) && (standardDyos = this.getStandardDyos(param.getPlatform())).size() > 0) {
            return ((DynamicObject)standardDyos.get(0)).getLong("malsupplier");
        }
        return 0L;
    }

    private DynamicObjectCollection getStandardDyos(String source) {
        QFilter qFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        qFilter.and(new QFilter("openstatus", "=", (Object)"2"));
        qFilter.and(new QFilter("platform", "=", (Object)source));
        qFilter.and(new QFilter("tenantid", "=", (Object)RequestContext.getOrCreate().getTenantId()));
        return QueryServiceHelper.query((String)"pmm_ecadmit", (String)"malsupplier", (QFilter[])new QFilter[]{qFilter}, (String)"platform desc");
    }

    private DynamicObject getLogInfo(MonitorRuleServiceParam param, List<MonitorRuleServiceResult> results, DynamicObject goodsInfo, String defaultCurrency) {
        DynamicObject info = ORM.create().newDynamicObject("pmm_goodsrulelog");
        info.set("dealstatus", (Object)"A");
        info.set("result", (Object)"4");
        info.set("updatedate", (Object)TimeServiceHelper.now());
        info.set("goodsnum", (Object)goodsInfo.getString("number"));
        info.set("goodsname", (Object)goodsInfo.getString("name"));
        info.set("goodsclass", (Object)goodsInfo.getLong("category"));
        info.set("taxprice", (Object)goodsInfo.getBigDecimal("taxprice"));
        info.set("goodsid", (Object)param.getGoodsId());
        if (param.getPlatform().equals(EcPlatformEnum.ECPLATFORM_SELF.getVal())) {
            info.set("curr_id", (Object)goodsInfo.getLong("curr"));
            info.set("goodspool_id", (Object)param.getGoodsPoolId());
            info.set("supplier_id", (Object)goodsInfo.getLong("supplier"));
            defaultCurrency = goodsInfo.getString("curr");
        }
        if (StringUtils.isEmpty((CharSequence)defaultCurrency)) {
            defaultCurrency = "0L";
        }
        DynamicObject currDyn = this.getCurrencyObj(Long.parseLong(defaultCurrency));
        info.set("platform", (Object)param.getPlatform());
        DynamicObjectCollection rulelogentry = info.getDynamicObjectCollection("rulelogentry");
        for (MonitorRuleServiceResult result : results) {
            DynamicObject row = rulelogentry.addNew();
            row.set("compareval", (Object)result.getCompareValue());
            row.set("comparegoods", (Object)result.getCompareObjId());
            row.set("goodstype", (Object)result.getCompareSource());
            row.set("cusparam_tag", (Object)result.getCustomObj());
            row.set("controltype", (Object)result.getBizOperate());
            row.set("rule_id", (Object)result.getRuleId());
            row.set("threshold", (Object)result.getThreshold());
            if (result.getThresholdType().equals("3") || result.getThresholdType().equals("1")) {
                if (!StringUtils.isEmpty((CharSequence)result.getActualVal()) && null != currDyn) {
                    BigDecimal val = new BigDecimal(result.getActualVal());
                    BigDecimal tarVal = val.setScale(currDyn.getInt("priceprecision"), RoundingMode.HALF_UP);
                    row.set("actualval", (Object)(currDyn.getString("sign") + tarVal));
                    continue;
                }
                row.set("actualval", (Object)result.getActualVal());
                continue;
            }
            row.set("actualval", (Object)result.getActualVal());
        }
        return info;
    }

    private DynamicObject getCurrencyObj(long defaultCurrency) {
        QFilter qFilter = new QFilter("id", "=", (Object)defaultCurrency);
        return QueryServiceHelper.queryOne((String)"bd_currency", (String)"sign,priceprecision", (QFilter[])qFilter.toArray());
    }

    private DynamicObjectCollection getGoodsInfo(MonitorRuleServiceParam param) {
        QFilter qFilter = null;
        String selectors = null;
        String formId = null;
        if (EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(param.getPlatform())) {
            qFilter = new QFilter("id", "=", (Object)param.getGoodsPoolId());
            formId = "pmm_prodpool";
            selectors = "price,goods.id id,goods.number number,goods.name name,taxprice,goods.category category,goods.curr curr,goods.supplier supplier,protocolentry,protocol,priceeffectdate,priceinvaliddate,minorderqty,leadtime,goods.barcode,auditorg,goods.supplier.bizpartner,goods.unit,pricetype,protocolentry.material,protocolentry.auxpty,priceentry.qtyfrom qtyfrom,priceentry.qtyto qtyto,priceentry.ladprice ladprice";
        } else {
            qFilter = new QFilter("id", "=", (Object)param.getGoodsId());
            formId = "pbd_mallgoods";
            selectors = "number,id,name,priceinfo.price taxprice,priceinfo.nakedprice price,group.id category,barcode,priceinfo.mallprice mallprice,unitid,source";
        }
        return QueryServiceHelper.query((String)formId, (String)selectors, (QFilter[])qFilter.toArray());
    }
}

