/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.business.service.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.scm.common.es.storage.EsFilterField;
import kd.scm.common.es.storage.EsResultVo;
import kd.scm.common.es.storage.EsSearchParam;
import kd.scm.common.es.storage.EsSortField;
import kd.scm.pmm.business.model.product.PmmProdObtain;
import kd.scm.pmm.business.model.product.ProductObtainResult;
import kd.scm.pmm.business.service.PmmProductObtainService;
import kd.scm.pmm.business.service.impl.AcquisitionModeEnum;

public class PmmProductObtainServiceImpl
implements PmmProductObtainService {
    private static final Log log = LogFactory.getLog((String)PmmProductObtainServiceImpl.class.getName());
    private static final Long DEFAULT_ESCONFIGID = 1560871593289408512L;
    private static final String SPLIT = "_";

    @Override
    public ProductObtainResult obtain(PmmProdObtain pmmProdObtain) {
        if (AcquisitionModeEnum.PLUGIN.getVal().equals(pmmProdObtain.getAcquisitionMode())) {
            return pmmProdObtain.getPlugin().obtain(pmmProdObtain);
        }
        return this.obtainFromEs(pmmProdObtain);
    }

    @Override
    public EsSearchParam getEsSearchParamByProdObtain(PmmProdObtain pmmProdObtain) {
        EsSearchParam esSearchParam = new EsSearchParam();
        if (AcquisitionModeEnum.CATEGORYS.getVal().equals(pmmProdObtain.getAcquisitionMode())) {
            if (pmmProdObtain.isSortInCategory()) {
                return this.getEsSearchParamBySortInCategory(pmmProdObtain);
            }
            return this.getEsSearchParamByCategorys(pmmProdObtain);
        }
        if (AcquisitionModeEnum.SUPPLIER.getVal().equals(pmmProdObtain.getAcquisitionMode())) {
            return this.getEsSearchParamBySupplier(pmmProdObtain);
        }
        if (AcquisitionModeEnum.SALES.getVal().equals(pmmProdObtain.getAcquisitionMode())) {
            return this.getEsSearchParamBySales(pmmProdObtain);
        }
        if (AcquisitionModeEnum.CUSTOM_FILTER.getVal().equals(pmmProdObtain.getAcquisitionMode())) {
            return this.getEsSearchParamByCustomFilter(pmmProdObtain);
        }
        if (AcquisitionModeEnum.CUSTOM_SELECT.getVal().equals(pmmProdObtain.getAcquisitionMode())) {
            return this.getEsSearchParamByCustomSelect(pmmProdObtain);
        }
        return esSearchParam;
    }

    private EsSearchParam getEsSearchParamBySortInCategory(PmmProdObtain pmmProdObtain) {
        ArrayList<EsFilterField> esFilterFields = new ArrayList<EsFilterField>(8);
        if (StringUtils.isNotBlank((CharSequence)pmmProdObtain.getPlatform())) {
            esFilterFields.add(new EsFilterField("source", "=", new Object[]{pmmProdObtain.getPlatform()}));
        }
        ProductObtainResult productObtainResult = new ProductObtainResult();
        int size = 0;
        for (Long categoryId : pmmProdObtain.getCategoryIds()) {
            EsFilterField esFilterField = new EsFilterField("classid", "=", new Object[]{categoryId});
            esFilterFields.add(esFilterField);
            ProductObtainResult categoryResult = this.searchFromEs(pmmProdObtain, this.getEsSearchParam(pmmProdObtain, esFilterFields));
            size += categoryResult.getSize();
            productObtainResult.getGoodsObjMap().putAll(categoryResult.getGoodsObjMap());
            esFilterFields.remove(esFilterField);
        }
        ArrayList<EsFilterField> esFilterFieldList = new ArrayList<EsFilterField>();
        esFilterFieldList.add(new EsFilterField("goodsid", "in", productObtainResult.getGoodsObjMap().keySet().toArray()));
        return this.getEsSearchParam(pmmProdObtain, esFilterFieldList);
    }

    private ProductObtainResult obtainFromEs(PmmProdObtain pmmProdObtain) {
        if (AcquisitionModeEnum.CATEGORYS.getVal().equals(pmmProdObtain.getAcquisitionMode())) {
            if (pmmProdObtain.isSortInCategory()) {
                return this.obtainIfSortInCategory(pmmProdObtain);
            }
            return this.obtainByCategorys(pmmProdObtain);
        }
        if (AcquisitionModeEnum.SUPPLIER.getVal().equals(pmmProdObtain.getAcquisitionMode())) {
            return this.obtainBySupplier(pmmProdObtain);
        }
        if (AcquisitionModeEnum.SALES.getVal().equals(pmmProdObtain.getAcquisitionMode())) {
            return this.obtainBySales(pmmProdObtain);
        }
        if (AcquisitionModeEnum.CUSTOM_FILTER.getVal().equals(pmmProdObtain.getAcquisitionMode())) {
            return this.obtainByCustomFilter(pmmProdObtain);
        }
        if (AcquisitionModeEnum.CUSTOM_SELECT.getVal().equals(pmmProdObtain.getAcquisitionMode())) {
            return this.obtainByCustomSelect(pmmProdObtain);
        }
        return new ProductObtainResult();
    }

    private ProductObtainResult obtainByCustomSelect(PmmProdObtain pmmProdObtain) {
        EsSearchParam searchParam = this.getEsSearchParamByCustomSelect(pmmProdObtain);
        return this.searchFromEs(pmmProdObtain, searchParam);
    }

    private EsSearchParam getEsSearchParamByCustomSelect(PmmProdObtain pmmProdObtain) {
        ArrayList<EsFilterField> esFilterFields = new ArrayList<EsFilterField>();
        esFilterFields.add(new EsFilterField("goodsid", "in", pmmProdObtain.getGoodsIdByCustomSelect().toArray()));
        return this.getEsSearchParam(pmmProdObtain, esFilterFields);
    }

    private ProductObtainResult obtainByCustomFilter(PmmProdObtain pmmProdObtain) {
        EsSearchParam searchParam = this.getEsSearchParamByCustomFilter(pmmProdObtain);
        return this.searchFromEs(pmmProdObtain, searchParam);
    }

    private EsSearchParam getEsSearchParamByCustomFilter(PmmProdObtain pmmProdObtain) {
        ArrayList<EsFilterField> esFilterFields = new ArrayList<EsFilterField>();
        if (StringUtils.isNotBlank((CharSequence)pmmProdObtain.getPlatform())) {
            esFilterFields.add(new EsFilterField("source", "=", new Object[]{pmmProdObtain.getPlatform()}));
        }
        esFilterFields.addAll(pmmProdObtain.getEsFilterFieldsByCustom());
        if (esFilterFields.isEmpty()) {
            return new EsSearchParam();
        }
        return this.getEsSearchParam(pmmProdObtain, esFilterFields);
    }

    private ProductObtainResult obtainBySales(PmmProdObtain pmmProdObtain) {
        return this.searchFromEs(pmmProdObtain, this.getEsSearchParamBySales(pmmProdObtain));
    }

    private EsSearchParam getEsSearchParamBySales(PmmProdObtain pmmProdObtain) {
        ArrayList<EsFilterField> esFilterFields = new ArrayList<EsFilterField>();
        if (StringUtils.isNotBlank((CharSequence)pmmProdObtain.getPlatform())) {
            esFilterFields.add(new EsFilterField("source", "=", new Object[]{pmmProdObtain.getPlatform()}));
        }
        return this.getEsSearchParam(pmmProdObtain, esFilterFields);
    }

    private ProductObtainResult obtainBySupplier(PmmProdObtain pmmProdObtain) {
        EsSearchParam searchParam = this.getEsSearchParamBySupplier(pmmProdObtain);
        return this.searchFromEs(pmmProdObtain, searchParam);
    }

    private EsSearchParam getEsSearchParamBySupplier(PmmProdObtain pmmProdObtain) {
        ArrayList<EsFilterField> esFilterFields = new ArrayList<EsFilterField>(8);
        if (StringUtils.isNotBlank((CharSequence)pmmProdObtain.getPlatform())) {
            esFilterFields.add(new EsFilterField("source", "=", new Object[]{pmmProdObtain.getPlatform()}));
        }
        if (pmmProdObtain.getSupplierId() != null && pmmProdObtain.getSupplierId() != 0L) {
            esFilterFields.add(new EsFilterField("supplierid", "=", new Object[]{pmmProdObtain.getSupplierId()}));
        }
        return this.getEsSearchParam(pmmProdObtain, esFilterFields);
    }

    private ProductObtainResult obtainByCategorys(PmmProdObtain pmmProdObtain) {
        EsSearchParam searchParam = this.getEsSearchParamByCategorys(pmmProdObtain);
        return this.searchFromEs(pmmProdObtain, searchParam);
    }

    private EsSearchParam getEsSearchParamByCategorys(PmmProdObtain pmmProdObtain) {
        ArrayList<EsFilterField> esFilterFields = new ArrayList<EsFilterField>(8);
        if (StringUtils.isNotBlank((CharSequence)pmmProdObtain.getPlatform())) {
            esFilterFields.add(new EsFilterField("source", "=", new Object[]{pmmProdObtain.getPlatform()}));
        }
        EsFilterField esFilterField = new EsFilterField("classid", "in", pmmProdObtain.getCategoryIds().toArray());
        esFilterFields.add(esFilterField);
        return this.getEsSearchParam(pmmProdObtain, esFilterFields);
    }

    private ProductObtainResult obtainIfSortInCategory(PmmProdObtain pmmProdObtain) {
        ArrayList<EsFilterField> esFilterFields = new ArrayList<EsFilterField>(8);
        if (StringUtils.isNotBlank((CharSequence)pmmProdObtain.getPlatform())) {
            esFilterFields.add(new EsFilterField("source", "=", new Object[]{pmmProdObtain.getPlatform()}));
        }
        ProductObtainResult productObtainResult = new ProductObtainResult();
        int size = 0;
        for (Long categoryId : pmmProdObtain.getCategoryIds()) {
            EsFilterField esFilterField = new EsFilterField("classid", "=", new Object[]{categoryId});
            esFilterFields.add(esFilterField);
            ProductObtainResult categoryResult = this.searchFromEs(pmmProdObtain, this.getEsSearchParam(pmmProdObtain, esFilterFields));
            size += categoryResult.getSize();
            productObtainResult.getGoodsObjMap().putAll(categoryResult.getGoodsObjMap());
            esFilterFields.remove(esFilterField);
        }
        productObtainResult.setSize(size);
        return productObtainResult;
    }

    private ProductObtainResult searchFromEs(PmmProdObtain pmmProdObtain, EsSearchParam searchParam) {
        ProductObtainResult productObtainResult = new ProductObtainResult();
        Long goodsEsConfigId = pmmProdObtain.getGoodsEsConfigId() == null || pmmProdObtain.getGoodsEsConfigId() == 0L ? DEFAULT_ESCONFIGID : pmmProdObtain.getGoodsEsConfigId();
        EsResultVo esResultVo = (EsResultVo)DispatchServiceHelper.invokeBizService((String)"scm", (String)"pbd", (String)"PbdEsSearchService", (String)"search", (Object[])new Object[]{searchParam, goodsEsConfigId});
        log.info("obtainFromEs:" + productObtainResult);
        List resultData = esResultVo.getResultData();
        LinkedHashMap<Long, Map<String, Object>> goodsObjMap = new LinkedHashMap<Long, Map<String, Object>>(resultData.size());
        HashSet<String> sourceSet = new HashSet<String>(resultData.size());
        for (Map goodsObj : resultData) {
            Long goodsId = Long.valueOf(String.valueOf(goodsObj.get("goodsid")));
            sourceSet.add(String.valueOf(goodsObj.get("sourcce")));
            goodsObjMap.put(goodsId, goodsObj);
        }
        if (sourceSet.size() == 1) {
            for (String source : sourceSet) {
                productObtainResult.setPlatform(source);
            }
        }
        productObtainResult.setSize(goodsObjMap.size());
        productObtainResult.setGoodsObjMap(goodsObjMap);
        return productObtainResult;
    }

    private EsSearchParam getEsSearchParam(PmmProdObtain pmmProdObtain, List<EsFilterField> esFilterFields) {
        EsSearchParam searchParam = new EsSearchParam();
        esFilterFields.add(this.getMallstatusFilter());
        esFilterFields.add(this.getOrgEsFilter());
        if (StringUtils.isNotBlank((CharSequence)pmmProdObtain.getOrderBy())) {
            String sort = pmmProdObtain.getOrderBy();
            if ("sales".equals(pmmProdObtain.getOrderBy())) {
                sort = pmmProdObtain.getOrderBy() + SPLIT + "false";
            }
            EsSortField sortField = new EsSortField(sort.split(SPLIT)[0], Boolean.parseBoolean(sort.split(SPLIT)[1]));
            searchParam.setEsSortFields(new EsSortField[]{sortField});
        }
        searchParam.setEsFilterFields(esFilterFields);
        searchParam.setPageNum(0);
        if ("6".equals(pmmProdObtain.getAcquisitionMode())) {
            searchParam.setPageSize(999);
        } else {
            searchParam.setPageSize(pmmProdObtain.getLimit() <= 0 ? 60 : pmmProdObtain.getLimit());
        }
        return searchParam;
    }

    private EsFilterField getOrgEsFilter() {
        EsFilterField res = new EsFilterField("isgoodvisible", "=", new Object[]{true});
        res.or(new EsFilterField("orgids", "in", new Object[]{RequestContext.get().getOrgId()}));
        return res;
    }

    private EsFilterField getMallstatusFilter() {
        return new EsFilterField("mallstatus", "=", new Object[]{"B"}).or(new EsFilterField("mallstatus", "=", new Object[]{"1"}));
    }
}

