/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.business.service.impl.rule;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.sdk.scm.pmm.extpoint.IOperateMonitorRuleService;
import kd.sdk.scm.pmm.extpoint.MonitorRuleServiceParam;
import kd.sdk.scm.pmm.extpoint.MonitorRuleServiceResult;

public class GoodsPurAmountOverRuleServiceImpl
implements IOperateMonitorRuleService {
    public MonitorRuleServiceResult isMatchMonitorRule(MonitorRuleServiceParam param, BigDecimal val) {
        MonitorRuleServiceResult result = new MonitorRuleServiceResult();
        result.setMatch(Boolean.FALSE.booleanValue());
        if (null == param || null == val) {
            return result;
        }
        long goodsId = param.getGoodsId();
        if (0L == goodsId) {
            return result;
        }
        QFilter qFilter = new QFilter("entryentity.goods.id", "=", (Object)goodsId);
        qFilter.and(new QFilter("billstatus", "=", (Object)"C"));
        QFilter entrtStatusQf = new QFilter("entryentity.entrystatus", "=", (Object)"A");
        entrtStatusQf.or(new QFilter("entryentity.entrystatus", "=", (Object)"B"));
        qFilter.and(entrtStatusQf);
        DynamicObjectCollection orders = QueryServiceHelper.query((String)"mal_order", (String)"entryentity.taxamount taxamount", (QFilter[])qFilter.toArray());
        BigDecimal sumAmount = BigDecimal.ZERO;
        for (DynamicObject order : orders) {
            if (null == order.getBigDecimal("taxamount")) continue;
            sumAmount = sumAmount.add(order.getBigDecimal("taxamount"));
        }
        if (sumAmount.compareTo(val) > 0) {
            result.setMatch(Boolean.TRUE.booleanValue());
            result.setCompareValue(val);
            result.setActualVal(String.valueOf(sumAmount));
        }
        return result;
    }
}

