/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.business.service.impl.rule;

import java.math.BigDecimal;
import java.math.RoundingMode;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.sdk.scm.pmm.extpoint.IOperateMonitorRuleService;
import kd.sdk.scm.pmm.extpoint.MonitorRuleServiceParam;
import kd.sdk.scm.pmm.extpoint.MonitorRuleServiceResult;

public class GoodsShoppriceOverTaxpriceRateRuleServiceImpl
implements IOperateMonitorRuleService {
    public MonitorRuleServiceResult isMatchMonitorRule(MonitorRuleServiceParam param, BigDecimal val) {
        BigDecimal div;
        MonitorRuleServiceResult result = new MonitorRuleServiceResult();
        if (EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(param.getPlatform())) {
            result.setMatch(Boolean.FALSE.booleanValue());
            return result;
        }
        if (null == val) {
            result.setMatch(Boolean.FALSE.booleanValue());
            return result;
        }
        BigDecimal price = param.getTaxPrice();
        BigDecimal mallprice = param.getShopPirce();
        if (null != price && null != mallprice && mallprice.compareTo(BigDecimal.ZERO) > 0 && price.compareTo(mallprice) > 0 && (div = price.subtract(mallprice).divide(mallprice, 4, RoundingMode.HALF_UP).multiply(new BigDecimal(100)).setScale(2)).compareTo(val) > 0) {
            result.setMatch(Boolean.TRUE.booleanValue());
            result.setCompareObjId(param.getGoodsId());
            result.setCompareValue(mallprice);
            result.setActualVal(div + "%");
            result.setCompareSource("pbd_mallgoods");
            return result;
        }
        result.setMatch(Boolean.FALSE.booleanValue());
        return result;
    }
}

