/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.opplugin;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.ecapi.jd.JdApiUtil;
import kd.scm.common.ecapi.util.EmalParamsUtil;
import kd.scm.common.util.ExceptionUtil;
import net.sf.json.JSONObject;

public class PmmAddressSaveOp
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog((String)PmmAddressSaveOp.class.getName());

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("address");
        e.getFieldKeys().add("mapaddress");
        e.getFieldKeys().add("jdaddressnum");
        e.getFieldKeys().add("wholeaddress");
        e.getFieldKeys().add("default");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        HashSet<Long> admindivisionIdSet = new HashSet<Long>(16);
        for (DynamicObject dynamicObject2 : dataEntities = e.getDataEntities()) {
            admindivisionIdSet.add(dynamicObject2.getLong("address"));
        }
        boolean hasJdToken = this.isHasJdToken();
        ArrayList<Long> addressIds = new ArrayList<Long>(dataEntities.length);
        Map admindivisionDynMap = BusinessDataServiceHelper.loadFromCache((Object[])admindivisionIdSet.toArray(new Object[0]), (String)"bd_admindivision");
        for (DynamicObject dynamicObject3 : dataEntities) {
            String addressId = dynamicObject3.getString("address");
            if (!hasJdToken || StringUtils.isEmpty((CharSequence)addressId) || StringUtils.equals((CharSequence)"null", (CharSequence)addressId)) continue;
            addressIds.add(Long.valueOf(addressId));
        }
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"bd_admindivision", (String)"id,number,name,fullname,level,country", (QFilter[])new QFilter[]{new QFilter("id", "in", addressIds)});
        Map<String, DynamicObject> idAndDivisionMap = dynamicObjectCollection.stream().collect(Collectors.toMap(dynamicObject -> dynamicObject.getString("id"), dynamicObject -> dynamicObject));
        StringBuilder logMesg = new StringBuilder();
        for (DynamicObject dynamicObject4 : dataEntities) {
            DynamicObject admindivisionDyn;
            this.handleWholeAddress(admindivisionDynMap, dynamicObject4);
            if (!hasJdToken || (admindivisionDyn = idAndDivisionMap.get(dynamicObject4.getString("address"))) == null || admindivisionDyn.getInt("level") < 2) continue;
            String adminFullName = admindivisionDyn.getString("fullname");
            String address = adminFullName + "_" + dynamicObject4.getString("mapaddress");
            String jdAdrNum = "";
            try {
                jdAdrNum = this.getJdAdrNumFromApi(address);
            }
            catch (Exception exception) {
                logMesg.append(ExceptionUtil.getStackTrace((Throwable)exception)).append(System.lineSeparator());
            }
            dynamicObject4.set("jdaddressnum", (Object)jdAdrNum);
        }
        if (logMesg.length() > 0) {
            log.warn(logMesg.toString());
        }
    }

    private boolean isHasJdToken() {
        List openedMalNos = EmalParamsUtil.getOpenedEmalNumberList();
        if (openedMalNos == null) {
            return false;
        }
        return openedMalNos.contains(EcPlatformEnum.ECPLATFORM_JD.getVal());
    }

    private void handleWholeAddress(Map<Object, DynamicObject> admindivisionDynMap, DynamicObject dynamicObject) {
        String mapaddress = dynamicObject.getString("mapaddress");
        DynamicObject admindivisionDyn = admindivisionDynMap.get(dynamicObject.getLong("address"));
        String fullName = admindivisionDyn.getString("fullname");
        dynamicObject.set("wholeaddress", (Object)(fullName + "_" + mapaddress));
    }

    private String getJdAdrNumFromApi(String address) {
        JSONObject jdAdr = JSONObject.fromObject((Object)JdApiUtil.getAddressJonString((String)address));
        StringBuilder sb = new StringBuilder();
        sb.append(jdAdr.getString("provinceId")).append('_').append(jdAdr.getString("cityId")).append('_').append(jdAdr.getString("countyId"));
        sb.append('_');
        if ("null".equals(jdAdr.getString("townId"))) {
            sb.append('0');
        } else {
            sb.append(jdAdr.getString("townId"));
        }
        return sb.toString();
    }
}

