/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.opplugin;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scm.common.store.SRMStoreDataTraceHelper;

public final class PmmBatchCategoryMappingBatchCreateOp
extends AbstractOperationServicePlugIn {
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject dynamicObject = e.getDataEntities()[0];
        Set<Long> childClassIds = this.getNewClassIds(dynamicObject);
        ArrayList<DynamicObject> newDynamicObjects = new ArrayList<DynamicObject>(childClassIds.size());
        for (Long childClassId : childClassIds) {
            DynamicObject newDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"pmm_categorymatmapping");
            newDynamicObject.set("creator", (Object)UserServiceHelper.getCurrentUserId());
            newDynamicObject.set("goodscategory", (Object)childClassId);
            newDynamicObject.set("materialgroup", (Object)dynamicObject.getLong("materialgroup_id"));
            newDynamicObjects.add(newDynamicObject);
        }
        SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])newDynamicObjects.toArray(new DynamicObject[0]));
    }

    private Set<Long> getNewClassIds(DynamicObject dynamicObject) {
        DynamicObject goodsCategory = dynamicObject.getDynamicObject("goodscategory");
        String longnumber = goodsCategory.getString("longnumber");
        Long classStandardId = goodsCategory.getLong("standard_id");
        QFilter f1 = new QFilter("longnumber", "like", (Object)(longnumber + ".%"));
        QFilter f2 = new QFilter("standard.id", "=", (Object)classStandardId);
        QFilter f3 = new QFilter("level", "=", (Object)3);
        QFilter f4 = new QFilter("enable", "=", (Object)"1");
        QFilter[] qFilters = new QFilter[]{f1, f2, f3, f4};
        HashSet<Long> childClassIds = new HashSet<Long>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"mdr_goodsclass", (String)"id", (QFilter[])qFilters, (String)"id");){
            dataSet.forEach(row -> childClassIds.add(row.getLong("id")));
        }
        dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"pmm_categorymatmapping", (String)"goodscategory", (QFilter[])new QFilter[]{new QFilter("goodscategory.id", "in", childClassIds)}, (String)"id");
        var12_12 = null;
        try {
            dataSet.forEach(row -> childClassIds.remove(row.getLong("goodscategory")));
        }
        catch (Throwable throwable) {
            var12_12 = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (var12_12 != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        var12_12.addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        return childClassIds;
    }
}

