/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.opplugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.constant.BillAssistConstant;

public class PmmCategoryMatMappingImportOp
extends BatchImportPlugin {
    protected boolean isForceBatch() {
        return true;
    }

    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        String number;
        HashMap<String, List<ImportBillData>> numberRowIndexMap = new HashMap<String, List<ImportBillData>>(billdatas.size());
        ArrayList<String> numberList = new ArrayList<String>(billdatas.size());
        HashMap<String, ImportBillData> standardDataMap = new HashMap<String, ImportBillData>(billdatas.size());
        Iterator<ImportBillData> iterator = billdatas.iterator();
        ArrayList<String> materialGroupNumbers = new ArrayList<String>(billdatas.size());
        Set<String> standardNumbers = this.getStandardNumbers();
        while (iterator.hasNext()) {
            ImportBillData data = iterator.next();
            StringBuilder msg = this.checkImportValid(data, standardNumbers);
            if (msg.length() > 0) {
                logger.log(Integer.valueOf(data.getStartIndex()), msg.toString()).fail();
                iterator.remove();
                continue;
            }
            Map goodscategory = (Map)data.getData().get((Object)"goodscategory");
            Map map = (Map)data.getData().get((Object)"standard");
            Map materialGroupData = (Map)data.getData().get((Object)"materialgroup");
            String standard = (String)map.get("number");
            number = (String)goodscategory.get("number");
            numberList.add(number);
            standardDataMap.put(standard, data);
            List numberQty = numberRowIndexMap.computeIfAbsent(number + "_" + standard, k -> new ArrayList());
            numberQty.add(data);
            materialGroupNumbers.add((String)materialGroupData.get("number"));
        }
        if (numberRowIndexMap.isEmpty()) {
            return;
        }
        QFilter qFilter = new QFilter("number", "in", numberList);
        qFilter.and("standard.number", "in", standardDataMap.keySet());
        Map<String, List<ImportBillData>> effectNumberRowIndexMap = this.getEffectNumberRowIndexMap(numberRowIndexMap, qFilter, billdatas, logger);
        for (Map.Entry entry : numberRowIndexMap.entrySet()) {
            String key = (String)entry.getKey();
            String[] keySplit = key.split("_");
            number = keySplit[0];
            String standard = keySplit[1];
            List numberRowIndex = (List)entry.getValue();
            String msg = ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u5546\u54c1\u5206\u7c7b.\u5206\u7c7b\u7f16\u7801\u201c{0}\u201d\u5728\u5546\u54c1\u5206\u7c7b\u6807\u51c6.\u5206\u7c7b\u6807\u51c6\u7f16\u7801\u201c{1}\u201d\u4e0b\u4e0d\u5b58\u5728\u3002", (String)"PmmCategoryMatMappingImportOp_6", (String)"scm-pmm-opplugin", (Object[])new Object[]{number, standard});
            Iterator iterator2 = numberRowIndex.iterator();
            while (iterator2.hasNext()) {
                ImportBillData data = (ImportBillData)iterator2.next();
                logger.log(Integer.valueOf(data.getStartIndex()), msg).fail();
                billdatas.remove(data);
            }
        }
        Set<String> materialGroups = this.getMaterialGroups(materialGroupNumbers);
        for (Map.Entry<String, List<ImportBillData>> entry : effectNumberRowIndexMap.entrySet()) {
            String number2 = entry.getKey().split("_")[0];
            List<ImportBillData> numberRowIndex = entry.getValue();
            if (numberRowIndex.size() > 1) {
                String msg = ResManager.loadKDString((String)"\u5b58\u5728\u91cd\u590d\u5546\u54c1\u5206\u7c7b.\u5206\u7c7b\u7f16\u7801\u201c{0}\u201d\u5173\u8054\u7269\u6599\u5206\u7c7b\uff0c\u8bf7\u8c03\u6574\u4e00\u4e2a\u5546\u54c1\u5206\u7c7b\u4ec5\u80fd\u5173\u8054\u4e00\u4e2a\u7269\u6599\u5206\u7c7b\u3002", (String)"PmmCategoryMatMappingImportOp_0", (String)"scm-pmm-opplugin", (Object[])new Object[]{number2});
                for (ImportBillData data : numberRowIndex) {
                    logger.log(Integer.valueOf(data.getStartIndex()), msg).fail();
                    billdatas.remove(data);
                }
                continue;
            }
            ImportBillData importBillData = numberRowIndex.get(0);
            Map materialgroup = (Map)importBillData.getData().get((Object)"materialgroup");
            String materialNumber = (String)materialgroup.get("number");
            if (materialGroups.contains(materialNumber)) continue;
            String msg = ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u7269\u6599\u5206\u7c7b.\u7f16\u7801\u201c{0}\u201d\u5728\u6807\u51c6\u5206\u7c7b\u4e0b\u5df2\u7981\u7528\u6216\u4e0d\u5b58\u5728\uff0c\u8bf7\u8c03\u6574\u3002", (String)"PmmCategoryMatMappingImportOp_8", (String)"scm-pmm-opplugin", (Object[])new Object[]{materialNumber});
            logger.log(Integer.valueOf(importBillData.getStartIndex()), msg).fail();
            billdatas.remove(importBillData);
        }
    }

    private Map<String, List<ImportBillData>> getEffectNumberRowIndexMap(Map<String, List<ImportBillData>> numberRowIndexMap, QFilter qFilter, List<ImportBillData> billdatas, ImportLogger logger) {
        HashMap<String, List<ImportBillData>> effectNumberRowIndexMap = new HashMap<String, List<ImportBillData>>(numberRowIndexMap.size());
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"mdr_goodsclass", (String)"id,number,standard.number standard,level,enable", (QFilter[])new QFilter[]{qFilter}, (String)"id");){
            dataSet.forEach(row -> {
                String number = row.getString("number");
                String standard = row.getString("standard");
                String key = number + "_" + standard;
                List effectBillData = (List)numberRowIndexMap.remove(key);
                if (effectBillData != null) {
                    if (row.getInteger("level") != 3) {
                        String msg = ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u5546\u54c1\u5206\u7c7b.\u5206\u7c7b\u7f16\u7801\u201c{0}\u201d\u4e3a\u975e\u4e09\u7ea7\u5206\u7c7b\uff0c\u8bf7\u6539\u4e3a\u4e09\u7ea7\u5206\u7c7b\u518d\u5bfc\u5165\u3002", (String)"PmmCategoryMatMappingImportOp_1", (String)"scm-pmm-opplugin", (Object[])new Object[]{number});
                        for (ImportBillData data : effectBillData) {
                            logger.log(Integer.valueOf(data.getStartIndex()), msg).fail();
                            billdatas.remove(data);
                        }
                    } else if (!"1".equals(row.getString("enable"))) {
                        String msg = ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u5546\u54c1\u5206\u7c7b.\u5206\u7c7b\u7f16\u7801\u201c{0}\u201d\u5df2\u7981\u7528\uff0c\u4e0d\u80fd\u5bfc\u5165\u3002", (String)"PmmCategoryMatMappingImportOp_7", (String)"scm-pmm-opplugin", (Object[])new Object[]{number});
                        for (ImportBillData data : effectBillData) {
                            logger.log(Integer.valueOf(data.getStartIndex()), msg).fail();
                            billdatas.remove(data);
                        }
                    } else {
                        effectNumberRowIndexMap.put(key, effectBillData);
                    }
                }
            });
        }
        return effectNumberRowIndexMap;
    }

    private StringBuilder checkImportValid(ImportBillData data, Set<String> standardNumbers) {
        Map goodscategory = (Map)data.getData().get((Object)"goodscategory");
        Map standardData = (Map)data.getData().get((Object)"standard");
        Map materialgroup = (Map)data.getData().get((Object)"materialgroup");
        StringBuilder msg = new StringBuilder();
        if (standardData == null) {
            msg.append(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5546\u54c1\u5206\u7c7b\u6807\u51c6\u201d\u3002", (String)"PmmCategoryMatMappingImportOp_2", (String)"scm-pmm-opplugin", (Object[])new Object[0]));
        }
        if (goodscategory == null) {
            msg.append(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5546\u54c1\u5206\u7c7b\u201d\u3002", (String)"PmmCategoryMatMappingImportOp_4", (String)"scm-pmm-opplugin", (Object[])new Object[0]));
        }
        if (materialgroup == null) {
            msg.append(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u7269\u6599\u5206\u7c7b\u201d\u3002", (String)"PmmCategoryMatMappingImportOp_5", (String)"scm-pmm-opplugin", (Object[])new Object[0]));
        }
        if (standardData == null || goodscategory == null || materialgroup == null) {
            return msg;
        }
        String standard = (String)standardData.get("number");
        if (!standardNumbers.contains(standard)) {
            msg.append(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u5546\u54c1\u5206\u7c7b\u6807\u51c6.\u5206\u7c7b\u6807\u51c6\u7f16\u7801\u201c{0}\u201d\u5df2\u7981\u7528\u6216\u4e0d\u5b58\u5728\uff0c\u4e0d\u80fd\u5bfc\u5165\u3002", (String)"PmmCategoryMatMappingImportOp_3", (String)"scm-pmm-opplugin", (Object[])new Object[]{standard}));
        }
        return msg;
    }

    private Set<String> getStandardNumbers() {
        QFilter qFilter = new QFilter("enable", "=", (Object)Boolean.TRUE).and(new QFilter("openstatus", "=", (Object)"2").and(new QFilter("tenantid", "=", (Object)RequestContext.getOrCreate().getTenantId())));
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"pmm_ecadmit", (String)"id,number,name,platform,standard.id,standard.number,standard.name", (QFilter[])new QFilter[]{qFilter}, (String)"platform desc");
        Set<String> numbers = dynamicObjects.stream().map(e -> e.getString("standard.number")).collect(Collectors.toSet());
        numbers.add("00000801");
        return numbers;
    }

    private Set<String> getMaterialGroups(List<String> materialGroupNumbers) {
        HashSet<String> materialGroups = new HashSet<String>(materialGroupNumbers.size());
        QFilter qFilter = new QFilter("number", "in", materialGroupNumbers);
        qFilter.and(new QFilter("standard", "=", (Object)BillAssistConstant.MATERIAL_STANDARD_ID));
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_materialgroup", (String)"number,standard", (QFilter[])qFilter.toArray(), null);){
            dataSet.forEach(row -> materialGroups.add(row.getString("number")));
        }
        return materialGroups;
    }
}

