/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.opplugin;

import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class PmmCategoryUnionDeleteOp
extends AbstractOperationServicePlugIn {
    private Set<Long> ecIds = new HashSet<Long>(16);
    private Set<Long> selfIds = new HashSet<Long>(16);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("ecclass.id");
        e.getFieldKeys().add("ecclass.number");
        e.getFieldKeys().add("selfclass.id");
        e.getFieldKeys().add("selfclass.number");
        e.getFieldKeys().add("platform");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        HashSet<Long> idSet = new HashSet<Long>(16);
        for (DynamicObject info : dataEntities) {
            if (0L == info.getLong("id")) continue;
            idSet.add(info.getLong("id"));
        }
        if (idSet.size() > 0) {
            QFilter qFilter = new QFilter("id", "in", idSet);
            DynamicObjectCollection pmm_categoryunion = QueryServiceHelper.query((String)"pmm_categoryunion", (String)"ecclass.id,selfclass.id", (QFilter[])qFilter.toArray());
            for (DynamicObject info : pmm_categoryunion) {
                this.ecIds.add(info.getLong("ecclass.id"));
                this.selfIds.add(info.getLong("selfclass.id"));
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        this.updateClassBlank(e);
    }

    private void updateClassBlank(AfterOperationArgs e) {
        QFilter qFilter = new QFilter("ecclass.id", "in", this.ecIds);
        qFilter.or(new QFilter("selfclass.id", "in", this.selfIds));
        DynamicObjectCollection pmm_categoryunion = QueryServiceHelper.query((String)"pmm_categoryunion", (String)"ecclass.id,selfclass.id", (QFilter[])qFilter.toArray());
        HashSet<Long> tarEcIds = new HashSet<Long>(16);
        HashSet<Long> tarSelfIds = new HashSet<Long>(16);
        for (DynamicObject info : pmm_categoryunion) {
            tarEcIds.add(info.getLong("ecclass.id"));
            tarSelfIds.add(info.getLong("selfclass.id"));
        }
        HashSet<Long> allUpdateClassIds = new HashSet<Long>(16);
        allUpdateClassIds.addAll(this.getDiffIdSet(this.ecIds, tarEcIds));
        allUpdateClassIds.addAll(this.getDiffIdSet(this.selfIds, tarSelfIds));
        this.updateClass(allUpdateClassIds, null);
    }

    private void updateClass(Set<Long> allClassIds, String desc) {
        DynamicObject[] dysArr;
        QFilter qFilter = new QFilter("id", "in", allClassIds);
        for (DynamicObject dys : dysArr = BusinessDataServiceHelper.load((String)"mdr_goodsclass", (String)"id,selfclassification", (QFilter[])qFilter.toArray())) {
            dys.set("selfclassification", (Object)desc);
        }
        SaveServiceHelper.save((DynamicObject[])dysArr);
    }

    private Set<Long> getDiffIdSet(Set<Long> ecIds, Set<Long> tarEcIds) {
        HashSet<Long> diffIdSet = new HashSet<Long>(16);
        for (long classId : ecIds) {
            if (tarEcIds.contains(classId)) continue;
            diffIdSet.add(classId);
        }
        return diffIdSet;
    }
}

