/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.opplugin;

import java.util.HashSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;

public class PmmEcProdAuditAuditOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("biztype");
        e.getFieldKeys().add("entryentity");
        e.getFieldKeys().add("goods.id");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        HashSet<Long> uploadGoodsIdSet = new HashSet<Long>(1024);
        HashSet<Long> downloadGoodsIdSet = new HashSet<Long>(1024);
        for (DynamicObject dynamicObject : dataEntities) {
            String biztype = dynamicObject.getString("biztype");
            DynamicObjectCollection entryCol = dynamicObject.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entryCol) {
                long goodsId = entry.getLong("goods.id");
                if ("1".equals(biztype)) {
                    uploadGoodsIdSet.add(goodsId);
                }
                if (!"2".equals(biztype)) continue;
                downloadGoodsIdSet.add(goodsId);
            }
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("isStrict", String.valueOf(false));
        option.setVariableValue("ishasright", String.valueOf(true));
        if (!uploadGoodsIdSet.isEmpty()) {
            Object uploadResult22;
            HashSet<Long> uploadStatusIdSet = new HashSet<Long>(uploadGoodsIdSet.size());
            Throwable throwable = null;
            try (DataSet uploadDs = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)"pbd_mallgoods_status", (String)"id", (QFilter[])new QFilter[]{new QFilter("mallgoods.id", "in", uploadGoodsIdSet)}, null);){
                for (Object row : uploadDs) {
                    uploadStatusIdSet.add(row.getLong("id"));
                }
                uploadResult22 = OperationServiceHelper.executeOperate((String)"mallupload", (String)"pbd_mallgoods_status", (Object[])uploadStatusIdSet.toArray(), (OperateOption)option);
                this.check((OperationResult)uploadResult22);
            }
            catch (Throwable uploadResult22) {
                Throwable throwable2 = uploadResult22;
                throw uploadResult22;
            }
            HashSet<Long> uploadPriceIdSet = new HashSet<Long>(uploadGoodsIdSet.size());
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)"pbd_mallgoods_price", (String)"id", (QFilter[])new QFilter[]{new QFilter("mallgoods.id", "in", uploadGoodsIdSet)}, null);
            uploadResult22 = null;
            try {
                for (Row row : dataSet) {
                    uploadPriceIdSet.add(row.getLong("id"));
                }
                OperationResult priceSaveResult = OperationServiceHelper.executeOperate((String)"save", (String)"pbd_mallgoods_price", (Object[])uploadPriceIdSet.toArray(), (OperateOption)option);
                this.check(priceSaveResult);
            }
            catch (Throwable priceSaveResult) {
                uploadResult22 = priceSaveResult;
                throw priceSaveResult;
            }
            finally {
                if (dataSet != null) {
                    if (uploadResult22 != null) {
                        try {
                            dataSet.close();
                        }
                        catch (Throwable priceSaveResult) {
                            ((Throwable)uploadResult22).addSuppressed(priceSaveResult);
                        }
                    } else {
                        dataSet.close();
                    }
                }
            }
        }
        if (!downloadGoodsIdSet.isEmpty()) {
            HashSet<Long> downloadStatusIdSet = new HashSet<Long>(1024);
            Throwable throwable = null;
            try (DataSet downloadDs = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)"pbd_mallgoods_status", (String)"id", (QFilter[])new QFilter[]{new QFilter("mallgoods.id", "in", downloadGoodsIdSet)}, null);){
                for (Object row : downloadDs) {
                    downloadStatusIdSet.add(row.getLong("id"));
                }
                OperationResult downloadResult = OperationServiceHelper.executeOperate((String)"malldownload", (String)"pbd_mallgoods_status", (Object[])downloadStatusIdSet.toArray(), (OperateOption)option);
                this.check(downloadResult);
            }
            catch (Throwable throwable3) {
                Throwable throwable4 = throwable3;
                throw throwable3;
            }
        }
    }

    private void check(OperationResult operationResult) {
        if (!operationResult.isSuccess()) {
            if (operationResult.getAllErrorOrValidateInfo().isEmpty()) {
                throw new KDBizException(operationResult.getMessage());
            }
            throw new KDBizException(((IOperateInfo)operationResult.getAllErrorOrValidateInfo().get(0)).getMessage());
        }
    }
}

