/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.opplugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.enums.BillStatusEnum;

public class PmmGoodsDeleteOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("protocolentry.prodpool");
        fieldKeys.add("spunumber");
        fieldKeys.add("mulmodel");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        this.getOption().setVariableValue("ignorerefentityids", "pmm_prodpool,ent_prodpool,pmm_spu,ent_spu,mal_browsinghistory");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        HashSet goodNumberSet;
        List validExtDataEntities = e.getValidExtDataEntities();
        ArrayList<Object> idList = new ArrayList<Object>((int)((double)validExtDataEntities.size() / 0.75));
        for (ExtendedDataEntity dataEntity : validExtDataEntities) {
            idList.add(dataEntity.getDataEntity().getPkValue());
        }
        boolean isCancel = false;
        QFilter entrygoodsIdFilter = new QFilter("entryentity.goods.id", "in", idList);
        QFilter[] filters = new QFilter[]{entrygoodsIdFilter};
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"mal_order", (String)"id,billno,entryentity.goods.number", (QFilter[])filters, (String)"entryentity.goods.number");){
            goodNumberSet = new HashSet();
            ds.forEach(row -> goodNumberSet.add(row.getString("entryentity.goods.number")));
            if (goodNumberSet.size() > 0) {
                isCancel = true;
                StringBuilder msgSb = new StringBuilder();
                msgSb.append(ResManager.loadKDString((String)"\u5546\u54c1", (String)"PmmGoodsDeleteOp_0", (String)"scm-pmm-opplugin", (Object[])new Object[0]));
                for (String goodNumer : goodNumberSet) {
                    msgSb.append(goodNumer).append('\n');
                }
                msgSb.append(ResManager.loadKDString((String)"\u6709\u5173\u8054\u5546\u57ce\u8ba2\u5355\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"PmmGoodsDeleteOp_1", (String)"scm-pmm-opplugin", (Object[])new Object[0]));
                e.setCancel(isCancel);
                e.setCancelMessage(msgSb.toString());
                return;
            }
        }
        ds = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"ent_instock", (String)"id,entryentity.goods.number", (QFilter[])filters, (String)"entryentity.goods.number");
        var8_9 = null;
        try {
            goodNumberSet = new HashSet();
            ds.forEach(row -> goodNumberSet.add(row.getString("entryentity.goods.number")));
            if (goodNumberSet.size() > 0) {
                isCancel = true;
                StringBuilder msgSb = new StringBuilder();
                msgSb.append(ResManager.loadKDString((String)"\u5546\u54c1", (String)"PmmGoodsDeleteOp_0", (String)"scm-pmm-opplugin", (Object[])new Object[0]));
                for (String goodNumer : goodNumberSet) {
                    msgSb.append(goodNumer).append('\n');
                }
                msgSb.append(ResManager.loadKDString((String)"\u6709\u5173\u8054\u5e93\u5b58\u8c03\u6574\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"PmmGoodsDeleteOp_2", (String)"scm-pmm-opplugin", (Object[])new Object[0]));
                e.setCancel(isCancel);
                e.setCancelMessage(msgSb.toString());
                return;
            }
        }
        catch (Throwable goodNumberSet2) {
            var8_9 = goodNumberSet2;
            throw goodNumberSet2;
        }
        finally {
            if (ds != null) {
                if (var8_9 != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        var8_9.addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        entrygoodsIdFilter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getVal());
        ds = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"ent_prodrequest", (String)"id,entryentity.goods.id", (QFilter[])entrygoodsIdFilter.toArray(), (String)"entryentity.goods.id");
        var8_9 = null;
        try {
            goodNumberSet = new HashSet();
            ds.forEach(row -> goodNumberSet.add(row.getString("entryentity.goods.id")));
            if (goodNumberSet.size() > 0) {
                isCancel = true;
                StringBuilder msgSb = new StringBuilder();
                msgSb.append(ResManager.loadKDString((String)"\u5546\u54c1", (String)"PmmGoodsDeleteOp_0", (String)"scm-pmm-opplugin", (Object[])new Object[0]));
                for (String goodNumer : goodNumberSet) {
                    msgSb.append(goodNumer).append('\n');
                }
                msgSb.append(ResManager.loadKDString((String)"\u5df2\u5173\u8054\u4e0a\u67b6\u7533\u8bf7\u5355\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"PmmGoodsDeleteOp_3", (String)"scm-pmm-opplugin", (Object[])new Object[0]));
                e.setCancel(isCancel);
                e.setCancelMessage(msgSb.toString());
                return;
            }
        }
        catch (Throwable throwable) {
            var8_9 = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (var8_9 != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        var8_9.addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        ArrayList<Long> prodPoolIdList = new ArrayList<Long>();
        for (DynamicObject dynamicObject : dataEntities) {
            DynamicObjectCollection protocolEntry = dynamicObject.getDynamicObjectCollection("protocolentry");
            for (DynamicObject entry : protocolEntry) {
                prodPoolIdList.add(entry.getDynamicObject("prodpool").getLong("id"));
            }
        }
        DeleteServiceHelper.delete((String)"pmm_prodpool", (QFilter[])new QFilter[]{new QFilter("id", "in", prodPoolIdList)});
        this.clearSpuEntryGoods(e);
        this.deleteMalBrowsingHistory(e);
    }

    private void deleteMalBrowsingHistory(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        HashSet<Long> goodsIds = new HashSet<Long>(16);
        for (DynamicObject info : dataEntities) {
            goodsIds.add(info.getLong("id"));
        }
        if (goodsIds.size() > 0) {
            QFilter qFilter = new QFilter("goods.id", "in", goodsIds);
            DeleteServiceHelper.delete((String)"mal_browsinghistory", (QFilter[])qFilter.toArray());
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
    }

    private void clearSpuEntryGoods(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        HashMap spuMap = new HashMap(16);
        for (DynamicObject info : dataEntities) {
            String spuNumber = info.getString("spunumber");
            if (StringUtils.isEmpty((CharSequence)spuNumber)) continue;
            List<Long> goodsIds = new ArrayList<Long>(16);
            if (null != spuMap.get(spuNumber)) {
                goodsIds = (List)spuMap.get(spuNumber);
            }
            goodsIds.add(info.getLong("id"));
            spuMap.put(spuNumber, goodsIds);
        }
        if (spuMap.size() > 0) {
            DynamicObject[] pmm_spus;
            QFilter qFilter = new QFilter("number", "in", spuMap.keySet());
            qFilter.and(new QFilter("origin", "=", (Object)"2"));
            String selectors = "spuskumapentry.goods,spuskumapentry.goods.id,number,spuskumapentry.skuname,spuskumapentry.taxprice,spuskumapentry.taxrateid,spuskumapentry.price,spuskumapentry.thumbnail,spuskumapentry.picture1,spuskumapentry.picture2,spuskumapentry.picture3,spuskumapentry.picture4,spuskumapentry.curr,spuskumapentry.taxtype,spuskumapentry.confirmstatus,spuskumapentry.entryresult,spuskumapentry.note,,spuskumapentry.content,spuskumapentry.specification,spuskumapentry.packinglist,spuskumapentry.guarantee,,spuskumapentry.content_tag,spuskumapentry.specification_tag,spuskumapentry.skunumber";
            for (DynamicObject spu : pmm_spus = BusinessDataServiceHelper.load((String)"pmm_spu", (String)selectors, (QFilter[])qFilter.toArray())) {
                DynamicObjectCollection entryCols = spu.getDynamicObjectCollection("spuskumapentry");
                String number = spu.getString("number");
                if (null == spuMap.get(number)) continue;
                List goodsIds = (List)spuMap.get(number);
                for (DynamicObject row : entryCols) {
                    if (null == row.get("goods") || !goodsIds.contains(row.getLong("goods.id"))) continue;
                    row.set("goods", null);
                    row.set("skuname", null);
                    row.set("taxprice", null);
                    row.set("taxrateid", null);
                    row.set("price", null);
                    row.set("thumbnail", null);
                    row.set("picture1", null);
                    row.set("picture2", null);
                    row.set("picture3", null);
                    row.set("picture4", null);
                    row.set("curr", null);
                    row.set("taxtype", null);
                    row.set("confirmstatus", (Object)"C");
                    row.set("entryresult", null);
                    row.set("note", null);
                    row.set("content", null);
                    row.set("specification", null);
                    row.set("packinglist", null);
                    row.set("guarantee", null);
                    row.set("content_tag", null);
                    row.set("specification_tag", null);
                    row.set("skunumber", null);
                }
            }
            if (pmm_spus.length > 0) {
                SaveServiceHelper.save((DynamicObject[])pmm_spus);
            }
        }
    }
}

