/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.opplugin;

import java.util.ArrayList;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.ecapi.enums.EcPlatformEnum;

public final class PmmGoodsRuleLogSaveOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("goodsid");
        e.getFieldKeys().add("goodsnum");
        e.getFieldKeys().add("goodspool");
        e.getFieldKeys().add("id");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        this.cancaleLogInfo(dataEntities);
    }

    private void cancaleLogInfo(DynamicObject[] dataEntities) {
        HashSet<Long> goodsIds = new HashSet<Long>(16);
        HashSet<Long> logRuleInfoIds = new HashSet<Long>(16);
        HashSet<Long> goodsPoolId = new HashSet<Long>(16);
        for (DynamicObject info : dataEntities) {
            logRuleInfoIds.add(info.getLong("id"));
            goodsIds.add(info.getLong("goodsid"));
            if (null != info.get("goodspool")) {
                goodsPoolId.add(info.getLong("goodspool.id"));
                continue;
            }
            if (null == info.get("goodspool_id")) continue;
            goodsPoolId.add(info.getLong("goodspool_id"));
        }
        QFilter qFilter = new QFilter("dealstatus", "=", (Object)"A");
        qFilter.and(new QFilter("goodsid", "in", goodsIds));
        DynamicObject[] goodsRulelogs = BusinessDataServiceHelper.load((String)"pmm_goodsrulelog", (String)"remark,id,goodspool,dealstatus,platform", (QFilter[])qFilter.toArray());
        ArrayList<DynamicObject> needUpdateDyn = new ArrayList<DynamicObject>(16);
        String msg = ResManager.loadKDString((String)"\u56e0\u5546\u54c1\u76f8\u5173\u4fe1\u606f\u8c03\u6574\uff0c\u672a\u8fbe\u5230\u9608\u503c/\u751f\u6210\u65b0\u7684\u76d1\u63a7\u65e5\u5fd7\uff0c\u4f5c\u5e9f\u76d1\u63a7\u65e5\u5fd7", (String)"PmmGoodsRuleLogSaveOp_0", (String)"scm-pmm-opplugin", (Object[])new Object[0]);
        for (DynamicObject row : goodsRulelogs) {
            if (logRuleInfoIds.contains(row.getLong("id"))) continue;
            String platform = row.getString("platform");
            if (EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(platform)) {
                if (null == row.get("goodspool") || !goodsPoolId.contains(row.getLong("goodspool.id"))) continue;
                row.set("dealstatus", (Object)"C");
                row.set("remark", (Object)msg);
                needUpdateDyn.add(row);
                continue;
            }
            row.set("dealstatus", (Object)"C");
            row.set("remark", (Object)msg);
            needUpdateDyn.add(row);
        }
        if (needUpdateDyn.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])needUpdateDyn.toArray(new DynamicObject[0]));
        }
    }
}

