/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.opplugin;

import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scm.common.util.ExceptionUtil;

public class PmmGoodsUnSubmitOp
extends AbstractOperationServicePlugIn {
    private static Log log = LogFactory.getLog(PmmGoodsUnSubmitOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("spunumber");
        e.getFieldKeys().add("mulmodel");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        String source;
        super.endOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        OperateOption option = this.getOption();
        if (option.containsVariable("batchspulinkgoods") && Boolean.parseBoolean(source = option.getVariableValue("batchspulinkgoods"))) {
            this.batchSubmitSkuBySpuNumber(dataEntities);
        }
    }

    private void batchSubmitSkuBySpuNumber(DynamicObject[] dataEntities) {
        HashSet<String> spuNos = new HashSet<String>(16);
        HashSet<Long> removeIds = new HashSet<Long>(16);
        for (DynamicObject dyn : dataEntities) {
            if (!StringUtils.isEmpty((CharSequence)dyn.getString("spunumber")) && dyn.getBoolean("mulmodel")) {
                spuNos.add(dyn.getString("spunumber"));
            }
            removeIds.add(dyn.getLong("id"));
        }
        if (spuNos.size() > 0) {
            QFilter qFilter = new QFilter("number", "in", spuNos);
            String selectors = "spuskumapentry.goods.status,spuskumapentry.goods.id";
            DynamicObjectCollection spus = QueryServiceHelper.query((String)"pmm_spu", (String)selectors, (QFilter[])qFilter.toArray());
            HashSet<Long> goodsIds = new HashSet<Long>(16);
            for (DynamicObject row : spus) {
                String status = row.getString("spuskumapentry.goods.status");
                long goodIds = row.getLong("spuskumapentry.goods.id");
                if (!"B".equals(status) || removeIds.contains(goodIds)) continue;
                goodsIds.add(goodIds);
            }
            if (goodsIds.size() > 0) {
                OperateOption option = OperateOption.create();
                option.setVariableValue("ishasright", String.valueOf(true));
                option.setVariableValue("isStrict", String.valueOf(false));
                option.setVariableValue("mulmodel", String.valueOf(false));
                OperationResult submitResult = OperationServiceHelper.executeOperate((String)"unsubmit", (String)"pmm_prodmanage", (Object[])goodsIds.toArray(), (OperateOption)option);
                if (!submitResult.isSuccess()) {
                    log.info(ExceptionUtil.getErrorInfoDetails((List)submitResult.getAllErrorOrValidateInfo()));
                }
            }
        }
    }
}

