/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.opplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.CommonUtil;

public class PmmInventoryAddInventoryOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("goods");
        fieldKeys.add("lockedqty");
        fieldKeys.add("availableqty");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dynamicObjects = e.getDataEntities();
        HashMap<Long, DynamicObject> goodsIdAndDynMap = new HashMap<Long, DynamicObject>(dynamicObjects.length);
        for (DynamicObject dynamicObject : dynamicObjects) {
            goodsIdAndDynMap.put(dynamicObject.getLong("goods_id"), dynamicObject);
        }
        QFilter qFilter = new QFilter("entryentity.goods", "in", goodsIdAndDynMap.keySet());
        qFilter.and("billstatus", "=", (Object)BillStatusEnum.SUBMIT.getVal());
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"mal_order", (String)"entryentity.goods goods,entryentity.qty qty", (QFilter[])qFilter.toArray(), null);){
            dataSet.forEach(row -> {
                DynamicObject dynamicObject = (DynamicObject)goodsIdAndDynMap.get(row.getLong("goods"));
                dynamicObject.set("lockedqty", (Object)dynamicObject.getBigDecimal("lockedqty").add(row.getBigDecimal("qty")));
                dynamicObject.set("availableqty", (Object)dynamicObject.getBigDecimal("qty").subtract(dynamicObject.getBigDecimal("lockedqty")));
            });
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        List goodsIds = Arrays.stream(e.getDataEntities()).map(dyn -> dyn.getLong("goods_id")).collect(Collectors.toList());
        QFilter qFilter = new QFilter("goods", "in", goodsIds);
        ArrayList prodPoolIds = new ArrayList(goodsIds.size() * 2);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"pmm_prodpool", (String)"id", (QFilter[])qFilter.toArray(), null);){
            dataSet.forEach(row -> prodPoolIds.add(row.getLong("id")));
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", String.valueOf(true));
        option.setVariableValue("isStrict", String.valueOf(false));
        CommonUtil.check((OperationResult)OperationServiceHelper.executeOperate((String)"soldpublish", (String)"pmm_prodpool", (Object[])prodPoolIds.toArray(), (OperateOption)option));
    }
}

