/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.MalOrderUtil;
import kd.scm.malcore.domain.GoodsPriceHistoryRecord;
import kd.scm.pmm.business.model.prodpool.LadderPrice;
import kd.scm.pmm.business.service.impl.PmmAuditCfmValidatorServiceImpl;
import kd.scm.pmm.business.service.impl.PmmGoodsPriceServiceImpl;

public class PmmPriceAuditAcceptOp
extends AbstractOperationServicePlugIn {
    private static final String ENTRYENTITY = "entryentity";

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        Date currDate = TimeServiceHelper.now();
        String confirm = "agree";
        ArrayList<Long> allBillid = new ArrayList<Long>(16);
        for (DynamicObject item : e.getDataEntities()) {
            allBillid.add(item.getLong("id"));
        }
        this.updatePrice(confirm, allBillid, currDate);
    }

    private void updatePrice(String confirm, List<Long> allBillid, Date currDate) {
        String prodPoolId;
        HashMap<String, DynamicObject> prodAuditMap = new HashMap<String, DynamicObject>();
        HashMap<Long, DynamicObject> prodIdAndEntryMap = new HashMap<Long, DynamicObject>(16);
        ArrayList<Long> prodPoolList = new ArrayList<Long>();
        PmmAuditCfmValidatorServiceImpl pmmAuditCfmValidatorService = new PmmAuditCfmValidatorServiceImpl();
        QFilter billidFilter = new QFilter("id", "in", allBillid);
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)"pmm_priceaudit", (String)"creator,createtime,origin,id,billno,org,cfmdate,billstatus,suggestion,cfmstatus,cfmdate,cfm,entryentity.goods,entryentity.note,entryentity.class,entryentity.shopprice,entryentity.taxprice,entryentity.price,entryentity.taxrate,entryentity.taxrateid,entryentity.prodpool,entryentity.prodpool.protocol,entryentity.prodpool.protocolentry,entryentity.unit,entryentity.taxprice_old", (QFilter[])new QFilter[]{billidFilter});
        StringBuilder msg = pmmAuditCfmValidatorService.checkGoodsProtocol(bills);
        if (msg.length() > 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u90e8\u5206\u5546\u54c1\u5df2\u5173\u8054\u534f\u8bae\uff0c\u6570\u636e\u5df2\u6539\u53d8\uff0c\u8bf7\u91cd\u65b0\u53d1\u8d77\u8c03\u4ef7\u7533\u8bf7\u3002", (String)"PmmPriceAuditAcceptOp_0", (String)"scm-pmm-opplugin", (Object[])new Object[0]));
        }
        HashSet<String> prodNumbers = new HashSet<String>(bills.length);
        HashSet<Long> successIds = new HashSet<Long>(16);
        ArrayList<GoodsPriceHistoryRecord> goodsPriceHistoryRecords = new ArrayList<GoodsPriceHistoryRecord>(16);
        for (DynamicObject bill : bills) {
            DynamicObjectCollection entries = bill.getDynamicObjectCollection(ENTRYENTITY);
            bill.set("cfm", (Object)RequestContext.get().getUserId());
            bill.set("cfmdate", (Object)currDate);
            bill.set("cfmstatus", (Object)"B");
            if (confirm.equals("agree")) {
                bill.set("cfmstatus", (Object)"B");
            } else if (confirm.equals("back")) {
                bill.set("cfmstatus", (Object)"D");
                bill.set("billstatus", (Object)"A");
            } else if (confirm.equals("disagree")) {
                bill.set("cfmstatus", (Object)"D");
            }
            for (DynamicObject entry : entries) {
                DynamicObject goods = entry.getDynamicObject("goods");
                DynamicObject prodpool = entry.getDynamicObject("prodpool");
                prodPoolList.add(entry.getDynamicObject("prodpool").getLong("id"));
                prodIdAndEntryMap.put(entry.getDynamicObject("goods").getLong("id"), entry);
                prodAuditMap.put(entry.getDynamicObject("prodpool").getString("id"), entry);
                prodNumbers.add(entry.getDynamicObject("goods").getString("number"));
                GoodsPriceHistoryRecord goodsPriceHistoryRecord = new GoodsPriceHistoryRecord();
                goodsPriceHistoryRecord.setLastPrice(entry.getBigDecimal("taxprice_old"));
                goodsPriceHistoryRecord.setGoodsId(goods.getLong("id"));
                goodsPriceHistoryRecord.setGoodsPoolId(prodpool.getLong("id"));
                goodsPriceHistoryRecord.setProtocolId(prodpool.getLong("protocol.id"));
                goodsPriceHistoryRecord.setProtocolEntryId(prodpool.getLong("protocolentry.id"));
                goodsPriceHistoryRecord.setAuditorg(bill.getLong("org.id"));
                goodsPriceHistoryRecord.setAdjustdate(bill.getDate("cfmdate"));
                goodsPriceHistoryRecord.setNote(entry.getString("note"));
                goodsPriceHistoryRecord.setSrcBillType("pmm_priceaudit");
                goodsPriceHistoryRecord.setSrcBillNo(bill.getString("billno"));
                goodsPriceHistoryRecord.setSrcBillId(bill.getString("id"));
                goodsPriceHistoryRecord.setOrigin(bill.getString("origin"));
                goodsPriceHistoryRecord.setCreateDate(bill.getDate("createtime"));
                goodsPriceHistoryRecord.setCreatorId(bill.getLong("creator.id"));
                goodsPriceHistoryRecord.setAuditDate(bill.getDate("cfmdate"));
                goodsPriceHistoryRecord.setAuditorId(bill.getLong("cfm"));
                goodsPriceHistoryRecords.add(goodsPriceHistoryRecord);
            }
            if (!"B".equals(bill.getString("cfmstatus"))) continue;
            successIds.add(bill.getLong("id"));
        }
        if (this.checkHasSameNumber(prodNumbers)) {
            return;
        }
        HashMap pool_pricesMap = new HashMap(1024);
        if (successIds.size() > 0) {
            QFilter qFilter = new QFilter("id", "in", successIds);
            DynamicObjectCollection pricerequests = QueryServiceHelper.query((String)"ent_pricerequest", (String)"entryentity.prodpool,entryentity.subentryentity.qtyfrom qtyfrom,entryentity.subentryentity.qtyto qtyto,entryentity.subentryentity.ladprice ladprice", (QFilter[])qFilter.toArray());
            for (DynamicObject row : pricerequests) {
                Long id = row.getLong("entryentity.prodpool");
                List<LadderPrice> price = new ArrayList(1024);
                if (null != pool_pricesMap.get(id)) {
                    price = (List)pool_pricesMap.get(id);
                }
                LadderPrice ladderPrice = new LadderPrice();
                DynamicObject[] qtyfrom = row.getBigDecimal("qtyfrom");
                BigDecimal qtyto = row.getBigDecimal("qtyto");
                if (null != qtyfrom && qtyfrom.compareTo(BigDecimal.ZERO) <= 0 && null != qtyto && qtyto.compareTo(BigDecimal.ZERO) <= 0) continue;
                ladderPrice.setLadprice(row.getBigDecimal("ladprice"));
                ladderPrice.setQtyfrom(row.getBigDecimal("qtyfrom"));
                ladderPrice.setQtyto(row.getBigDecimal("qtyto"));
                price.add(ladderPrice);
                pool_pricesMap.put(id, price);
            }
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("isStrict", String.valueOf(false));
        option.setVariableValue("ishasright", String.valueOf(true));
        String selectFields = "pricetype,id,taxprice,taxrateid,taxrate,price,unit,salestatus,isgoodvisible,entryentity.orgname,mallstatus,protocol,priceentry.qtyfrom,priceentry.qtyto,priceentry.ladprice";
        QFilter fileter = new QFilter("id", "in", prodPoolList);
        QFilter[] filters = new QFilter[]{fileter};
        DynamicObject[] prodPoolDynArray = BusinessDataServiceHelper.load((String)"pmm_prodpool", (String)selectFields, (QFilter[])filters);
        String prodSelectFields = DynamicObjectUtil.getSelectfields((String)"pmm_prodmanage", (boolean)false);
        DynamicObject[] prodDynArray = BusinessDataServiceHelper.load((String)"pmm_prodmanage", (String)prodSelectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", prodIdAndEntryMap.keySet())});
        if (prodPoolDynArray.length < 1) {
            return;
        }
        for (DynamicObject prodPool : prodPoolDynArray) {
            prodPoolId = prodPool.getString("id");
            prodPool.set("taxprice", ((DynamicObject)prodAuditMap.get(prodPoolId)).get("taxprice"));
            prodPool.set("price", ((DynamicObject)prodAuditMap.get(prodPoolId)).get("price"));
            prodPool.set("taxrate", ((DynamicObject)prodAuditMap.get(prodPoolId)).get("taxrate"));
            prodPool.set("taxrateid", ((DynamicObject)prodAuditMap.get(prodPoolId)).get("taxrateid"));
            prodPool.set("unit", ((DynamicObject)prodAuditMap.get(prodPoolId)).get("unit"));
            DynamicObjectCollection priceentry = prodPool.getDynamicObjectCollection("priceentry");
            priceentry.clear();
            if (null != pool_pricesMap.get(Long.parseLong(prodPoolId))) {
                List ladderPrices = (List)pool_pricesMap.get(Long.parseLong(prodPoolId));
                if (ladderPrices.size() > 1) {
                    ladderPrices = ladderPrices.stream().sorted(Comparator.comparing(LadderPrice::getQtyfrom)).collect(Collectors.toList());
                    for (LadderPrice price : ladderPrices) {
                        DynamicObject priceEntry = priceentry.addNew();
                        priceEntry.set("qtyfrom", (Object)price.getQtyfrom());
                        priceEntry.set("qtyto", (Object)price.getQtyto());
                        priceEntry.set("ladprice", (Object)price.getLadprice());
                    }
                    prodPool.set("pricetype", (Object)"B");
                    continue;
                }
                prodPool.set("priceentry", (Object)priceentry);
                prodPool.set("pricetype", (Object)"A");
                continue;
            }
            prodPool.set("priceentry", (Object)priceentry);
            prodPool.set("pricetype", (Object)"A");
        }
        for (DynamicObject prodPool : prodPoolDynArray) {
            prodPoolId = prodPool.getString("id");
            prodPool.set("taxprice", ((DynamicObject)prodAuditMap.get(prodPoolId)).get("taxprice"));
            prodPool.set("price", ((DynamicObject)prodAuditMap.get(prodPoolId)).get("price"));
            prodPool.set("taxrate", ((DynamicObject)prodAuditMap.get(prodPoolId)).get("taxrate"));
            prodPool.set("taxrateid", ((DynamicObject)prodAuditMap.get(prodPoolId)).get("taxrateid"));
            prodPool.set("unit", ((DynamicObject)prodAuditMap.get(prodPoolId)).get("unit"));
        }
        for (DynamicObject prod : prodDynArray) {
            prod.set("adjustdate", (Object)currDate);
            DynamicObject entry = (DynamicObject)prodIdAndEntryMap.get(prod.getLong("id"));
            if (entry.getDynamicObject("prodpool").getDynamicObject("protocol") != null) continue;
            prod.set("taxprice", entry.get("taxprice"));
            prod.set("shopprice", entry.get("taxprice"));
            prod.set("price", entry.get("price"));
            prod.set("taxrate", entry.get("taxrate"));
            prod.set("taxrateid", entry.get("taxrateid"));
            prod.set("unit", entry.get("unit"));
        }
        CommonUtil.check((OperationResult)OperationServiceHelper.executeOperate((String)"save", (String)"pmm_prodmanage", (DynamicObject[])prodDynArray, (OperateOption)option));
        CommonUtil.check((OperationResult)OperationServiceHelper.executeOperate((String)"soldpublish", (String)"pmm_prodpool", (DynamicObject[])prodPoolDynArray, (OperateOption)option));
        CommonUtil.check((OperationResult)SaveServiceHelper.saveOperate((String)"save", (String)"pmm_priceaudit", (DynamicObject[])bills, (OperateOption)OperateOption.create()));
        PmmGoodsPriceServiceImpl pmmGoodsPriceService = new PmmGoodsPriceServiceImpl();
        pmmGoodsPriceService.addGoodsPriceHistoryRecords(goodsPriceHistoryRecords);
    }

    private boolean checkHasSameNumber(Set<String> numbers) {
        QFilter qFilter = new QFilter("number", "in", numbers);
        DynamicObjectCollection prods = QueryServiceHelper.query((String)"pmm_prodmanage", (String)"id,number", (QFilter[])qFilter.toArray());
        HashSet<String> numberAccount = new HashSet<String>(prods.size());
        StringBuilder sb = new StringBuilder();
        for (DynamicObject prod : prods) {
            if (numberAccount.contains(prod.getString("number"))) {
                String message = ResManager.loadKDString((String)"\u5546\u54c1\u7f16\u7801\u201c%s\u201d\u5728\u5546\u54c1\u7ba1\u7406\u5b58\u5728\u91cd\u590d\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"PmmPriceAuditAcceptOp_1", (String)"scm-pmm-opplugin", (Object[])new Object[0]);
                if (MalOrderUtil.getDefaultMalVersion()) {
                    message = ResManager.loadKDString((String)"\u5546\u54c1\u7f16\u7801\u201c%s\u201d\u5728\u81ea\u5efa\u5546\u54c1\u6c60\u5b58\u5728\u91cd\u590d\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"PmmPriceAuditAcceptOp_2", (String)"scm-pmm-opplugin", (Object[])new Object[0]);
                }
                sb.append(String.format(message, prod.getString("number")));
                continue;
            }
            numberAccount.add(prod.getString("number"));
        }
        if (sb.length() > 0) {
            throw new KDBizException(sb.toString());
        }
        return false;
    }
}

