/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.opplugin;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scm.common.util.ExceptionUtil;

public class PmmProdAuditDeleteOp
extends AbstractOperationServicePlugIn {
    private static Log log = LogFactory.getLog(PmmProdAuditDeleteOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("entryentity.goods");
        e.getFieldKeys().add("entryentity.goods.status");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        ArrayList<Long> goodIds = new ArrayList<Long>(1024);
        for (DynamicObject info : dataEntities) {
            DynamicObjectCollection entryCol = info.getDynamicObjectCollection("entryentity");
            for (DynamicObject row : entryCol) {
                DynamicObject good = row.getDynamicObject("goods");
                if (null == good || !"A".equals(good.getString("status"))) continue;
                goodIds.add(good.getLong("id"));
            }
        }
        if (goodIds.size() > 0) {
            this.deleteSaveGoods(goodIds);
        }
    }

    private void deleteSaveGoods(List<Long> goodIds) {
        if (goodIds.size() > 0) {
            OperateOption saveOption = OperateOption.create();
            saveOption.setVariableValue("isStrict", "false");
            saveOption.setVariableValue("ishasright", "true");
            OperationResult deleteResullt = OperationServiceHelper.executeOperate((String)"delete", (String)"pmm_prodmanage", (Object[])goodIds.toArray(), (OperateOption)saveOption);
            if (!deleteResullt.isSuccess()) {
                log.error(ExceptionUtil.getErrorInfoDetails((List)deleteResullt.getAllErrorOrValidateInfo()));
            }
        }
    }
}

