/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.opplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.constant.BillAssistConstant;

public class PmmProdMatMappingImportOp
extends BatchImportPlugin {
    private static final String SPLIT = "_";

    protected boolean isForceBatch() {
        return true;
    }

    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        Map option = this.ctx.getOption();
        Object importtype = option.get("importtype");
        super.beforeSave(billdatas, logger);
        HashMap<String, List<ImportBillData>> goodsNumber2BillDataMap = new HashMap<String, List<ImportBillData>>(billdatas.size());
        HashMap<String, List<ImportBillData>> ecGoodsNumber2BillDataMap = new HashMap<String, List<ImportBillData>>(billdatas.size());
        HashMap<String, List<ImportBillData>> categoryNumber2BillDataListMap = new HashMap<String, List<ImportBillData>>(billdatas.size());
        HashMap<String, List<ImportBillData>> purchaseTypeNumbers = new HashMap<String, List<ImportBillData>>(billdatas.size());
        HashMap<String, Long> materialNumber2GroupMap = new HashMap<String, Long>(billdatas.size());
        Iterator<ImportBillData> iterator = billdatas.iterator();
        while (iterator.hasNext()) {
            List importBillData;
            ImportBillData billdata = iterator.next();
            Map goods = (Map)billdata.getData().get((Object)"goods");
            Map ecGoods = (Map)billdata.getData().get((Object)"ecgoods");
            Map category = (Map)billdata.getData().get((Object)"category");
            Map purchasetype = (Map)billdata.getData().get((Object)"purchasetype");
            Map material = (Map)billdata.getData().get((Object)"material");
            String platform = (String)billdata.getData().get((Object)"platform");
            if (StringUtils.isBlank((CharSequence)platform)) {
                platform = "1";
            }
            if ((goods != null || ecGoods != null) && category != null || (goods != null || ecGoods != null) && purchasetype != null || category != null && purchasetype != null) {
                String msg = ResManager.loadKDString((String)"\u5f15\u5165\u5931\u8d25\uff1a\u53ea\u80fd\u586b\u5199\u201c\u5546\u54c1\u201d\uff0c\u201c\u5546\u54c1\u5206\u7c7b\u201d\uff0c\u201c\u91c7\u8d2d\u7c7b\u578b\u201d\u4e2d\u7684\u4e00\u4e2a\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u3002", (String)"PmmProdMatMappingImportOp_0", (String)"scm-pmm-opplugin", (Object[])new Object[0]);
                logger.log(Integer.valueOf(billdata.getStartIndex()), msg).fail();
                iterator.remove();
                continue;
            }
            if (goods != null) {
                importBillData = goodsNumber2BillDataMap.computeIfAbsent(goods.get("number") + SPLIT + platform, k -> new ArrayList());
                importBillData.add(billdata);
            }
            if (ecGoods != null) {
                importBillData = ecGoodsNumber2BillDataMap.computeIfAbsent(ecGoods.get("number") + SPLIT + platform, k -> new ArrayList());
                importBillData.add(billdata);
            }
            if (category != null) {
                importBillData = categoryNumber2BillDataListMap.computeIfAbsent(category.get("number") + SPLIT + platform, k -> new ArrayList());
                importBillData.add(billdata);
            }
            if (purchasetype != null) {
                importBillData = purchaseTypeNumbers.computeIfAbsent(purchasetype.get("number") + SPLIT + platform, k -> new ArrayList());
                importBillData.add(billdata);
            }
            if (material == null) continue;
            materialNumber2GroupMap.put((String)material.get("number"), null);
        }
        this.removeRepetitionData(billdatas, goodsNumber2BillDataMap, logger, ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u5546\u54c1.\u5546\u54c1\u7f16\u7801\u201c%s\u201d\u5b58\u5728\u591a\u6761\u6570\u636e\u91cd\u590d\u5173\u8054\uff0c\u8bf7\u8c03\u6574\u4e00\u4e2a\u5546\u54c1\u53ea\u80fd\u5173\u8054\u4e00\u4e2a\u7269\u6599\u3002", (String)"PmmProdMatMappingImportOp_1", (String)"scm-pmm-opplugin", (Object[])new Object[0]));
        this.removeRepetitionData(billdatas, ecGoodsNumber2BillDataMap, logger, ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u5546\u54c1.\u5546\u54c1\u7f16\u7801\u201c%s\u201d\u5b58\u5728\u591a\u6761\u6570\u636e\u91cd\u590d\u5173\u8054\uff0c\u8bf7\u8c03\u6574\u4e00\u4e2a\u5546\u54c1\u53ea\u80fd\u5173\u8054\u4e00\u4e2a\u7269\u6599\u3002", (String)"PmmProdMatMappingImportOp_1", (String)"scm-pmm-opplugin", (Object[])new Object[0]));
        this.removeRepetitionData(billdatas, categoryNumber2BillDataListMap, logger, ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u5546\u54c1\u5206\u7c7b.\u5206\u7c7b\u7f16\u7801\u201c%s\u201d\u5b58\u5728\u591a\u6761\u6570\u636e\u91cd\u590d\u5173\u8054\uff0c\u8bf7\u8c03\u6574\u4e00\u4e2a\u5546\u54c1\u5206\u7c7b\u53ea\u80fd\u5173\u8054\u4e00\u4e2a\u7269\u6599\u3002", (String)"PmmProdMatMappingImportOp_2", (String)"scm-pmm-opplugin", (Object[])new Object[0]));
        this.removeRepetitionData(billdatas, purchaseTypeNumbers, logger, ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u91c7\u8d2d\u7c7b\u578b\u201c%s\u201d\u5b58\u5728\u591a\u6761\u6570\u636e\u91cd\u590d\u5173\u8054\uff0c\u8bf7\u8c03\u6574\u4e00\u4e2a\u91c7\u8d2d\u7c7b\u578b\u53ea\u80fd\u5173\u8054\u4e00\u4e2a\u7269\u6599\u3002", (String)"PmmProdMatMappingImportOp_3", (String)"scm-pmm-opplugin", (Object[])new Object[0]));
        if ("new".equals(importtype)) {
            this.removeHasMappingData(billdatas, goodsNumber2BillDataMap, logger, "goods.number", ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u5546\u54c1.\u5546\u54c1\u7f16\u7801\u201c%s\u201d\u5df2\u5b58\u5728\u5bf9\u5e94\u8868\u3002", (String)"PmmProdMatMappingImportOp_4", (String)"scm-pmm-opplugin", (Object[])new Object[0]));
            this.removeHasMappingData(billdatas, ecGoodsNumber2BillDataMap, logger, "ecgoods.number", ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u5546\u54c1.\u5546\u54c1\u7f16\u7801\u201c%s\u201d\u5df2\u5b58\u5728\u5bf9\u5e94\u8868\u3002", (String)"PmmProdMatMappingImportOp_4", (String)"scm-pmm-opplugin", (Object[])new Object[0]));
            this.removeHasMappingData(billdatas, categoryNumber2BillDataListMap, logger, "category.number", ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u5546\u54c1\u5206\u7c7b.\u5206\u7c7b\u7f16\u7801\u201c%s\u201d\u5df2\u5b58\u5728\u5bf9\u5e94\u8868\u3002", (String)"PmmProdMatMappingImportOp_5", (String)"scm-pmm-opplugin", (Object[])new Object[0]));
            this.removeHasMappingData(billdatas, purchaseTypeNumbers, logger, "purchasetype.number", ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u91c7\u8d2d\u7c7b\u578b.\u7f16\u7801\u201c%s\u201d\u5df2\u5b58\u5728\u5bf9\u5e94\u8868\u3002", (String)"PmmProdMatMappingImportOp_6", (String)"scm-pmm-opplugin", (Object[])new Object[0]));
        }
        this.translateCategoryMappingByGoodsMapping(goodsNumber2BillDataMap, categoryNumber2BillDataListMap);
        this.translateCategoryMappingByEcGoodsMapping(ecGoodsNumber2BillDataMap, categoryNumber2BillDataListMap);
        this.checkCategoryMappingValid(categoryNumber2BillDataListMap, materialNumber2GroupMap, billdatas, logger);
    }

    private void translateCategoryMappingByEcGoodsMapping(Map<String, List<ImportBillData>> ecGoodsNumber2BillDataMap, Map<String, List<ImportBillData>> categoryNumber2BillDataListMap) {
        if (ecGoodsNumber2BillDataMap.isEmpty()) {
            return;
        }
        QFilter qFilter = new QFilter("number", "in", ecGoodsNumber2BillDataMap.keySet());
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"pbd_mallgoods", (String)"number,group.number categoryNumber", (QFilter[])qFilter.toArray(), null);){
            dataSet.forEach(row -> {
                List importBillData = categoryNumber2BillDataListMap.computeIfAbsent(row.getString("categoryNumber"), k -> new ArrayList());
                importBillData.addAll((Collection)ecGoodsNumber2BillDataMap.get(row.getString("number")));
            });
        }
    }

    private void removeRepetitionData(List<ImportBillData> billdatas, Map<String, List<ImportBillData>> numbersMap, ImportLogger logger, String errorMeg) {
        Iterator<Map.Entry<String, List<ImportBillData>>> iterator = numbersMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, List<ImportBillData>> entry = iterator.next();
            List<ImportBillData> importBillDataList = entry.getValue();
            if (importBillDataList.size() <= 1) continue;
            for (ImportBillData importBillData : importBillDataList) {
                billdatas.remove(importBillData);
                logger.log(Integer.valueOf(importBillData.getStartIndex()), String.format(errorMeg, entry.getKey())).fail();
            }
            iterator.remove();
        }
    }

    private void removeHasMappingData(List<ImportBillData> billdatas, Map<String, List<ImportBillData>> numbersMap, ImportLogger logger, String property, String errorMeg) {
        HashSet<String> propertyValueSet = new HashSet<String>(numbersMap.size());
        for (String key : numbersMap.keySet()) {
            propertyValueSet.add(key.split(SPLIT)[0]);
        }
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"pmm_prodmatmapping", (String)("platform," + property + " number"), (QFilter[])new QFilter[]{new QFilter(property, "in", propertyValueSet)}, null);){
            dataSet.forEach(row -> {
                List importBillDataList = (List)numbersMap.remove(row.getString("number") + SPLIT + row.getString("platform"));
                if (importBillDataList != null) {
                    for (ImportBillData importBillData : importBillDataList) {
                        billdatas.remove(importBillData);
                        logger.log(Integer.valueOf(importBillData.getStartIndex()), String.format(errorMeg, row.getString("number"))).fail();
                    }
                }
            });
        }
    }

    private void translateCategoryMappingByGoodsMapping(Map<String, List<ImportBillData>> goodsNumber2BillDataMap, Map<String, List<ImportBillData>> categoryNumber2BillDataListMap) {
        if (goodsNumber2BillDataMap.isEmpty()) {
            return;
        }
        QFilter qFilter = new QFilter("number", "in", goodsNumber2BillDataMap.keySet());
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"pmm_prodmanage", (String)"number,category.number categoryNumber", (QFilter[])qFilter.toArray(), null);){
            dataSet.forEach(row -> {
                List importBillData = categoryNumber2BillDataListMap.computeIfAbsent(row.getString("categoryNumber"), k -> new ArrayList());
                importBillData.addAll((Collection)goodsNumber2BillDataMap.get(row.getString("number")));
            });
        }
    }

    private void checkCategoryMappingValid(Map<String, List<ImportBillData>> categoryNumber2BillDataListMap, Map<String, Long> materialNumber2GroupMap, List<ImportBillData> billdatas, ImportLogger logger) {
        if (categoryNumber2BillDataListMap.isEmpty()) {
            return;
        }
        HashMap categoryMapping = new HashMap(categoryNumber2BillDataListMap.size());
        QFilter mappingQFilter = new QFilter("goodscategory.number", "in", categoryNumber2BillDataListMap.keySet());
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"pmm_categorymatmapping", (String)"materialgroup,goodscategory.number goodscategory", (QFilter[])mappingQFilter.toArray(), null);
        Object object = null;
        try {
            dataSet.forEach(row -> categoryMapping.put(row.getString("goodscategory"), row.getLong("materialgroup")));
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (object != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        if (categoryMapping.isEmpty()) {
            return;
        }
        QFilter qFilter = new QFilter("material.number", "in", materialNumber2GroupMap.keySet());
        qFilter.and(new QFilter("standard", "=", (Object)BillAssistConstant.MATERIAL_STANDARD_ID));
        Throwable throwable = null;
        try (DataSet dataSet2 = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_materialgroupdetail", (String)"material.number material,group.id group", (QFilter[])qFilter.toArray(), null);){
            dataSet2.forEach(row -> materialNumber2GroupMap.put(row.getString("material"), row.getLong("group")));
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throw throwable2;
        }
        for (Map.Entry entry : categoryNumber2BillDataListMap.entrySet()) {
            String categoryNumber = (String)entry.getKey();
            Long materialGroupId = (Long)categoryMapping.get(categoryNumber);
            if (materialGroupId == null || materialGroupId == 0L) continue;
            List importBillDataList = (List)entry.getValue();
            for (ImportBillData importBillData : importBillDataList) {
                Map material = (Map)importBillData.getData().get((Object)"material");
                if (materialGroupId.equals(materialNumber2GroupMap.get(material.get("number")))) continue;
                Map goods = (Map)importBillData.getData().get((Object)"goods");
                Map category = (Map)importBillData.getData().get((Object)"category");
                Map ecGoods = (Map)importBillData.getData().get((Object)"ecgoods");
                String msg = "";
                if (goods != null) {
                    msg = ResManager.loadKDString((String)"\u5546\u54c1.\u5546\u54c1\u7f16\u7801\u201c{0}\u201d\u6240\u5c5e\u5546\u54c1\u5206\u7c7b\u5df2\u6620\u5c04\u7269\u6599\u5206\u7c7b\uff0cERP\u7269\u6599\u4e0d\u5c5e\u4e8e\u5bf9\u5e94\u5206\u7c7b\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PmmProdMatMappingImportOp_7", (String)"scm-pmm-opplugin", (Object[])new Object[]{goods.get("number")});
                } else if (ecGoods != null) {
                    msg = ResManager.loadKDString((String)"\u5546\u54c1.\u5546\u54c1\u7f16\u7801\u201c{0}\u201d\u6240\u5c5e\u5546\u54c1\u5206\u7c7b\u5df2\u6620\u5c04\u7269\u6599\u5206\u7c7b\uff0cERP\u7269\u6599\u4e0d\u5c5e\u4e8e\u5bf9\u5e94\u5206\u7c7b\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PmmProdMatMappingImportOp_7", (String)"scm-pmm-opplugin", (Object[])new Object[]{ecGoods.get("number")});
                } else if (category != null) {
                    msg = ResManager.loadKDString((String)"\u5546\u54c1\u5206\u7c7b.\u5206\u7c7b\u7f16\u7801\u201c{0}\u201d\u5df2\u6620\u5c04\u7269\u6599\u5206\u7c7b\uff0cERP\u7269\u6599\u4e0d\u5c5e\u4e8e\u5bf9\u5e94\u5206\u7c7b\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PmmProdMatMappingImportOp_8", (String)"scm-pmm-opplugin", (Object[])new Object[]{category.get("number")});
                }
                if (msg.length() <= 0) continue;
                billdatas.remove(importBillData);
                logger.log(Integer.valueOf(importBillData.getStartIndex()), msg).fail();
            }
        }
    }
}

