/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.opplugin;

import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.malcore.enums.MallStatusEnum;

public class PmmProprotocolEndOp
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog((String)PmmProprotocolEndOp.class.getName());

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("protocolstatus");
        fieldKeys.add("confirmstatus");
        fieldKeys.add("id");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] dataEntities;
        super.beforeExecuteOperationTransaction(e);
        for (DynamicObject dyn : dataEntities = e.getDataEntities()) {
            dyn.set("protocolstatus", (Object)"E");
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        HashSet<Long> idSet = new HashSet<Long>(1024);
        for (DynamicObject info : dataEntities) {
            idSet.add(info.getLong("id"));
        }
        if (idSet.size() > 0) {
            QFilter qFilter = new QFilter("protocol", "in", idSet);
            qFilter.and(new QFilter("mallstatus", "=", (Object)MallStatusEnum.UNSOLD.getVal()).or("mallstatus", "=", (Object)MallStatusEnum.SOLD.getVal()));
            HashSet<Long> downloadPoolsIDs = new HashSet<Long>(1024);
            DynamicObjectCollection prodPools = QueryServiceHelper.query((String)"pmm_prodpool", (String)"id", (QFilter[])qFilter.toArray());
            for (DynamicObject prodPool : prodPools) {
                downloadPoolsIDs.add(prodPool.getLong("id"));
            }
            log.info("downloadPoolsIDs=" + downloadPoolsIDs);
            if (downloadPoolsIDs.isEmpty()) {
                return;
            }
            OperateOption option = OperateOption.create();
            option.setVariableValue("isStrict", "false");
            option.setVariableValue("ishasright", "true");
            OperationResult downloadResullt = OperationServiceHelper.executeOperate((String)"download", (String)"pmm_prodpool", (Object[])downloadPoolsIDs.toArray(), (OperateOption)option);
            if (!downloadResullt.isSuccess()) {
                String msg = ExceptionUtil.getErrorInfoDetails((List)downloadResullt.getAllErrorOrValidateInfo());
                log.error(msg);
            }
        }
    }
}

