/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.opplugin;

import java.util.Date;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.util.DateUtil;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.malcore.enums.MallStatusEnum;

public class PmmProtocolInvalidOp
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog((String)PmmProtocolInvalidOp.class.getName());

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("id");
        e.getFieldKeys().add("invaliddate");
        e.getFieldKeys().add("effectdate");
        e.getFieldKeys().add("prosource");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] pmm_protocols;
        super.afterExecuteOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        HashSet<Long> idSet = new HashSet<Long>(1024);
        Date now = TimeServiceHelper.now();
        log.info("now=" + now);
        for (DynamicObject info : dataEntities) {
            DynamicObject[] invaliddate = info.getDate("invaliddate");
            Date effectdate = info.getDate("effectdate");
            String prosource = info.getString("prosource");
            if (!"2".equals(prosource) && !effectdate.after(now) && (null == invaliddate || !DateUtil.string2date((String)DateUtil.getFormatEndDate((Date)invaliddate), (String)"yyyy-MM-dd HH:mm:ss").before(now))) continue;
            idSet.add(info.getLong("id"));
        }
        log.info("ids=" + SerializationUtils.toJsonString(idSet));
        QFilter qFilter = new QFilter("id", "in", idSet);
        String selectors = "protocolstatus,isautosoldout";
        HashSet<Long> autoIDs = new HashSet<Long>(1024);
        for (DynamicObject info : pmm_protocols = BusinessDataServiceHelper.load((String)"pmm_protocol", (String)selectors, (QFilter[])qFilter.toArray())) {
            info.set("protocolstatus", (Object)"C");
            if (!info.getBoolean("isautosoldout")) continue;
            autoIDs.add(info.getLong("id"));
        }
        if (pmm_protocols.length > 0) {
            SaveServiceHelper.save((DynamicObject[])pmm_protocols);
        }
        if (autoIDs.size() > 0) {
            qFilter = new QFilter("protocol", "in", autoIDs);
            qFilter.and(new QFilter("mallstatus", "=", (Object)MallStatusEnum.UNSOLD.getVal()).or("mallstatus", "=", (Object)MallStatusEnum.SOLD.getVal()));
            HashSet<Long> downloadPoolsIDs = new HashSet<Long>(1024);
            DynamicObjectCollection prodPools = QueryServiceHelper.query((String)"pmm_prodpool", (String)"id", (QFilter[])qFilter.toArray());
            for (DynamicObject prodPool : prodPools) {
                downloadPoolsIDs.add(prodPool.getLong("id"));
            }
            log.info("downloadPoolsIDs=" + downloadPoolsIDs);
            if (!downloadPoolsIDs.isEmpty()) {
                OperateOption option = OperateOption.create();
                option.setVariableValue("isStrict", "false");
                option.setVariableValue("ishasright", "true");
                OperationResult downloadResullt = OperationServiceHelper.executeOperate((String)"download", (String)"pmm_prodpool", (Object[])downloadPoolsIDs.toArray(), (OperateOption)option);
                if (!downloadResullt.isSuccess()) {
                    String msg = ExceptionUtil.getErrorInfoDetails((List)downloadResullt.getAllErrorOrValidateInfo());
                    log.error(msg);
                }
            }
        }
    }
}

