/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.opplugin.event;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bec.api.IEventServicePlugin;
import kd.bos.bec.model.EntityEvent;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.malcore.domain.GoodsPriceHistoryRecord;
import kd.scm.malcore.enums.MallStatusEnum;
import kd.scm.pmm.business.service.impl.PmmGoodsPriceServiceImpl;

public class PmmProdPoolSoldAndDowmloadEventService
implements IEventServicePlugin {
    private static Log log = LogFactory.getLog(PmmProdPoolSoldAndDowmloadEventService.class);

    public Object handleEvent(KDBizEvent e) {
        log.info("PmmProdPoolSoldAndDowmloadEventService_start");
        if (!(e instanceof EntityEvent)) {
            return e.getEventId();
        }
        EntityEvent event = (EntityEvent)e;
        List businesskeys = event.getBusinesskeys();
        if (businesskeys.size() == 0) {
            return e.getEventId();
        }
        HashSet<Long> idSet = new HashSet<Long>(16);
        for (String id : businesskeys) {
            idSet.add(Long.parseLong(id));
        }
        this.dealSoldGoods(idSet);
        log.info("PmmProdPoolSoldAndDowmloadEventService_idSet=" + SerializationUtils.toJsonString(idSet));
        this.dealGoodsRulelog(idSet);
        log.info("PmmProdPoolSoldAndDowmloadEventService_end");
        return e.getEventId();
    }

    private void dealSoldGoods(Set<Long> idSet) {
        log.info("dealSoldGoods_idSet" + SerializationUtils.toJsonString(idSet));
        QFilter qFilter = new QFilter("id", "in", idSet);
        qFilter.and(new QFilter("mallstatus", "=", (Object)MallStatusEnum.SOLD.getVal()));
        String selectors = "goods.id,id,taxprice,protocol,protocolentry";
        DynamicObjectCollection pmmProdpools = QueryServiceHelper.query((String)"pmm_prodpool", (String)selectors, (QFilter[])qFilter.toArray());
        HashSet<String> keys = new HashSet<String>(16);
        HashSet<Long> goodsIds = new HashSet<Long>(16);
        for (DynamicObject row : pmmProdpools) {
            keys.add(row.getString("goods.id") + row.getString("protocol") + row.getString("protocolentry"));
            goodsIds.add(row.getLong("goods.id"));
        }
        if (pmmProdpools.size() == 0) {
            return;
        }
        log.info("dealSoldGoods_goodsIds" + SerializationUtils.toJsonString(goodsIds));
        QFilter reqQFilter = new QFilter("entryentity.goods.id", "in", goodsIds);
        reqQFilter.and(new QFilter("biztype", "=", (Object)"1"));
        reqQFilter.and(new QFilter("entryentity.entryresult", "=", (Object)"1"));
        String reqSelectors = "entryentity.goods.id,entryentity.protocolentry.id protocolentry,protocolid protocol,cfm,cfmdate,creator,createtime,entryentity.note note,origin,billno,id,org,entryentity.taxprice taxprice";
        DynamicObjectCollection pmmProdaudits = QueryServiceHelper.query((String)"pmm_prodaudit", (String)reqSelectors, (QFilter[])reqQFilter.toArray(), (String)"cfmdate asc");
        HashMap<String, Object> prodReqMap = new HashMap<String, Object>(16);
        HashMap<String, DynamicObject> laestProdReqMap = new HashMap<String, DynamicObject>(16);
        for (DynamicObject row : pmmProdaudits) {
            String key = row.getString("entryentity.goods.id") + row.getString("protocol") + row.getString("protocolentry");
            if (!keys.contains(key)) continue;
            Object list = new ArrayList(16);
            if (null != prodReqMap.get(key)) {
                list = (List)prodReqMap.get(key);
            }
            list.add((DynamicObject)row);
            prodReqMap.put(key, list);
            laestProdReqMap.put(key, row);
        }
        QFilter priceReqQFilter = new QFilter("entryentity.goods.id", "in", goodsIds);
        priceReqQFilter.and(new QFilter("cfmstatus", "=", (Object)"B"));
        String priceReqSelectors = "entryentity.goods.id,entryentity.prodpool.protocol protocol,entryentity.prodpool.protocolentry protocolentry,entryentity.taxprice taxprice,cfmdate";
        DynamicObjectCollection pmmPriceaudits = QueryServiceHelper.query((String)"pmm_priceaudit", (String)priceReqSelectors, (QFilter[])priceReqQFilter.toArray(), (String)"cfmdate asc");
        for (DynamicObject row : pmmPriceaudits) {
            String key = row.getString("entryentity.goods.id") + row.getString("protocol") + row.getString("protocolentry");
            if (!keys.contains(key)) continue;
            List<Object> list = new ArrayList<DynamicObject>(16);
            if (null != prodReqMap.get(key)) {
                list = (List)prodReqMap.get(key);
            }
            list.add(row);
            prodReqMap.put(key, list);
        }
        for (Map.Entry map : prodReqMap.entrySet()) {
            List values = (List)map.getValue();
            if (values.size() <= 1) continue;
            Collections.sort(values, new Comparator<DynamicObject>(){

                @Override
                public int compare(DynamicObject p1, DynamicObject p2) {
                    if (null != p2.getDate("cfmdate") && null != p1.getDate("cfmdate") && p2.getDate("cfmdate").before(p1.getDate("cfmdate"))) {
                        return 1;
                    }
                    if (null != p2.getDate("cfmdate") && null != p1.getDate("cfmdate") && p2.getDate("cfmdate").after(p1.getDate("cfmdate"))) {
                        return -1;
                    }
                    return 0;
                }
            });
        }
        ArrayList<GoodsPriceHistoryRecord> goodsPriceHistoryRecords = new ArrayList<GoodsPriceHistoryRecord>(16);
        for (DynamicObject row : pmmProdpools) {
            String key = row.getString("goods.id") + row.getString("protocol") + row.getString("protocolentry");
            GoodsPriceHistoryRecord goodsPriceHistoryRecord = new GoodsPriceHistoryRecord();
            goodsPriceHistoryRecord.setLastPrice(row.getBigDecimal("taxprice"));
            goodsPriceHistoryRecord.setGoodsId(row.getLong("goods.id"));
            goodsPriceHistoryRecord.setProtocolId(row.getLong("protocol"));
            goodsPriceHistoryRecord.setProtocolEntryId(row.getLong("protocolentry"));
            if (null != laestProdReqMap.get(key)) {
                if (null != prodReqMap.get(key) && ((List)prodReqMap.get(key)).size() > 1) {
                    DynamicObject lastInfo = (DynamicObject)((List)prodReqMap.get(key)).get(((List)prodReqMap.get(key)).size() - 2);
                    goodsPriceHistoryRecord.setLastPrice(lastInfo.getBigDecimal("taxprice"));
                }
                DynamicObject prodReq = (DynamicObject)laestProdReqMap.get(key);
                goodsPriceHistoryRecord.setAdjustdate(prodReq.getDate("cfmdate"));
                goodsPriceHistoryRecord.setAuditorg(prodReq.getLong("org"));
                goodsPriceHistoryRecord.setSrcBillId(prodReq.getString("id"));
                goodsPriceHistoryRecord.setSrcBillNo(prodReq.getString("billno"));
                goodsPriceHistoryRecord.setOrigin(prodReq.getString("origin"));
                if (prodReq.getString("origin").equals("1")) {
                    goodsPriceHistoryRecord.setSrcBillType("ent_prodrequest");
                } else {
                    goodsPriceHistoryRecord.setSrcBillType("pmm_prodaudit");
                }
                goodsPriceHistoryRecord.setNote(prodReq.getString("note"));
                goodsPriceHistoryRecord.setCreateDate(prodReq.getDate("createtime"));
                goodsPriceHistoryRecord.setCreatorId(prodReq.getLong("creator"));
                goodsPriceHistoryRecord.setAuditDate(prodReq.getDate("cfmdate"));
                goodsPriceHistoryRecord.setAuditorId(prodReq.getLong("cfm"));
            }
            goodsPriceHistoryRecords.add(goodsPriceHistoryRecord);
        }
        if (goodsPriceHistoryRecords.size() > 0) {
            PmmGoodsPriceServiceImpl pmmGoodsPriceService = new PmmGoodsPriceServiceImpl();
            pmmGoodsPriceService.addGoodsPriceHistoryRecords(goodsPriceHistoryRecords);
        }
        log.info("dealSoldGoods_goodsIds_end");
    }

    private void dealGoodsRulelog(Set<Long> prodPoolIds) {
        DynamicObject[] pmm_goodsrulelogs;
        QFilter qFilter = new QFilter("goodspool.id", "in", prodPoolIds);
        QFilter prodPoolStatusQFilter = new QFilter("goodspool.mallstatus", "=", (Object)MallStatusEnum.SOLD.getVal());
        prodPoolStatusQFilter.or(new QFilter("goodspool.mallstatus", "=", (Object)MallStatusEnum.SOLDOUT.getVal()));
        qFilter.and(prodPoolStatusQFilter);
        QFilter dealStatusQFilter = new QFilter("dealstatus", "=", (Object)"A");
        qFilter.and(dealStatusQFilter);
        for (DynamicObject info : pmm_goodsrulelogs = BusinessDataServiceHelper.load((String)"pmm_goodsrulelog", (String)"goodspool.id,goodspool.mallstatus,remark,dealstatus", (QFilter[])qFilter.toArray())) {
            info.set("dealstatus", (Object)"C");
            String msg = ResManager.loadKDString((String)"\u56e0\u5546\u54c1\u5931\u6548\u81ea\u52a8\u4e0b\u67b6\uff0c\u4f5c\u5e9f\u76d1\u63a7\u65e5\u5fd7", (String)"PmmProdPoolSoldAndDowmloadEventService_0", (String)"scm-pmm-opplugin", (Object[])new Object[0]);
            if (MallStatusEnum.SOLD.getVal().equals(info.getString("goodspool.mallstatus"))) {
                msg = ResManager.loadKDString((String)"\u56e0\u5546\u54c1\u76f8\u5173\u4fe1\u606f\u8c03\u6574\uff0c\u672a\u8fbe\u5230\u9608\u503c/\u751f\u6210\u65b0\u7684\u76d1\u63a7\u65e5\u5fd7\uff0c\u4f5c\u5e9f\u76d1\u63a7\u65e5\u5fd7", (String)"PmmProdPoolSoldAndDowmloadEventService_1", (String)"scm-pmm-opplugin", (Object[])new Object[0]);
            }
            info.set("remark", (Object)msg);
        }
        if (pmm_goodsrulelogs.length > 0) {
            SaveServiceHelper.save((DynamicObject[])pmm_goodsrulelogs);
        }
    }
}

