/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.opplugin.event;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.bec.api.IEventServicePlugin;
import kd.bos.bec.model.JsonEvent;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scm.common.util.ExceptionUtil;

public class PmmUnitMappUpdateEcgoodsEventService
implements IEventServicePlugin {
    private static Log log = LogFactory.getLog(PmmUnitMappUpdateEcgoodsEventService.class);
    private static final Log logger = LogFactory.getLog(PmmUnitMappUpdateEcgoodsEventService.class);

    public Object handleEvent(KDBizEvent evt) {
        JsonEvent jsonEvent = null;
        if (evt instanceof JsonEvent) {
            jsonEvent = (JsonEvent)evt;
        }
        if (jsonEvent == null) {
            logger.info("PmmUnitMappUpdateEcgoodsEventService: evt == null");
            return evt.getEventId();
        }
        String dataSource = evt.getSource();
        List parmas = (List)SerializationUtils.fromJsonString((String)dataSource, List.class);
        if (parmas.size() == 0) {
            return evt.getEventId();
        }
        Map dataMap = (Map)parmas.get(0);
        if (null == dataMap.get("unitmapping")) {
            return evt.getEventId();
        }
        if (null == dataMap.get("type")) {
            return evt.getEventId();
        }
        Map unitMappMap = (Map)SerializationUtils.fromJsonString((String)String.valueOf(dataMap.get("unitmapping")), Map.class);
        Object type = dataMap.get("type");
        HashSet<String> platForms = new HashSet<String>(16);
        for (Map.Entry map : unitMappMap.entrySet()) {
            String key = (String)map.getKey();
            String[] keys = key.split("_");
            if (keys.length != 2) continue;
            platForms.add(keys[0]);
        }
        if (platForms.size() > 0) {
            Map<String, Long> defaultUnitMap = this.getEcDefaultUnitMap(platForms);
            this.doUpdateEcGoodsUnit(unitMappMap, defaultUnitMap, type);
        }
        return evt.getEventId();
    }

    private void doUpdateEcGoodsUnit(Map<String, Object> unitMappMap, Map<String, Long> defaultUnitMap, Object type) {
        for (Map.Entry<String, Object> map : unitMappMap.entrySet()) {
            String[] keys = map.getKey().split("_");
            if (keys.length != 2) continue;
            String platform = keys[0];
            String ecunit = keys[1];
            long unitId = 0L;
            unitId = map.getValue() instanceof Long ? (Long)map.getValue() : Long.parseLong(String.valueOf(map.getValue()));
            if ("2".equals(type) && unitId == defaultUnitMap.get(platform)) continue;
            QFilter qFilter1 = new QFilter("ecunit", "=", (Object)ecunit);
            qFilter1.and(new QFilter("source", "=", (Object)platform));
            if ("1".equals(type)) {
                qFilter1.and(new QFilter("unitid", "!=", (Object)unitId));
            } else {
                qFilter1.and(new QFilter("unitid", "=", (Object)unitId));
            }
            boolean count = true;
            while (count) {
                ArrayList<Long> pkList = new ArrayList<Long>(16);
                try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"doUpdateEcGoodsUnit", (String)"pbd_mallgoods", (String)"id", (QFilter[])qFilter1.toArray(), null, (int)10000);){
                    dataSet.forEach(row -> pkList.add(row.getLong("id")));
                }
                if (0 == pkList.size()) {
                    count = false;
                    continue;
                }
                this.updateEcGoodsUnit(pkList, unitMappMap, defaultUnitMap, type);
            }
        }
    }

    private void updateEcGoodsUnit(List<Long> subIdList, Map<String, Object> unitMappMap, Map<String, Long> defaultUnitMap, Object type) {
        QFilter qFilter = new QFilter("id", "in", subIdList);
        DynamicObject[] pbd_mallgoods = BusinessDataServiceHelper.load((String)"pbd_mallgoods", (String)"unitid,source,ecunit", (QFilter[])qFilter.toArray());
        ArrayList<DynamicObject> needUpdateGoods = new ArrayList<DynamicObject>(16);
        for (DynamicObject goods : pbd_mallgoods) {
            String source = goods.getString("source");
            String ecunit = goods.getString("ecunit");
            String key = source + "_" + ecunit;
            long unitId = goods.getLong("unitid.id");
            if ("1".equals(type)) {
                long unitMapId = 0L;
                unitMapId = unitMappMap.get(key) instanceof Long ? (Long)unitMappMap.get(key) : Long.parseLong(String.valueOf(unitMappMap.get(key)));
                if (null != unitMappMap.get(key)) {
                    if (unitId == unitMapId) continue;
                    goods.set("unitid", (Object)unitMapId);
                    needUpdateGoods.add(goods);
                    continue;
                }
                if (unitId == defaultUnitMap.get(key)) continue;
                goods.set("unitid", (Object)defaultUnitMap.get(key));
                needUpdateGoods.add(goods);
                continue;
            }
            if (null == unitMappMap.get(key)) continue;
            goods.set("unitid", (Object)defaultUnitMap.get(source));
            needUpdateGoods.add(goods);
        }
        if (needUpdateGoods.size() > 0) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("ishasright", String.valueOf(true));
            option.setVariableValue("isStrict", String.valueOf(false));
            option.setVariableValue("unitmappingdelete", String.valueOf(true));
            OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)"pbd_mallgoods", (DynamicObject[])needUpdateGoods.toArray(new DynamicObject[0]), (OperateOption)option);
            if (!saveResult.isSuccess()) {
                log.error("@@@pbd_mallgoodssave_error=" + ExceptionUtil.getErrorInfoDetails((List)saveResult.getAllErrorOrValidateInfo()));
            }
        }
    }

    private Map<String, Long> getEcDefaultUnitMap(Set<String> platForms) {
        HashMap<String, Long> defaultUnitMap = new HashMap<String, Long>(16);
        QFilter qFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        qFilter.and(new QFilter("openstatus", "=", (Object)"2"));
        qFilter.and(new QFilter("platform", "in", platForms));
        qFilter.and(new QFilter("tenantid", "=", (Object)RequestContext.getOrCreate().getTenantId()));
        DynamicObjectCollection pmm_ecadmit = QueryServiceHelper.query((String)"pmm_ecadmit", (String)"mesureunits,platform", (QFilter[])qFilter.toArray());
        for (DynamicObject row : pmm_ecadmit) {
            defaultUnitMap.put(row.getString("platform"), row.getLong("mesureunits"));
        }
        return defaultUnitMap;
    }
}

