/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.opplugin.upgrade;

import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class PmmCommentOrgUpgradeService
implements IUpgradeService {
    private static Log logger = LogFactory.getLog(PmmCommentOrgUpgradeService.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setEl("warning");
        StringBuilder pProcessInfo = new StringBuilder();
        try {
            result.setLog(ResManager.loadKDString((String)"\u5f00\u59cb\u6267\u884c\u5546\u54c1\u8bc4\u4ef7\u521b\u5efa\u7ec4\u7ec7\u5347\u7ea7\u3002", (String)"PmmCommentOrgUpgradeService_0", (String)"scm-pmm-opplugin", (Object[])new Object[0]));
            boolean upgradeResult = this.upgrade(dbKey, pProcessInfo);
            if (upgradeResult) {
                result.setSuccess(true);
            } else {
                result.setSuccess(false);
                result.setErrorInfo(pProcessInfo.toString());
            }
            result.setLog(ResManager.loadKDString((String)"\u6267\u884c\u5546\u54c1\u8bc4\u4ef7\u521b\u5efa\u7ec4\u7ec7\u5347\u7ea7\u7ed3\u675f\u3002", (String)"PmmCommentOrgUpgradeService_1", (String)"scm-pmm-opplugin", (Object[])new Object[0]));
            return result;
        }
        catch (Exception e) {
            result.setErrorInfo(pProcessInfo.append(e.getMessage()).toString());
            result.setSuccess(false);
            String errorInfo = ResManager.loadKDString((String)"\u6267\u884c\u5546\u54c1\u8bc4\u4ef7\u521b\u5efa\u7ec4\u7ec7\u5347\u7ea7\u5f02\u5e38\u3002", (String)"PmmCommentOrgUpgradeService_2", (String)"scm-pmm-opplugin", (Object[])new Object[0]);
            logger.warn(errorInfo, (Throwable)e);
            throw new KDBizException(result.getErrorInfo());
        }
    }

    private boolean upgrade(String dbKey, StringBuilder pProcessInfo) {
        DBRoute dbRoute = new DBRoute(dbKey);
        Long rootOrgId = null;
        try {
            rootOrgId = OrgUnitServiceHelper.getRootOrgId();
        }
        catch (Exception e) {
            DBRoute sysDbRoute = new DBRoute("sys");
            String sqlStr = "select forgid from t_org_structure where fparentid = 0 and fviewid = 15";
            try (DataSet ds = DB.queryDataSet((String)"PmmCommentOrgUpgradeService.upgrade", (DBRoute)sysDbRoute, (String)sqlStr, null);){
                for (Row row : ds) {
                    rootOrgId = row.getLong("forgid");
                }
            }
        }
        if (rootOrgId == null || rootOrgId == 0L) {
            rootOrgId = 100000L;
        }
        pProcessInfo.append("PmmCommentOrgUpgradeService rootOrgId:").append(rootOrgId);
        Object[] param = new Object[]{rootOrgId};
        DB.execute((DBRoute)dbRoute, (String)"update t_mal_commentstrategy set fcreateorgid = ? where fid = 1692788541291215872", (Object[])param);
        DB.execute((DBRoute)dbRoute, (String)"update t_mal_commenttemplate set fcreateorgid = ? where fid = 100", (Object[])param);
        return true;
    }
}

