/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.opplugin.upgrade;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class PmmProdMatMappingUpgradeService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(PmmProdMatMappingUpgradeService.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setEl("warning");
        StringBuilder pProcessInfo = new StringBuilder();
        try {
            result.setLog("start upgrade pmm_prodmatmapping");
            boolean upgradeResult = this.upgrade(dbKey, pProcessInfo);
            if (upgradeResult) {
                result.setSuccess(true);
            } else {
                result.setSuccess(false);
                result.setErrorInfo(pProcessInfo.toString());
            }
            result.setLog("end upgrade mallgoods");
            return result;
        }
        catch (Exception e) {
            result.setErrorInfo(pProcessInfo.append(e.getMessage()).toString());
            result.setSuccess(false);
            logger.warn("end upgrade mallgoods", (Throwable)e);
            throw new KDBizException(result.getErrorInfo());
        }
    }

    public boolean upgrade(String dbKey, StringBuilder pProcessInfo) {
        DBRoute dbRoute = DBRoute.of((String)dbKey);
        String sql = "select fgoodsid from t_mal_prodmatmapping where fgoodsid != 0";
        HashSet<String> goodsIdSet = new HashSet<String>(1024);
        DataSet goodsMappingDs = this.getDataSet(dbRoute, sql);
        Object object = null;
        try {
            for (Row row : goodsMappingDs) {
                goodsIdSet.add(row.getString("fgoodsid"));
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (goodsMappingDs != null) {
                if (object != null) {
                    try {
                        goodsMappingDs.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    goodsMappingDs.close();
                }
            }
        }
        pProcessInfo.append("fgoodsid total\uff1a").append(goodsIdSet.size());
        if (!goodsIdSet.isEmpty()) {
            HashSet<String> tempGoodsIdSet = new HashSet<String>(1024);
            for (String goodsId : goodsIdSet) {
                if (tempGoodsIdSet.size() < 1000) {
                    tempGoodsIdSet.add(goodsId);
                    continue;
                }
                this.upgrade(dbRoute, tempGoodsIdSet);
                tempGoodsIdSet.clear();
            }
            if (!tempGoodsIdSet.isEmpty()) {
                this.upgrade(dbRoute, tempGoodsIdSet);
            }
        }
        return true;
    }

    private void upgrade(DBRoute dbRoute, Set<String> goodsIdSet) {
        HashMap<Long, String> goodsId2PlatformMap = new HashMap<Long, String>(1024);
        String queryGoodsSql = "select fid,fsource from t_mal_prod where fid in (" + StringUtils.join((Object[])goodsIdSet.toArray(), (String)",") + ")";
        try (DataSet goodsDs = this.getDataSet(dbRoute, queryGoodsSql);){
            for (Row row : goodsDs) {
                goodsId2PlatformMap.put(row.getLong("fid"), row.getString("fsource"));
            }
            ArrayList<Object[]> updatePlatformParams = new ArrayList<Object[]>(goodsId2PlatformMap.size());
            ArrayList<Object[]> updateEcGoodsParams = new ArrayList<Object[]>(goodsId2PlatformMap.size());
            for (Map.Entry entry : goodsId2PlatformMap.entrySet()) {
                Object[] updatePlatformParam = new Object[]{entry.getValue(), entry.getKey()};
                updatePlatformParams.add(updatePlatformParam);
                if ("1".equals(entry.getValue())) continue;
                Object[] updateEcGoodsParam = new Object[]{entry.getKey(), entry.getKey()};
                updateEcGoodsParams.add(updateEcGoodsParam);
            }
            if (!updatePlatformParams.isEmpty()) {
                String updatePlatformSql = "update t_mal_prodmatmapping set fplatform = ? where fgoodsid = ?";
                this.updateBatch(dbRoute, updatePlatformSql, updatePlatformParams);
            }
            if (!updateEcGoodsParams.isEmpty()) {
                String updateEcGoodsSql = "update t_mal_prodmatmapping set fecgoodsid = ? where fgoodsid = ?";
                this.updateBatch(dbRoute, updateEcGoodsSql, updateEcGoodsParams);
            }
        }
    }

    private void updateBatch(DBRoute dbRoute, String updateSql, List<Object[]> paramsList) {
        DB.executeBatch((DBRoute)dbRoute, (String)updateSql, paramsList);
    }

    private DataSet getDataSet(DBRoute dbRoute, String sql) {
        return DB.queryDataSet((String)RequestContext.get().getTraceId(), (DBRoute)dbRoute, (String)sql);
    }
}

