/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.opplugin.upgrade;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class PmmProdPoolPricetypeUpgradeService
implements IUpgradeService {
    private static Log logger = LogFactory.getLog(PmmProdPoolPricetypeUpgradeService.class);
    private static int Page_Index_Max = 5000;

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setEl("warning");
        StringBuilder pProcessInfo = new StringBuilder();
        try {
            result.setLog("start upgrad prodpool");
            boolean upgradeResult = this.upgrade(dbKey, pProcessInfo);
            if (upgradeResult) {
                result.setSuccess(true);
            } else {
                result.setSuccess(false);
                result.setErrorInfo(pProcessInfo.toString());
            }
            result.setLog("end upgrad prodpool");
            return result;
        }
        catch (Exception e) {
            result.setErrorInfo(pProcessInfo.append(e.getMessage()).toString());
            result.setSuccess(false);
            logger.warn("end upgrad prodpool", (Throwable)e);
            throw new KDBizException(result.getErrorInfo());
        }
    }

    private boolean upgrade(String dbKey, StringBuilder pProcessInfo) {
        DBRoute dbRoute = new DBRoute(dbKey);
        String countSql = "select count(fid) id from t_mal_protocolprodpool where fplatform = '1' and fpricetype in (' ','A')";
        int prodCount = 0;
        try (DataSet dataSet = DB.queryDataSet((String)"kd.scm.pmm.opplugin.upgrade.PmmProdPoolPricetyoeUpgradeService", (DBRoute)dbRoute, (String)countSql);){
            prodCount = ((Number)dataSet.next().get("id")).intValue();
        }
        pProcessInfo.append("prodpoolQty=").append(prodCount).append("\n");
        if (prodCount == 0) {
            return true;
        }
        String prodEntrySql = "select fid from t_mal_poolladderentry";
        ArrayList<Long> prodpoolLadEntryIds = new ArrayList<Long>(1024);
        ArrayList<Long> prodpoolLadEntryIds2B = new ArrayList<Long>(1024);
        try (DataSet dataSet = DB.queryDataSet((String)"kd.scm.pmm.opplugin.upgrade.PmmProdPoolPricetyoeUpgradeService", (DBRoute)DBRoute.of((String)"pur"), (String)prodEntrySql);){
            for (Row prodDyn : dataSet) {
                Long poolId = prodDyn.getLong("fid");
                if (prodpoolLadEntryIds.contains(poolId) && !prodpoolLadEntryIds2B.contains(poolId)) {
                    prodpoolLadEntryIds2B.add(poolId);
                    continue;
                }
                prodpoolLadEntryIds.add(poolId);
            }
        }
        pProcessInfo.append("prodpoolLadEntryIds2B=").append(prodpoolLadEntryIds2B.size()).append("\n");
        if (prodpoolLadEntryIds2B.size() == 0) {
            return true;
        }
        int pageSize = prodpoolLadEntryIds2B.size() / Page_Index_Max;
        if (prodpoolLadEntryIds2B.size() % Page_Index_Max != 0) {
            ++pageSize;
        }
        for (int pageIndex = 0; pageIndex < pageSize; ++pageIndex) {
            List<Long> prodPoolIds = (pageIndex + 1) * Page_Index_Max > prodpoolLadEntryIds2B.size() ? prodpoolLadEntryIds2B.subList(pageIndex * Page_Index_Max, prodpoolLadEntryIds2B.size()) : prodpoolLadEntryIds2B.subList(pageIndex * Page_Index_Max, (pageIndex + 1) * Page_Index_Max);
            if (prodPoolIds.size() <= 0) continue;
            this.updateProdPoolTable2B(dbRoute, prodPoolIds);
        }
        return true;
    }

    private void updateProdPoolTable2B(DBRoute dbRoute, List<Long> prodPoolIds) {
        ArrayList<Object[]> prodPoolParamIds = new ArrayList<Object[]>(1024);
        for (Long id : prodPoolIds) {
            prodPoolParamIds.add(new Object[]{id});
        }
        String updateSql = "update t_mal_protocolprodpool set fpricetype = 'B' where fid = ?";
        DB.executeBatch((DBRoute)dbRoute, (String)updateSql, prodPoolParamIds);
    }
}

