/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.opplugin.upgrade;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.DBServiceHelper;

public class PmmProdPoolUpgradeService
implements IUpgradeService {
    private static Log logger = LogFactory.getLog(PmmProdPoolUpgradeService.class);
    private static int Page_Index_Max = 5000;

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setEl("warning");
        StringBuilder pProcessInfo = new StringBuilder();
        try {
            result.setLog(ResManager.loadKDString((String)"\u5f00\u59cb\u6267\u884c\u5347\u7ea7\u5546\u54c1\u7ba1\u7406\u81f3\u5546\u54c1\u6c60\u3002", (String)"PmmProdPoolUpgradeService_0", (String)"scm-pmm-opplugin", (Object[])new Object[0]));
            boolean upgradeResult = this.upgrade(dbKey, pProcessInfo);
            if (upgradeResult) {
                result.setSuccess(true);
            } else {
                result.setSuccess(false);
                result.setErrorInfo(pProcessInfo.toString());
            }
            result.setLog(ResManager.loadKDString((String)"\u6267\u884c\u5347\u7ea7\u5546\u54c1\u7ba1\u7406\u81f3\u5546\u54c1\u6c60\u811a\u672c\u7ed3\u675f\u3002", (String)"PmmProdPoolUpgradeService_1", (String)"scm-pmm-opplugin", (Object[])new Object[0]));
            return result;
        }
        catch (Exception e) {
            result.setErrorInfo(pProcessInfo.append(e.getMessage()).toString());
            result.setSuccess(false);
            String errorInfo = ResManager.loadKDString((String)"\u5347\u7ea7\u5546\u54c1\u7ba1\u7406\u81f3\u5546\u54c1\u6c60\u6267\u884c\u5f02\u5e38\u3002", (String)"PmmProdPoolUpgradeService_2", (String)"scm-pmm-opplugin", (Object[])new Object[0]);
            logger.warn(errorInfo, (Throwable)e);
            throw new KDBizException(result.getErrorInfo());
        }
    }

    private boolean upgrade(String dbKey, StringBuilder pProcessInfo) {
        Serializable ids;
        DBRoute dbRoute = new DBRoute(dbKey);
        Date date = new Date();
        String countSql = "select count(fid) id from t_mal_prod where fsource = '1'";
        int prodCount = 0;
        try (DataSet dataSet = DB.queryDataSet((String)"kd.scm.pmm.opplugin.upgrade.PmmProdPoolUpgradeService", (DBRoute)DBRoute.of((String)"pur"), (String)countSql);){
            prodCount = ((Number)dataSet.next().get("id")).intValue();
        }
        pProcessInfo.append(String.format(ResManager.loadKDString((String)"\u5546\u54c1\u66f4\u65b0\u6570\u91cf\u4e3a%s", (String)"PmmProdPoolUpgradeService_3", (String)"scm-pmm-opplugin", (Object[])new Object[0]), prodCount)).append("\n");
        if (prodCount == 0) {
            return true;
        }
        ArrayList<Object[]> protocolProdPoolParams = new ArrayList<Object[]>(prodCount * 2);
        ArrayList<Object[]> protocolProdPoolLParams = new ArrayList<Object[]>(prodCount * 2);
        ArrayList<Object[]> prodEntryParams = new ArrayList<Object[]>(prodCount * 2);
        String prodEntrySql = "select fid from t_mal_prodentry";
        ArrayList<Long> prodEntryIds = new ArrayList<Long>();
        try (DataSet dataSet = DB.queryDataSet((String)"kd.scm.pmm.opplugin.upgrade.PmmProdPoolUpgradeService", (DBRoute)DBRoute.of((String)"pur"), (String)prodEntrySql);){
            for (Object prodDyn : dataSet) {
                prodEntryIds.add(prodDyn.getLong("fid"));
            }
        }
        StringBuilder goodsQuerySql = new StringBuilder("select a.fid,a.fnumber,a.fname,a.ftaxprice,a.ftaxrate,a.ftaxrateid,a.fprice,a.funitid,a.fmallstatus,a.fstatus,b.fcreateorgid From t_mal_prod as A LEFT JOIN t_mal_prod_a as B on A.fid = B.fid Where A.fsource = '1' And A.fid not in (");
        for (int i = 0; i < prodEntryIds.size(); ++i) {
            ids = (Long)prodEntryIds.get(i);
            goodsQuerySql.append(ids);
            if (i == prodEntryIds.size() - 1) continue;
            goodsQuerySql.append(",");
        }
        goodsQuerySql.append(")");
        if (prodEntryIds.isEmpty()) {
            goodsQuerySql = new StringBuilder("select a.fid,a.fnumber,a.fname,a.ftaxprice,a.ftaxrate,a.ftaxrateid,a.fprice,a.funitid,a.fmallstatus,a.fstatus,b.fcreateorgid From t_mal_prod as A LEFT JOIN t_mal_prod_a as B on A.fid = B.fid Where A.fsource = '1'");
        }
        DataSet dataSet = DB.queryDataSet((String)"kd.scm.pmm.opplugin.upgrade.PmmProdPoolUpgradeService", (DBRoute)DBRoute.of((String)"pur"), (String)goodsQuerySql.toString());
        ids = null;
        try {
            for (Row prodDyn : dataSet) {
                Object[] protocolProdPoolParam = this.getProtocolProdPoolParam(prodDyn, date);
                Object[] protocolProdPoolLParam = this.getProtocolProdPoolLParam(prodDyn);
                Object[] prodEntryParam = this.getProdEntryParam(prodDyn);
                protocolProdPoolParams.add(protocolProdPoolParam);
                protocolProdPoolLParams.add(protocolProdPoolLParam);
                prodEntryParams.add(prodEntryParam);
            }
        }
        catch (Throwable prodDyn) {
            ids = prodDyn;
            throw prodDyn;
        }
        finally {
            if (dataSet != null) {
                if (ids != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable prodDyn) {
                        ((Throwable)ids).addSuppressed(prodDyn);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        pProcessInfo.append(String.format(ResManager.loadKDString((String)"\u9700\u66f4\u65b0\u5546\u54c1\u603b\u7684\u6570\u4e3a%s", (String)"PmmProdPoolUpgradeService_6", (String)"scm-pmm-opplugin", (Object[])new Object[0]), protocolProdPoolParams.size()));
        int pageSize = protocolProdPoolParams.size() / Page_Index_Max;
        if (protocolProdPoolParams.size() % Page_Index_Max != 0) {
            ++pageSize;
        }
        pProcessInfo.append(String.format(ResManager.loadKDString((String)"\u5546\u54c1\u66f4\u65b0\u603b\u9875\u6570\u4e3a%s", (String)"PmmProdPoolUpgradeService_4", (String)"scm-pmm-opplugin", (Object[])new Object[0]), pageSize)).append("\n");
        for (int pageIndex = 0; pageIndex < pageSize; ++pageIndex) {
            List<Object[]> prodEntrySubList;
            List<Object[]> protocolProdPoolLSubList;
            List<Object[]> protocolProdPoolSubList;
            long[] prodPoolEntryIds = null;
            if ((pageIndex + 1) * Page_Index_Max > protocolProdPoolParams.size()) {
                prodPoolEntryIds = DBServiceHelper.genLongIds((String)"T_MAL_PRODENTRY", (int)protocolProdPoolParams.size());
                protocolProdPoolSubList = protocolProdPoolParams.subList(pageIndex * Page_Index_Max, protocolProdPoolParams.size());
                protocolProdPoolLSubList = protocolProdPoolLParams.subList(pageIndex * Page_Index_Max, protocolProdPoolLParams.size());
                prodEntrySubList = prodEntryParams.subList(pageIndex * Page_Index_Max, prodEntryParams.size());
            } else {
                prodPoolEntryIds = DBServiceHelper.genLongIds((String)"T_MAL_PRODENTRY", (int)Page_Index_Max);
                protocolProdPoolSubList = protocolProdPoolParams.subList(pageIndex * Page_Index_Max, (pageIndex + 1) * Page_Index_Max);
                protocolProdPoolLSubList = protocolProdPoolLParams.subList(pageIndex * Page_Index_Max, (pageIndex + 1) * Page_Index_Max);
                prodEntrySubList = prodEntryParams.subList(pageIndex * Page_Index_Max, (pageIndex + 1) * Page_Index_Max);
            }
            if (!protocolProdPoolSubList.isEmpty()) {
                this.updateProtocolProdPoolTable(dbRoute, protocolProdPoolSubList);
                this.updateProtocolProdPoolLTable(dbRoute, protocolProdPoolLSubList);
                this.updateProdEntryTable(dbRoute, prodEntrySubList, prodPoolEntryIds);
            }
            pProcessInfo.append(MessageFormat.format(ResManager.loadKDString((String)"\u6267\u884c\u7b2c{0}\u6279\u6b21\u6570\u636e\u5347\u7ea7\u6210\u529f\u3002", (String)"PmmProdPoolUpgradeService_5", (String)"scm-pmm-opplugin", (Object[])new Object[0]), pageIndex + 1)).append("\n");
        }
        return true;
    }

    private String codeRuleCreate(String number) {
        StringBuilder s;
        String dateStr = "20230101";
        if (number == null) {
            number = "";
        }
        if ((s = new StringBuilder(number)).length() > 3) {
            s.insert(2, "C");
            s.insert(4, dateStr + "-");
        } else {
            s.append("C");
            s.append(dateStr);
        }
        return s.toString();
    }

    private Object[] getProtocolProdPoolParam(Row prodDyn, Date date) {
        Object[] prodPoolParam = new Object[25];
        long id = prodDyn.getLong("fid");
        long masterid = prodDyn.getLong("fid");
        String number = this.codeRuleCreate(prodDyn.getString("fnumber"));
        String name = prodDyn.getString("fname");
        Object taxprice = prodDyn.get("ftaxprice");
        Object taxrateid = prodDyn.get("ftaxrateid");
        Object price = prodDyn.get("fprice");
        Object unitid = prodDyn.get("funitid");
        String status = prodDyn.getString("fstatus");
        long goodsid = 0L;
        if ("C".equals(status)) {
            goodsid = prodDyn.getLong("fid");
        }
        Object taxrate = prodDyn.get("ftaxrate");
        String mallstatus = prodDyn.getString("fmallstatus");
        String salestatus = "D";
        if ("A".equals(mallstatus) || "B".equals(mallstatus)) {
            salestatus = "A";
        }
        Long orgId = prodDyn.getLong("fcreateorgid");
        prodPoolParam[0] = id;
        prodPoolParam[1] = number;
        prodPoolParam[2] = name;
        prodPoolParam[3] = taxprice;
        prodPoolParam[4] = taxrateid;
        prodPoolParam[5] = price;
        prodPoolParam[6] = unitid;
        prodPoolParam[7] = goodsid;
        prodPoolParam[8] = orgId;
        prodPoolParam[9] = orgId;
        prodPoolParam[10] = mallstatus;
        prodPoolParam[11] = salestatus;
        prodPoolParam[12] = "1";
        prodPoolParam[13] = "1";
        prodPoolParam[14] = "1";
        prodPoolParam[15] = date;
        prodPoolParam[16] = date;
        prodPoolParam[17] = masterid;
        prodPoolParam[18] = taxrate;
        prodPoolParam[19] = "C";
        prodPoolParam[20] = 0L;
        prodPoolParam[21] = 0L;
        prodPoolParam[22] = 1L;
        prodPoolParam[23] = 1L;
        prodPoolParam[24] = "1";
        return prodPoolParam;
    }

    private void updateProtocolProdPoolTable(DBRoute dbRoute, List<Object[]> protocolProdPoolSubList) {
        String insertSql = "insert into t_mal_protocolprodpool (FID,fnumber,fname,ftaxprice,ftaxrateid,fprice,funitid,fgoodsid,fcreateorgid,fauditorgid,fmallstatus,fsalestatus,fcentralpurtype,fplatform,fenable,fmodifytime,fcreatetime,fmasterid,ftaxrate,fstatus,fmallprotocolid,fprotocolentryid,fcreatorid,fmodifierid,fisgoodvisible) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        DB.executeBatch((DBRoute)dbRoute, (String)insertSql, protocolProdPoolSubList);
    }

    private Object[] getProtocolProdPoolLParam(Row prodDyn) {
        Object[] prodPoolParam = new Object[4];
        long id = prodDyn.getLong("fid");
        String name = prodDyn.getString("fname");
        prodPoolParam[0] = id;
        prodPoolParam[1] = String.valueOf(id);
        prodPoolParam[2] = "zh_CN";
        prodPoolParam[3] = name;
        return prodPoolParam;
    }

    private void updateProtocolProdPoolLTable(DBRoute dbRoute, List<Object[]> protocolProdPoolLSubList) {
        String insertSql = "insert into t_mal_protocolprodpool_l (FID,fpkid,flocaleid,fname) VALUES (?,?,?,?)";
        DB.executeBatch((DBRoute)dbRoute, (String)insertSql, protocolProdPoolLSubList);
    }

    private Object[] getProdEntryParam(Row prodDyn) {
        Object[] prodPoolParam = new Object[5];
        long id = prodDyn.getLong("fid");
        prodPoolParam[0] = id;
        prodPoolParam[1] = 0L;
        prodPoolParam[2] = id;
        prodPoolParam[3] = 0L;
        return prodPoolParam;
    }

    private void updateProdEntryTable(DBRoute dbRoute, List<Object[]> prodEntrySubList, long[] prodPoolEntryIds) {
        for (int i = 0; i < prodEntrySubList.size(); ++i) {
            Object[] objects = prodEntrySubList.get(i);
            objects[4] = prodPoolEntryIds[i];
        }
        String insertSql = "insert into t_mal_prodentry (FID,fseq,fprodpoolid,fprotocolid,fentryid) VALUES (?,?,?,?,?)";
        DB.executeBatch((DBRoute)dbRoute, (String)insertSql, prodEntrySubList);
    }
}

