/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.opplugin.validator;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class PackageSelectionMainGoodsValidator
extends AbstractValidator {
    public Set<String> preparePropertys() {
        Set propertys = super.preparePropertys();
        propertys.add("number");
        propertys.add("name");
        propertys.add("entryentity.goods");
        propertys.add("entryentity.goods.id");
        propertys.add("entryentity.goods.number");
        propertys.add("entryentity.goods.name");
        propertys.add("entryentity.isprimary");
        return propertys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate() {
        HashMap<Long, Integer> goodsmap = new HashMap<Long, Integer>(this.dataEntities.length);
        HashSet<Long> mainGoodids = new HashSet<Long>(this.dataEntities.length);
        for (ExtendedDataEntity extendedDataEntity : this.dataEntities) {
            DynamicObject info = extendedDataEntity.getDataEntity();
            DynamicObjectCollection entryentitys = info.getDynamicObjectCollection("entryentity");
            Long mainGoods = null;
            for (DynamicObject entry : entryentitys) {
                if (!entry.getBoolean("isprimary") || entry.getDynamicObject("goods") == null) continue;
                mainGoods = entry.getLong("goods.id");
                mainGoodids.add(mainGoods);
                if (goodsmap.get(mainGoods) != null) {
                    goodsmap.put(mainGoods, (Integer)goodsmap.get(mainGoods) + 1);
                    continue;
                }
                goodsmap.put(mainGoods, 1);
            }
        }
        QFilter flter = new QFilter("status", "=", (Object)"C");
        flter.and("enable", "=", (Object)"1");
        flter.and("entryentity.isprimary", "=", (Object)true);
        flter.and("entryentity.goods.id", "in", mainGoodids);
        DataSet ds = null;
        DataSet groupds = null;
        try {
            ds = QueryServiceHelper.queryDataSet((String)"PackageSelectionMainGoodsValidator", (String)"pmm_packageselection", (String)"entryentity.goods.id", (QFilter[])new QFilter[]{flter}, null);
            groupds = ds.groupBy(new String[]{"entryentity.goods.id"}).count("count").finish();
            while (groupds.hasNext()) {
                Row row = groupds.next();
                Long mainGoods = row.getLong("entryentity.goods.id");
                if (goodsmap.get(mainGoods) != null) {
                    goodsmap.put(mainGoods, (Integer)goodsmap.get(mainGoods) + row.getInteger("count"));
                    continue;
                }
                goodsmap.put(mainGoods, row.getInteger("count"));
            }
        }
        finally {
            if (ds != null) {
                ds.close();
            }
            if (groupds != null) {
                groupds.close();
            }
        }
        for (ExtendedDataEntity extendedDataEntity : this.dataEntities) {
            DynamicObject info = extendedDataEntity.getDataEntity();
            DynamicObjectCollection entryentitys = info.getDynamicObjectCollection("entryentity");
            Long mainGoods = null;
            for (DynamicObject entry : entryentitys) {
                int count;
                mainGoods = entry.getLong("goods.id");
                if (!entry.getBoolean("isprimary") || mainGoods == null || goodsmap.get(mainGoods) == null || (count = ((Integer)goodsmap.get(mainGoods)).intValue()) <= 6) continue;
                String error = ResManager.loadKDString((String)"\u4e00\u4e2a\u4e3b\u5546\u54c1\u6700\u591a\u53ea\u80fd\u8bbe\u7f6e6\u4e2a\u53ef\u7528\u91c7\u8d2d\u5957\u9910\uff0c\u8bf7\u4fee\u6539\u5546\u54c1\u4fe1\u606f\u6216\u7981\u7528\u76f8\u5173\u5957\u9910\u3002", (String)"PackageSelectionMainGoodsValidator_0", (String)"scm-pmm-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(extendedDataEntity, error);
            }
        }
    }
}

