/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.opplugin.validator;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.ValidateMatchUtil;

public class PmmAddressSaveValidator
extends AbstractValidator {
    public Set<String> preparePropertys() {
        Set set = super.preparePropertys();
        set.add("address");
        set.add("phone");
        set.add("email");
        set.add("default");
        set.add("number");
        set.add("name");
        return set;
    }

    public void validate() {
        HashSet<Long> admindivisionIdSet = new HashSet<Long>(this.dataEntities.length);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject addressDyn = dataEntity.getDataEntity();
            admindivisionIdSet.add(addressDyn.getLong("address"));
        }
        DynamicObjectCollection admindivisionDyns = QueryServiceHelper.query((String)"bd_admindivision", (String)"id,fullname,level,country.number,country.twocountrycode", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)admindivisionIdSet.toArray(new Object[0]))});
        HashMap<Object, DynamicObject> admindivisionDynMap = new HashMap<Object, DynamicObject>();
        for (DynamicObject admindivisionDyn : admindivisionDyns) {
            admindivisionDynMap.put(admindivisionDyn.get("id"), admindivisionDyn);
        }
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            String email;
            String phone;
            DynamicObject addressDyn = dataEntity.getDataEntity();
            admindivisionIdSet.add(addressDyn.getLong("address"));
            DynamicObject admindivisionDyn = (DynamicObject)admindivisionDynMap.get(addressDyn.getLong("address"));
            if (admindivisionDyn == null) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"'\u7701\u5e02\u533a'\u8bf7\u586b\u5199\u5b8c\u6574\u3002", (String)"PmmAddressSaveValidator_0", (String)"scm-pmm-opplugin", (Object[])new Object[0]));
                continue;
            }
            int level = admindivisionDyn.getInt("level");
            String fullName = admindivisionDyn.getString("fullname");
            if (level < 3 && ("001".equals(admindivisionDyn.getString("country.number")) || "CN".equals(admindivisionDyn.getString("country.twocountrycode")))) {
                if (this.isMunicipality(fullName)) {
                    if (level < 2) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"'\u7701\u5e02\u533a'\u8bf7\u586b\u5199\u5b8c\u6574\u3002", (String)"PmmAddressSaveValidator_0", (String)"scm-pmm-opplugin", (Object[])new Object[0]));
                    }
                } else {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"'\u7701\u5e02\u533a'\u8bf7\u586b\u5199\u5b8c\u6574\u3002", (String)"PmmAddressSaveValidator_0", (String)"scm-pmm-opplugin", (Object[])new Object[0]));
                }
            } else if (level < 1) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"'\u7701\u5e02\u533a'\u8bf7\u586b\u5199\u5b8c\u6574\u3002", (String)"PmmAddressSaveValidator_0", (String)"scm-pmm-opplugin", (Object[])new Object[0]));
            }
            if (StringUtils.isNotEmpty((CharSequence)(phone = addressDyn.getString("phone"))) && !ValidateMatchUtil.isTel((String)phone) && !StringUtils.isPhoneNumberValid((String)phone)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u586b\u5199\u7684\u8054\u7cfb\u65b9\u5f0f\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u60a8\u7684\u624b\u673a\u53f7\u7801\u6216\u56fa\u5b9a\u7535\u8bdd\u3002", (String)"PmmAddressSaveValidator_1", (String)"scm-pmm-opplugin", (Object[])new Object[0]));
            }
            if (!StringUtils.isNotEmpty((CharSequence)(email = addressDyn.getString("email"))) || ValidateMatchUtil.isEmail((String)email)) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u90ae\u7bb1\u683c\u5f0f\u4e0d\u5bf9\u3002", (String)"PmmAddressSaveValidator_2", (String)"scm-pmm-opplugin", (Object[])new Object[0]));
        }
    }

    private boolean isMunicipality(String addressName) {
        if (addressName == null) {
            return false;
        }
        String regex = ResManager.loadKDString((String)".*(\u91cd\u5e86|\u5317\u4eac|\u4e0a\u6d77|\u5929\u6d25).*", (String)"PmmAddressSaveValidator_5", (String)"scm-pmm-opplugin", (Object[])new Object[0]);
        return addressName.matches(regex);
    }
}

