/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.opplugin.validator;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.scm.malcore.enums.ProdCommentTypeEnum;

public class PmmCommentTemplateSubmitValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity extendedDataEntity : this.dataEntities) {
            DynamicObject dynamicObject = extendedDataEntity.getDataEntity();
            if (!"A".equals(dynamicObject.getString("status")) || !this.checkInfoEntryValid(extendedDataEntity)) continue;
            this.checkClassEntryValid(extendedDataEntity);
        }
    }

    private boolean checkInfoEntryValid(ExtendedDataEntity extendedDataEntity) {
        DynamicObject dynamicObject = extendedDataEntity.getDataEntity();
        DynamicObjectCollection infoEntry = dynamicObject.getDynamicObjectCollection("commtplinfoentry");
        if (infoEntry.size() > 10) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u6700\u591a\u53ef\u7ef4\u62a410\u884c\u5206\u5f55\u3002", (String)"PmmCommentTemplateSubmitValidator_0", (String)"scm-pmm-opplugin", (Object[])new Object[0]));
            return false;
        }
        Map<String, Integer> countMap = this.getCountMap();
        for (DynamicObject entry : infoEntry) {
            DynamicObject module = entry.getDynamicObject("module");
            if (module == null) continue;
            DynamicObject group = module.getDynamicObject("group");
            String type = group.getString("number");
            Integer integer = countMap.get(type);
            countMap.put(type, integer + 1);
        }
        if (countMap.get(ProdCommentTypeEnum.PICTURE.getVal()) > 1) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bc4\u4ef7\u7ef4\u5ea6\u4ec5\u53ef\u7ef4\u62a4\u4e00\u884c\u9644\u4ef6\u7c7b\u578b\u7684\u7ec4\u4ef6\u3002", (String)"PmmCommentTemplateSubmitValidator_1", (String)"scm-pmm-opplugin", (Object[])new Object[0]));
            return false;
        }
        if (countMap.get(ProdCommentTypeEnum.STARS.getVal()) == 0) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bc4\u4ef7\u7ef4\u5ea6\u81f3\u5c11\u7ef4\u62a4\u4e00\u884c\u661f\u7ea7\u7ec4\u4ef6\u3002", (String)"PmmCommentTemplateSubmitValidator_2", (String)"scm-pmm-opplugin", (Object[])new Object[0]));
            return false;
        }
        if (countMap.get(ProdCommentTypeEnum.LEVEL.getVal()) != 1) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bc4\u4ef7\u7ef4\u5ea6\u5fc5\u5f55\u4e00\u884c\u201c\u8bc4\u4ef7\u7b49\u7ea7\u201d\uff0c\u8bf7\u7ef4\u62a4\u3002", (String)"PmmCommentTemplateSubmitValidator_3", (String)"scm-pmm-opplugin", (Object[])new Object[0]));
            return false;
        }
        if (countMap.get(ProdCommentTypeEnum.LABEL.getVal()) > 1) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bc4\u4ef7\u7ef4\u5ea6\u4ec5\u53ef\u7ef4\u62a4\u4e00\u884c\u6807\u7b7e\u7c7b\u578b\u7684\u7ec4\u4ef6\u3002", (String)"PmmCommentTemplateSubmitValidator_6", (String)"scm-pmm-opplugin", (Object[])new Object[0]));
            return false;
        }
        if (countMap.get(ProdCommentTypeEnum.TEXT.getVal()) > 5) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bc4\u4ef7\u7ef4\u5ea6\u6700\u591a\u4ec5\u53ef\u7ef4\u62a4\u4e94\u884c\u6587\u672c\u6846\u7c7b\u578b\u7684\u7ec4\u4ef6\u3002", (String)"PmmCommentTemplateSubmitValidator_7", (String)"scm-pmm-opplugin", (Object[])new Object[0]));
            return false;
        }
        if (countMap.get(ProdCommentTypeEnum.STARS.getVal()) > 5) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bc4\u4ef7\u7ef4\u5ea6\u6700\u591a\u4ec5\u53ef\u7ef4\u62a4\u4e94\u884c\u661f\u7ea7\u7c7b\u578b\u7684\u7ec4\u4ef6\u3002", (String)"PmmCommentTemplateSubmitValidator_8", (String)"scm-pmm-opplugin", (Object[])new Object[0]));
            return false;
        }
        if (countMap.get(ProdCommentTypeEnum.SCORE.getVal()) > 5) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bc4\u4ef7\u7ef4\u5ea6\u6700\u591a\u4ec5\u53ef\u7ef4\u62a4\u4e94\u884c\u6570\u503c\u6253\u5206\u7c7b\u578b\u7684\u7ec4\u4ef6\u3002", (String)"PmmCommentTemplateSubmitValidator_9", (String)"scm-pmm-opplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private Map<String, Integer> getCountMap() {
        HashMap<String, Integer> typeAndNumMap = new HashMap<String, Integer>(8);
        typeAndNumMap.put(ProdCommentTypeEnum.STARS.getVal(), 0);
        typeAndNumMap.put(ProdCommentTypeEnum.SCORE.getVal(), 0);
        typeAndNumMap.put(ProdCommentTypeEnum.TEXT.getVal(), 0);
        typeAndNumMap.put(ProdCommentTypeEnum.LABEL.getVal(), 0);
        typeAndNumMap.put(ProdCommentTypeEnum.PICTURE.getVal(), 0);
        typeAndNumMap.put(ProdCommentTypeEnum.LEVEL.getVal(), 0);
        return typeAndNumMap;
    }

    private boolean checkClassEntryValid(ExtendedDataEntity extendedDataEntity) {
        DynamicObjectCollection classEntry;
        DynamicObject dynamicObject = extendedDataEntity.getDataEntity();
        if (!dynamicObject.getBoolean("alluse") && ((classEntry = dynamicObject.getDynamicObjectCollection("commtplclassentry")) == null || classEntry.isEmpty())) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u7ef4\u62a4\u4e00\u884c\u5546\u54c1\u5206\u7c7b\u3002", (String)"PmmCommentTemplateSubmitValidator_10", (String)"scm-pmm-opplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }
}

