/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.opplugin.validator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class PmmGoodsExpenseSaveValidator
extends AbstractValidator {
    public void validate() {
        Long currentNodeId;
        DynamicObject dynamicObject;
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        ArrayList<Long> goodUses = new ArrayList<Long>(dataEntities.length);
        HashSet<Long> groups = new HashSet<Long>(dataEntities.length);
        HashMap<String, List> goodUseAndDynsMap = new HashMap<String, List>(dataEntities.length);
        ArrayList<Long> expenseIds = new ArrayList<Long>(dataEntities.length);
        HashMap classIdAndLevelMap = new HashMap(dataEntities.length);
        for (ExtendedDataEntity rowData : dataEntities) {
            dynamicObject = rowData.getDataEntity();
            currentNodeId = dynamicObject.getLong("group_id");
            classIdAndLevelMap.put(currentNodeId, null);
        }
        try (ExtendedDataEntity[] dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"mdr_goodsclass", (String)"id,parent,level", (QFilter[])new QFilter("id", "in", classIdAndLevelMap.keySet()).toArray(), (String)"id");){
            dataSet.forEach(row -> classIdAndLevelMap.put(row.getLong("id"), row.getInteger("level")));
        }
        for (ExtendedDataEntity rowData : dataEntities) {
            String name;
            dynamicObject = rowData.getDataEntity();
            currentNodeId = dynamicObject.getLong("group_id");
            Integer level = (Integer)classIdAndLevelMap.get(currentNodeId);
            if (level == null || level != 3) {
                this.addErrorMessage(rowData, ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5728\u5546\u54c1\u4e09\u7ea7\u5206\u7c7b\u4e0b\u7ef4\u62a4\u7528\u9014\u7684\u6620\u5c04\u5173\u7cfb\u3002", (String)"PmmGoodsExpenseSaveValidator_4", (String)"scm-pmm-opplugin", (Object[])new Object[0]));
            }
            DynamicObjectCollection dynList = dynamicObject.getDynamicObjectCollection("entryentity");
            ArrayList<Long> expenseitem = new ArrayList<Long>(3);
            boolean valid = true;
            DynamicObject endEntry = (DynamicObject)dynList.get(dynList.size() - 1);
            String controltype = dynamicObject.getString("controltype");
            String string = name = "0".equals(controltype) ? "priceto" : "qtyto";
            if (BigDecimal.ZERO.compareTo(endEntry.getBigDecimal(name)) != 0) {
                String msg = "0".equals(controltype) ? ResManager.loadKDString((String)"\u6700\u540e\u4e00\u884c\u5355\u4ef7\u81f3\u9700\u4e3a\u7a7a\uff0c\u5426\u5219\u90e8\u5206\u60c5\u51b5\u4e0b\u65e0\u6cd5\u83b7\u53d6\u8d39\u7528\u9879\u76ee\u3002", (String)"PmmGoodsExpenseSaveValidator_5", (String)"scm-pmm-opplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6700\u540e\u4e00\u884c\u91d1\u989d\u81f3\u9700\u4e3a\u7a7a\uff0c\u5426\u5219\u90e8\u5206\u60c5\u51b5\u4e0b\u65e0\u6cd5\u83b7\u53d6\u8d39\u7528\u9879\u76ee\u3002", (String)"PmmGoodsExpenseSaveValidator_6", (String)"scm-pmm-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(rowData, msg);
                continue;
            }
            for (DynamicObject dyn : dynList) {
                Long expenseid = dyn.getLong("expenseitem_id");
                if (expenseitem.contains(expenseid)) {
                    this.addErrorMessage(rowData, ResManager.loadKDString((String)"\u4e0d\u540c\u7684\u63a7\u5236\u6761\u4ef6\uff0c\u8d39\u7528\u9879\u76ee\u4e0d\u5141\u8bb8\u76f8\u540c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PmmGoodsExpenseSaveValidator_2", (String)"scm-pmm-opplugin", (Object[])new Object[0]));
                    valid = false;
                    break;
                }
                expenseitem.add(expenseid);
            }
            if (!valid) continue;
            goodUses.add(dynamicObject.getLong("gooduse_id"));
            List extendedDataEntities = goodUseAndDynsMap.computeIfAbsent(dynamicObject.getString("gooduse_id") + "_" + dynamicObject.getString("group_id"), k -> new ArrayList());
            extendedDataEntities.add(rowData);
            groups.add(dynamicObject.getLong("group_id"));
            expenseIds.add(dynamicObject.getLong("id"));
        }
        QFilter qFilter = new QFilter("gooduse", "in", goodUses);
        qFilter.and("group", "in", groups);
        qFilter.and("id", "not in", expenseIds);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"pmm_goods_expense", (String)"gooduse,group", (QFilter[])qFilter.toArray(), (String)"gooduse");){
            dataSet.forEach(row -> {
                List extendedDataEntities = (List)goodUseAndDynsMap.remove(row.getString("gooduse") + "_" + row.getString("group"));
                if (extendedDataEntities != null && !extendedDataEntities.isEmpty()) {
                    extendedDataEntities.forEach(extendedDataEntity -> this.addErrorMessage((ExtendedDataEntity)extendedDataEntity, ResManager.loadKDString((String)"\u8be5\u5546\u54c1\u5206\u7c7b\u4e0b\u5df2\u5b58\u5728\u8be5\u5546\u54c1\u7528\u9014\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PmmGoodsExpenseSaveValidator_3", (String)"scm-pmm-opplugin", (Object[])new Object[0])));
                }
            });
        }
    }
}

