/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.opplugin.validator;

import java.util.ArrayList;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.ecapi.enums.EcPlatformEnum;

public class PmmGoodsRuleLogOperateUpValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        HashSet<Long> goodsIds = new HashSet<Long>(16);
        HashSet<Long> supplierIds = new HashSet<Long>(16);
        ArrayList<String> platforms = new ArrayList<String>(16);
        HashSet<Long> goodsPoolIds = new HashSet<Long>(16);
        boolean isContinue = true;
        for (ExtendedDataEntity extendedDataEntity : dataEntities) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            String dealstatus = dataEntity.getString("dealstatus");
            String goodsnum = dataEntity.getString("goodsnum");
            if (!"A".equals(dealstatus)) {
                String msg = ResManager.loadKDString((String)"\u5546\u54c1{0}\u5df2\u5904\u7406\uff0c\u65e0\u9700\u518d\u53d1\u8d77\u624b\u5de5\u4e0a\u67b6\u3002", (String)"PmmGoodsRuleLogUoerateUpValidator_3", (String)"scm-pmm-opplugin", (Object[])new Object[]{goodsnum});
                this.addErrorMessage(extendedDataEntity, msg);
                isContinue = false;
            }
            goodsIds.add(Long.parseLong(dataEntity.getString("goodsid")));
            platforms.add(dataEntity.getString("platform"));
            supplierIds.add(dataEntity.getLong("supplier.id"));
            goodsPoolIds.add(dataEntity.getLong("goodspool.id"));
        }
        if (!isContinue) {
            return;
        }
        for (ExtendedDataEntity extendedDataEntity : dataEntities) {
            String msg;
            if (platforms.size() > 1) {
                msg = ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u591a\u4e2a\u7535\u5546\u4e00\u8d77\u4e0a\u67b6\u3002", (String)"PmmGoodsRuleLogUoerateUpValidator_0", (String)"scm-pmm-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(extendedDataEntity, msg);
                isContinue = false;
                break;
            }
            if (supplierIds.size() <= 1) continue;
            msg = ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u591a\u4e2a\u4f9b\u5e94\u5546\u4e00\u8d77\u4e0a\u67b6\u3002", (String)"PmmGoodsRuleLogUoerateUpValidator_1", (String)"scm-pmm-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(extendedDataEntity, msg);
            isContinue = false;
            break;
        }
        if (!isContinue) {
            return;
        }
        if (platforms.size() == 1 && supplierIds.size() == 1) {
            String platForm = (String)platforms.get(0);
            QFilter qFilter = null;
            String fromId = "";
            String seletor = "";
            if (!EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(platForm)) {
                qFilter = new QFilter("id", "in", goodsIds);
                fromId = "pbd_mallgoods";
                seletor = "id,statusinfo.ecstatus ecstatus,statusinfo.mallstatus mallstatus";
            } else {
                qFilter = new QFilter("id", "in", goodsPoolIds);
                fromId = "pmm_prodpool";
                seletor = "id,mallstatus,salestatus,protocolentry,protocol";
            }
            HashSet<Long> noMatchIds = new HashSet<Long>();
            DynamicObjectCollection goodsInfos = QueryServiceHelper.query((String)fromId, (String)seletor, (QFilter[])qFilter.toArray());
            for (DynamicObject info : goodsInfos) {
                String mallstatus;
                if (!EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(platForm)) {
                    mallstatus = info.getString("mallstatus");
                    String ecstatus = info.getString("ecstatus");
                    if ((!"1".equals(mallstatus) || !"1".equals(ecstatus)) && !"0".equals(ecstatus)) continue;
                    noMatchIds.add(info.getLong("id"));
                    continue;
                }
                mallstatus = info.getString("mallstatus");
                if (!"B".equals(mallstatus)) continue;
                noMatchIds.add(info.getLong("id"));
            }
            for (ExtendedDataEntity extendedDataEntity : dataEntities) {
                DynamicObject dataEntity = extendedDataEntity.getDataEntity();
                String goodsid = dataEntity.getString("goodsid");
                if (EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(platForm)) {
                    goodsid = dataEntity.getString("goodspool.id");
                }
                String goodsnum = dataEntity.getString("goodsnum");
                if (StringUtils.isEmpty((CharSequence)goodsid) || !noMatchIds.contains(Long.parseLong(goodsid))) continue;
                String msg = ResManager.loadKDString((String)"\u5546\u54c1{0}\u5df2\u4e0a\u67b6\uff0c\u65e0\u9700\u518d\u53d1\u8d77\u624b\u5de5\u4e0a\u67b6\u3002", (String)"PmmGoodsRuleLogUoerateUpValidator_2", (String)"scm-pmm-opplugin", (Object[])new Object[]{goodsnum});
                this.addErrorMessage(extendedDataEntity, msg);
            }
        }
    }
}

