/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.opplugin.validator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class PmmProdAuditBarcodeValidator
extends AbstractValidator {
    public void validate() {
        ArrayList<String> barcodes = new ArrayList<String>(1024);
        HashSet<Long> supIds = new HashSet<Long>(1024);
        HashMap<Long, Object> prodId_BarcodeMap = new HashMap<Long, Object>(1024);
        HashMap prodId_goodsIdMap = new HashMap(1024);
        for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            long id = dataEntity.getLong("id");
            if ("2".equals(dataEntity.getString("biztype"))) continue;
            HashMap barcodeMap = new HashMap(1024);
            DynamicObjectCollection dynamicObjectCollection = dataEntity.getDynamicObjectCollection("entryentity");
            HashSet goodsSet = new HashSet(1024);
            for (DynamicObject row : dynamicObjectCollection) {
                if (null == row.getDynamicObject("goods") || StringUtils.isEmpty((CharSequence)row.getString("barcode"))) continue;
                String barcode = row.getString("barcode");
                barcodes.add(barcode);
                supIds.add(dataEntity.getLong("supplier.id"));
                Set<String> goodsNumberSet = new HashSet<String>(1024);
                if (null != barcodeMap.get(barcode)) {
                    goodsNumberSet = (Set)barcodeMap.get(barcode);
                }
                goodsNumberSet.add(row.getDynamicObject("goods").getString("number"));
                barcodeMap.put(barcode, goodsNumberSet);
                goodsSet.add(row.getDynamicObject("goods").getLong("id"));
            }
            prodId_goodsIdMap.put(id, goodsSet);
            prodId_BarcodeMap.put(dataEntity.getLong("id"), barcodeMap);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            Map barcodeMap = (Map)prodId_BarcodeMap.get(dataEntity.getLong("id"));
            if (null == barcodeMap) continue;
            for (Map.Entry entry : barcodeMap.entrySet()) {
                if (((Set)entry.getValue()).size() <= 1) continue;
                stringBuilder.setLength(0);
                for (String key : (Set)entry.getValue()) {
                    stringBuilder.append(key).append(',');
                }
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5546\u54c1\u6761\u5f62\u7801\u201c{0}\u201d\u5b58\u5728\u51b2\u7a81\u7684\u5546\u54c1\u201c{1}\u201d\u3002", (String)"PmmProdAuditBarcodeValidator_3", (String)"scm-pmm-opplugin", (Object[])new Object[]{entry.getKey(), stringBuilder.subSequence(0, stringBuilder.toString().length() - 1)}));
            }
        }
        if (barcodes.size() > 0) {
            QFilter qFilter = new QFilter("barcode", "in", barcodes);
            qFilter.and(new QFilter("supplier", "in", supIds));
            String selectors = "id,barcode,supplier,origin,number,status";
            DynamicObjectCollection prods = QueryServiceHelper.query((String)"pmm_prodmanage", (String)selectors, (QFilter[])qFilter.toArray());
            HashMap sup_BarcodeMap = new HashMap(1024);
            for (DynamicObject info : prods) {
                Long supId = info.getLong("supplier");
                String string = info.getString("barcode");
                Map<String, Object> barcode_goodMap = new HashMap<String, DynamicObject>(1024);
                if (null != sup_BarcodeMap.get(supId)) {
                    barcode_goodMap = (Map)sup_BarcodeMap.get(supId);
                }
                barcode_goodMap.put(string, info);
                sup_BarcodeMap.put(supId, barcode_goodMap);
            }
            if (sup_BarcodeMap.size() > 0) {
                for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
                    DynamicObject dataEntity = extendedDataEntity.getDataEntity();
                    DynamicObjectCollection entrys = dataEntity.getDynamicObjectCollection("entryentity");
                    long supId = dataEntity.getLong("supplier.id");
                    Map barcode_goodMap = (Map)sup_BarcodeMap.get(supId);
                    Set goodsSet = (Set)prodId_goodsIdMap.get(dataEntity.getLong("id"));
                    for (DynamicObject row : entrys) {
                        if (null == row.getDynamicObject("goods") || StringUtils.isEmpty((CharSequence)row.getString("barcode")) || null == barcode_goodMap.get(row.getString("barcode"))) continue;
                        DynamicObject prod = (DynamicObject)barcode_goodMap.get(row.getString("barcode"));
                        Long goodsId = prod.getLong("id");
                        String status = prod.getString("status");
                        String origin = prod.getString("origin");
                        String prodNum = prod.getString("number");
                        if (row.getDynamicObject("goods").getLong("id") == goodsId.longValue() || goodsSet.contains(goodsId)) continue;
                        if (status.equals("C")) {
                            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5546\u54c1\u7f16\u7801\u201c{0}\u201d\u4e0e\u5df2\u6709\u5546\u54c1\u201c{1}\u201d\u7684\u6761\u5f62\u7801\u51b2\u7a81\u3002", (String)"PmmProdAuditBarcodeValidator_0", (String)"scm-pmm-opplugin", (Object[])new Object[]{row.getDynamicObject("goods").getString("number"), prodNum}));
                            continue;
                        }
                        if (origin.equals("1")) {
                            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5546\u54c1\u7f16\u7801\u201c{0}\u201d\u4e0e\u5df2\u6709\u4f9b\u5e94\u5546\u7aef\u6682\u5b58\u7684\u5546\u54c1\u201c{1}\u201d\u7684\u6761\u5f62\u7801\u51b2\u7a81\u3002", (String)"PmmProdAuditBarcodeValidator_1", (String)"scm-pmm-opplugin", (Object[])new Object[]{row.getDynamicObject("goods").getString("number"), prodNum}));
                            continue;
                        }
                        this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5546\u54c1\u7f16\u7801\u201c{0}\u201d\u4e0e\u5df2\u6709\u91c7\u8d2d\u7aef\u6682\u5b58\u7684\u5546\u54c1\u201c{1}\u201d\u7684\u6761\u5f62\u7801\u51b2\u7a81\u3002", (String)"PmmProdAuditBarcodeValidator_2", (String)"scm-pmm-opplugin", (Object[])new Object[]{row.getDynamicObject("goods").getString("number"), prodNum}));
                    }
                }
            }
        }
    }
}

