/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.opplugin.validator;

import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class PmmProdAuditSrcBillValidator
extends AbstractValidator {
    public Set<String> preparePropertys() {
        Set propertys = super.preparePropertys();
        propertys.add("entryentity.srcbilltype");
        propertys.add("entryentity.srcbillid");
        propertys.add("entryentity.goods.id");
        propertys.add("entryentity.goods.number");
        return propertys;
    }

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        HashSet<Long> srcBillIds = new HashSet<Long>(16);
        for (ExtendedDataEntity extendedDataEntity : dataEntities) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            DynamicObjectCollection entryCols = dataEntity.getDynamicObjectCollection("entryentity");
            for (DynamicObject row : entryCols) {
                String srcBillId = row.getString("srcbillid");
                String srcBillType = row.getString("srcbilltype");
                if (!"pmm_goodsrulelog".equals(srcBillType) || !StringUtils.isEmpty((CharSequence)srcBillId)) continue;
                srcBillIds.add(Long.parseLong(srcBillId));
            }
        }
        if (srcBillIds.size() > 0) {
            QFilter qFilter = new QFilter("id", "in", srcBillIds);
            qFilter.and(new QFilter("dealstatus", "=", (Object)"A"));
            DynamicObjectCollection goodRuleLogs = QueryServiceHelper.query((String)"pmm_goodsrulelog", (String)"id", (QFilter[])qFilter.toArray());
            HashSet<String> goodRuleLogIds = new HashSet<String>(16);
            for (DynamicObject logInfo : goodRuleLogs) {
                goodRuleLogIds.add(logInfo.getString("id"));
            }
            for (ExtendedDataEntity extendedDataEntity : dataEntities) {
                DynamicObject dataEntity = extendedDataEntity.getDataEntity();
                DynamicObjectCollection entryCols = dataEntity.getDynamicObjectCollection("entryentity");
                for (DynamicObject row : entryCols) {
                    String srcBillId = row.getString("srcbillid");
                    String srcBillType = row.getString("srcbilltype");
                    if (null == row.get("goods") || !"pmm_goodsrulelog".equals(srcBillType) || !StringUtils.isEmpty((CharSequence)srcBillId) || goodRuleLogIds.contains(srcBillId)) continue;
                    String msg = ResManager.loadKDString((String)"\u5546\u54c1{0}\u5173\u8054\u7684\u5546\u54c1\u5de1\u68c0\u65e5\u5fd7\u5df2\u5904\u7406\u6216\u8005\u5df2\u4f5c\u5e9f\u3002", (String)"PmmProdAuditSrcBillValidator_0", (String)"scm-pmm-opplugin", (Object[])new Object[]{row.getString("goods.number")});
                    this.addErrorMessage(extendedDataEntity, msg);
                }
            }
        }
    }
}

