/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.opplugin.validator;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.malcore.enums.MallStatusEnum;
import kd.scm.malcore.util.prodinfochange.MalProdInfoChangeUtil;

public class PmmProdChangeManageSubmitValidator
extends AbstractValidator {
    public void validate() {
        HashMap<Long, ExtendedDataEntity> checkMalOrderDyns = new HashMap<Long, ExtendedDataEntity>(this.dataEntities.length);
        HashMap<Long, ExtendedDataEntity> prodIdAndDyns = new HashMap<Long, ExtendedDataEntity>(this.dataEntities.length);
        HashSet<Long> hasMessageProdIds = new HashSet<Long>(this.dataEntities.length);
        for (ExtendedDataEntity extendedDataEntity : this.dataEntities) {
            DynamicObject dynamicObject = extendedDataEntity.getDataEntity();
            if (StringUtils.isNotBlank((CharSequence)dynamicObject.getString("cfmstatus"))) continue;
            long prod_id = dynamicObject.getLong("prod_id");
            String prodNumber = dynamicObject.getDynamicObject("prod").getString("number");
            if (prodIdAndDyns.containsKey(prod_id)) {
                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5bf9\u5546\u54c1%s\u7684\u591a\u4e2a\u53d8\u66f4\u5355\u540c\u65f6\u8fdb\u884c\u63d0\u4ea4\u64cd\u4f5c\u3002", (String)"PmmProdChangeManageSubmitValidator_0", (String)"scm-pmm-opplugin", (Object[])new Object[0]), prodNumber));
                if (!hasMessageProdIds.add(prod_id)) continue;
                checkMalOrderDyns.remove(prod_id);
                this.addErrorMessage((ExtendedDataEntity)prodIdAndDyns.get(prod_id), String.format(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5bf9\u5546\u54c1%s\u7684\u591a\u4e2a\u53d8\u66f4\u5355\u540c\u65f6\u8fdb\u884c\u63d0\u4ea4\u64cd\u4f5c\u3002", (String)"PmmProdChangeManageSubmitValidator_0", (String)"scm-pmm-opplugin", (Object[])new Object[0]), prodNumber));
                continue;
            }
            prodIdAndDyns.put(prod_id, extendedDataEntity);
            if (!MalProdInfoChangeUtil.checkChangeFieldInfluenceMalOrder((DynamicObject)extendedDataEntity.getDataEntity())) continue;
            checkMalOrderDyns.put(prod_id, extendedDataEntity);
        }
        QFilter qFilterChangeOrder = new QFilter("prod", "in", prodIdAndDyns.keySet());
        qFilterChangeOrder.and(new QFilter("cfmstatus", "in", Arrays.asList("A", "E")));
        DynamicObjectCollection prodChangeManages = QueryServiceHelper.query((String)"pmm_prodchange_manage", (String)"prod.id prod,prod.number prodnumber", (QFilter[])qFilterChangeOrder.toArray());
        for (DynamicObject prodChangeManage : prodChangeManages) {
            String msg = ResManager.loadKDString((String)"\u8be5\u5546\u54c1%s\u5b58\u5728\u672a\u5b8c\u7ed3\u7684\u53d8\u66f4\u5355\uff0c\u65e0\u6cd5\u53d1\u8d77\u65b0\u7684\u4fe1\u606f\u53d8\u66f4\u3002", (String)"PmmProdChangeManageSubmitValidator_1", (String)"scm-pmm-opplugin", (Object[])new Object[0]);
            this.addErrorMessage((ExtendedDataEntity)prodIdAndDyns.get(prodChangeManage.getLong("prod")), String.format(msg, prodChangeManage.getString("prodnumber")));
            prodIdAndDyns.remove(prodChangeManage.getLong("prod"));
        }
        QFilter qFilter = new QFilter("entryentity.goods", "in", checkMalOrderDyns.keySet());
        DynamicObjectCollection malOrders = QueryServiceHelper.query((String)"mal_order", (String)"entryentity.goods goods", (QFilter[])qFilter.toArray());
        for (DynamicObject malOrder : malOrders) {
            this.addErrorMessage((ExtendedDataEntity)prodIdAndDyns.get(malOrder.getLong("goods")), ResManager.loadKDString((String)"\u5546\u54c1\u5df2\u5173\u8054\u8ba2\u5355\uff0c\u90e8\u5206\u4fe1\u606f\u4e0d\u80fd\u4fee\u6539\uff0c\u65e0\u6cd5\u63d0\u4ea4\u3002", (String)"PmmProdChangeManageSubmitValidator_2", (String)"scm-pmm-opplugin", (Object[])new Object[0]));
            prodIdAndDyns.remove(malOrder.getLong("goods"));
        }
        QFilter qFilterProdRequest = new QFilter("entryentity.goods", "in", prodIdAndDyns.keySet());
        qFilterProdRequest.and("cfmstatus", "in", Arrays.asList("A", "E"));
        DynamicObjectCollection prodRequests = QueryServiceHelper.query((String)"ent_prodrequest", (String)"entryentity.goods goods", (QFilter[])qFilterProdRequest.toArray());
        for (DynamicObject prodRequest : prodRequests) {
            this.addErrorMessage((ExtendedDataEntity)prodIdAndDyns.get(prodRequest.getLong("goods")), ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5b8c\u7ed3\u7684\u4e0a\u4e0b\u67b6\u7533\u8bf7\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"PmmProdChangeManageSubmitValidator_3", (String)"scm-pmm-opplugin", (Object[])new Object[0]));
            prodIdAndDyns.remove(prodRequest.getLong("goods"));
        }
        QFilter qFilterProd = new QFilter("id", "in", prodIdAndDyns.keySet());
        qFilterProd.and("protocolentry.protocol", "is null", (Object)0L);
        qFilterProd.and("mallstatus", "not in", Arrays.asList(MallStatusEnum.SOLD.getVal(), MallStatusEnum.UNSOLD.getVal()));
        DynamicObjectCollection prods = QueryServiceHelper.query((String)"ent_prodmanage", (String)"id,spunumber", (QFilter[])qFilterProd.toArray());
        for (DynamicObject prod : prods) {
            if (StringUtils.isNotBlank((CharSequence)prod.getString("spunumber"))) continue;
            this.addErrorMessage((ExtendedDataEntity)prodIdAndDyns.get(prod.getLong("goods")), ResManager.loadKDString((String)"\u5546\u54c1\u4e0a\u67b6\u72b6\u6001\u4e0d\u662f\u5df2\u4e0a\u67b6/\u5f85\u4e0a\u67b6\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"PmmProdChangeManageSubmitValidator_4", (String)"scm-pmm-opplugin", (Object[])new Object[0]));
            prodIdAndDyns.remove(prod.getLong("goods"));
        }
        QFilter spuQFilter = new QFilter("spuskumapentry.goods", "in", prodIdAndDyns.keySet());
        spuQFilter.and("status", "!=", (Object)"E");
        spuQFilter.and("spuskumapentry.confirmstatus", "!=", (Object)"B");
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"pmm_spu", (String)"id,number,spuskumapentry.goods goods", (QFilter[])spuQFilter.toArray(), (String)"id");){
            dataSet.forEach(row -> {
                String number = row.getString("number");
                ExtendedDataEntity extendedDataEntity = (ExtendedDataEntity)prodIdAndDyns.remove(row.getLong("goods"));
                if (extendedDataEntity != null) {
                    String msg = ResManager.loadKDString((String)"\u5546\u54c1\u5df2\u88abSPU\u201c%s\u201d\u9009\u4e2d\uff0c\u4e0d\u80fd\u53d8\u66f4\u3002\u8bf7\u5148\u53d6\u6d88\u9009\u4e2d\u6216\u5b8c\u6210SPU\u786e\u8ba4\u6d41\u7a0b\u518d\u53d1\u8d77\u53d8\u66f4\u3002", (String)"PmmProdChangeManageSubmitValidator_5", (String)"scm-pmm-opplugin", (Object[])new Object[0]);
                    this.addErrorMessage(extendedDataEntity, String.format(msg, number));
                }
            });
        }
    }
}

