/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.opplugin.validator;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;

public class PmmSameGoodsRuleSaveValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity extendedDataEntity : dataEntities = this.getDataEntities()) {
            this.validateSameRuleEntry(extendedDataEntity);
            this.validateMonitorRuleEntry(extendedDataEntity);
            this.validateRulesEntry(extendedDataEntity);
        }
    }

    private void validateRulesEntry(ExtendedDataEntity extendedDataEntity) {
        DynamicObject dataEntity = extendedDataEntity.getDataEntity();
        boolean isGoodsMonitor = dataEntity.getBoolean("isgoodsmonitor");
        if (!isGoodsMonitor) {
            return;
        }
        DynamicObjectCollection samecompareEntry = dataEntity.getDynamicObjectCollection("samecompareentry");
        boolean isAllEmpty = true;
        for (DynamicObject row : samecompareEntry) {
            if (null == row.get("pricerule")) continue;
            isAllEmpty = false;
            break;
        }
        DynamicObjectCollection monitorEntry = dataEntity.getDynamicObjectCollection("pricemonitorentry");
        boolean isAllMonitorEmpty = true;
        for (DynamicObject row : monitorEntry) {
            if (null == row.get("monitorpricerule")) continue;
            isAllMonitorEmpty = false;
            break;
        }
        if ((samecompareEntry.size() == 0 || isAllEmpty) && (monitorEntry.size() == 0 || isAllMonitorEmpty)) {
            String msg = ResManager.loadKDString((String)"\u542f\u7528\u5f00\u542f\u5546\u54c1\u76d1\u63a7\u53c2\u6570\u65f6\uff0c\u81f3\u5c11\u914d\u7f6e\u4e00\u6761\u76d1\u63a7\u89c4\u5219\u3002", (String)"PmmSameGoodsRuleSaveValidator_1", (String)"scm-pmm-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(extendedDataEntity, msg);
        }
    }

    private void validateMonitorRuleEntry(ExtendedDataEntity extendedDataEntity) {
        DynamicObject dataEntity = extendedDataEntity.getDataEntity();
        DynamicObjectCollection pricemonitorentry = dataEntity.getDynamicObjectCollection("pricemonitorentry");
        for (DynamicObject row : pricemonitorentry) {
            BigDecimal endprice;
            String msg;
            if (null == row.get("monitorpricerule")) continue;
            boolean ispricesameprice = dataEntity.getBoolean("ispricesameprice");
            DynamicObject priceRuleDyn = row.getDynamicObject("monitorpricerule");
            String thresholdtype = priceRuleDyn.getString("thresholdtype");
            if ("1".equals(thresholdtype)) continue;
            String samethreshold = row.getString("monitorsamethreshold");
            String controltype = row.getString("monitorcontroltype");
            if (StringUtils.isEmpty((CharSequence)samethreshold)) {
                msg = ResManager.loadKDString((String)"\u5546\u54c1\u4fe1\u606f\u53d8\u52a8\u76d1\u63a7\u89c4\u5219\u5206\u5f55\u7b2c{0}\u884c\u9619\u503c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PmmSameGoodsRuleSaveValidator_4", (String)"scm-pmm-opplugin", (Object[])new Object[]{row.getInt("seq")});
                this.addErrorMessage(extendedDataEntity, msg);
            }
            if (StringUtils.isEmpty((CharSequence)controltype)) {
                msg = ResManager.loadKDString((String)"\u5546\u54c1\u4fe1\u606f\u53d8\u52a8\u76d1\u63a7\u89c4\u5219\u5206\u5f55\u7b2c{0}\u884c\u63a7\u5236\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PmmSameGoodsRuleSaveValidator_5", (String)"scm-pmm-opplugin", (Object[])new Object[]{row.getInt("seq")});
                this.addErrorMessage(extendedDataEntity, msg);
            }
            if (!ispricesameprice) continue;
            BigDecimal startprice = BigDecimal.ZERO;
            if (null != row.getBigDecimal("monitorstartprice")) {
                startprice = row.getBigDecimal("monitorstartprice");
            }
            if (null != (endprice = row.getBigDecimal("monitorendprice")) && endprice.compareTo(BigDecimal.ZERO) != 0 && endprice.compareTo(startprice) <= 0) {
                String msg2 = ResManager.loadKDString((String)"\u5546\u54c1\u4fe1\u606f\u53d8\u52a8\u76d1\u63a7\u89c4\u5219\u5206\u5f55\u7b2c{0}\u884c\u4ef7\u683c\u4e0a\u9650\uff08<\uff09\u5c0f\u4e8e\u7b49\u4e8e\u4ef7\u683c\u4e0b\u9650\uff08>=\uff09\u3002", (String)"PmmSameGoodsRuleSaveValidator_7", (String)"scm-pmm-opplugin", (Object[])new Object[]{row.getInt("seq")});
                this.addErrorMessage(extendedDataEntity, msg2);
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (DynamicObject tarRow : pricemonitorentry) {
                long tarRuleId;
                long srcRuleId;
                if (null == row.get("monitorpricerule") || null == tarRow.get("monitorpricerule") || row.getInt("seq") == tarRow.getInt("seq") || null == row.get("monitorpricerule") || null == tarRow.get("monitorpricerule") || (srcRuleId = row.getLong("monitorpricerule.id")) != (tarRuleId = tarRow.getLong("monitorpricerule.id"))) continue;
                BigDecimal tarStartPrice = BigDecimal.ZERO;
                if (null != tarRow.getBigDecimal("monitorstartprice")) {
                    tarStartPrice = tarRow.getBigDecimal("monitorstartprice");
                }
                BigDecimal tarEndPrice = tarRow.getBigDecimal("monitorendprice");
                if (endprice.compareTo(BigDecimal.ZERO) == 0 && (startprice.compareTo(tarStartPrice) <= 0 || startprice.compareTo(tarStartPrice) > 0 && (tarEndPrice.compareTo(BigDecimal.ZERO) == 0 || startprice.compareTo(tarEndPrice) < 0))) {
                    stringBuilder.append(tarRow.getInt("seq")).append(",");
                    continue;
                }
                if (endprice.compareTo(BigDecimal.ZERO) == 0 || (tarEndPrice.compareTo(BigDecimal.ZERO) != 0 || endprice.compareTo(tarStartPrice) <= 0) && (endprice.compareTo(tarStartPrice) <= 0 || endprice.compareTo(tarEndPrice) > 0)) continue;
                stringBuilder.append(tarRow.getInt("seq")).append(",");
            }
            if (stringBuilder.length() <= 1) continue;
            String substring = stringBuilder.substring(0, stringBuilder.toString().length() - 1);
            String msg3 = ResManager.loadKDString((String)"\u5546\u54c1\u4fe1\u606f\u53d8\u52a8\u76d1\u63a7\u89c4\u5219\u5206\u5f55\u7b2c{0}\u884c\u4e0e\u7b2c{1}\u884c\u5b58\u5728\u4ef7\u683c\u8303\u56f4\u51b2\u7a81\u3002", (String)"PmmSameGoodsRuleSaveValidator_9", (String)"scm-pmm-opplugin", (Object[])new Object[]{row.getInt("seq"), substring});
            this.addErrorMessage(extendedDataEntity, msg3);
        }
    }

    private void validateSameRuleEntry(ExtendedDataEntity extendedDataEntity) {
        DynamicObject dataEntity = extendedDataEntity.getDataEntity();
        boolean isSameKind = dataEntity.getBoolean("issamekind");
        boolean isGoodsMonitor = dataEntity.getBoolean("isgoodsmonitor");
        if (isSameKind) {
            DynamicObjectCollection entryentity = dataEntity.getDynamicObjectCollection("entryentity");
            boolean isAllEmpty = true;
            for (DynamicObject row : entryentity) {
                DynamicObjectCollection samerules;
                if (null == row.get("samerule") || (samerules = row.getDynamicObjectCollection("samerule")).size() <= 0) continue;
                isAllEmpty = false;
                break;
            }
            if (entryentity.size() == 0 || isAllEmpty) {
                String msg = ResManager.loadKDString((String)"\u542f\u7528\u540c\u6b3e\u89c4\u5219\u53c2\u6570\u65f6\uff0c\u81f3\u5c11\u914d\u7f6e\u4e00\u6761\u540c\u6b3e\u89c4\u5219\u3002", (String)"PmmSameGoodsRuleSaveValidator_0", (String)"scm-pmm-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(extendedDataEntity, msg);
            }
        }
        if (isGoodsMonitor) {
            boolean iscomparesameprice = dataEntity.getBoolean("iscomparesameprice");
            DynamicObjectCollection samecompareentry = dataEntity.getDynamicObjectCollection("samecompareentry");
            boolean isAllEmpty = true;
            for (DynamicObject row : samecompareentry) {
                if (null == row.get("pricerule")) continue;
                isAllEmpty = false;
                break;
            }
            if (samecompareentry.size() == 0 || isAllEmpty) {
                return;
            }
            for (DynamicObject row : samecompareentry) {
                BigDecimal endprice;
                String msg;
                DynamicObject priceRuleDyn;
                String thresholdtype;
                if (null != row.get("pricerule") && !"1".equals(thresholdtype = (priceRuleDyn = row.getDynamicObject("pricerule")).getString("thresholdtype"))) {
                    String samethreshold = row.getString("samethreshold");
                    String controltype = row.getString("controltype");
                    if (StringUtils.isEmpty((CharSequence)samethreshold)) {
                        msg = ResManager.loadKDString((String)"\u540c\u6b3e\u5546\u54c1\u6bd4\u4ef7\u5904\u7406\u89c4\u5219\u5206\u5f55\u7b2c{0}\u884c\u9619\u503c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PmmSameGoodsRuleSaveValidator_2", (String)"scm-pmm-opplugin", (Object[])new Object[]{row.getInt("seq")});
                        this.addErrorMessage(extendedDataEntity, msg);
                    }
                    if (StringUtils.isEmpty((CharSequence)controltype)) {
                        msg = ResManager.loadKDString((String)"\u540c\u6b3e\u5546\u54c1\u6bd4\u4ef7\u5904\u7406\u89c4\u5219\u5206\u5f55\u7b2c{0}\u884c\u63a7\u5236\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PmmSameGoodsRuleSaveValidator_3", (String)"scm-pmm-opplugin", (Object[])new Object[]{row.getInt("seq")});
                        this.addErrorMessage(extendedDataEntity, msg);
                    }
                }
                if (!iscomparesameprice) continue;
                BigDecimal startprice = BigDecimal.ZERO;
                if (null != row.getBigDecimal("startprice")) {
                    startprice = row.getBigDecimal("startprice");
                }
                if (null != (endprice = row.getBigDecimal("endprice")) && endprice.compareTo(BigDecimal.ZERO) != 0 && endprice.compareTo(startprice) <= 0) {
                    String msg2 = ResManager.loadKDString((String)"\u540c\u6b3e\u5546\u54c1\u6bd4\u4ef7\u5904\u7406\u89c4\u5219\u5206\u5f55\u7b2c{0}\u884c\u4ef7\u683c\u4e0a\u9650\uff08<\uff09\u5c0f\u4e8e\u7b49\u4e8e\u4ef7\u683c\u4e0b\u9650\uff08>=\uff09\u3002", (String)"PmmSameGoodsRuleSaveValidator_6", (String)"scm-pmm-opplugin", (Object[])new Object[]{row.getInt("seq")});
                    this.addErrorMessage(extendedDataEntity, msg2);
                    continue;
                }
                StringBuilder stringBuilder = new StringBuilder();
                for (DynamicObject tarRow : samecompareentry) {
                    long tarRuleId;
                    long srcRuleId;
                    if (null == row.get("pricerule") || null == tarRow.get("pricerule") || row.getInt("seq") == tarRow.getInt("seq") || null == row.get("pricerule") || null == tarRow.get("pricerule") || (srcRuleId = row.getLong("pricerule.id")) != (tarRuleId = tarRow.getLong("pricerule.id"))) continue;
                    BigDecimal tarStartPrice = BigDecimal.ZERO;
                    if (null != tarRow.getBigDecimal("startprice")) {
                        tarStartPrice = tarRow.getBigDecimal("startprice");
                    }
                    BigDecimal tarEndPrice = tarRow.getBigDecimal("endprice");
                    if (endprice.compareTo(BigDecimal.ZERO) == 0 && (startprice.compareTo(tarStartPrice) <= 0 || startprice.compareTo(tarStartPrice) > 0 && (tarEndPrice.compareTo(BigDecimal.ZERO) == 0 || startprice.compareTo(tarEndPrice) < 0))) {
                        stringBuilder.append(tarRow.getInt("seq")).append(",");
                        continue;
                    }
                    if (endprice.compareTo(BigDecimal.ZERO) == 0 || (tarEndPrice.compareTo(BigDecimal.ZERO) != 0 || endprice.compareTo(tarStartPrice) <= 0) && (endprice.compareTo(tarStartPrice) <= 0 || endprice.compareTo(tarEndPrice) > 0)) continue;
                    stringBuilder.append(tarRow.getInt("seq")).append(",");
                }
                if (stringBuilder.length() <= 1) continue;
                String substring = stringBuilder.substring(0, stringBuilder.toString().length() - 1);
                msg = ResManager.loadKDString((String)"\u540c\u6b3e\u5546\u54c1\u6bd4\u4ef7\u5904\u7406\u89c4\u5219\u5206\u5f55\u7b2c{0}\u884c\u4e0e\u7b2c{1}\u884c\u5b58\u5728\u4ef7\u683c\u8303\u56f4\u51b2\u7a81\u3002", (String)"PmmSameGoodsRuleSaveValidator_8", (String)"scm-pmm-opplugin", (Object[])new Object[]{row.getInt("seq"), substring});
                this.addErrorMessage(extendedDataEntity, msg);
            }
        }
    }
}

