/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.opplugin.validator;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class PmmUnitMappingSaveValidator
extends AbstractValidator {
    public void validate() {
        Map<String, String> standardMap = this.getStandardMap();
        HashSet<String> ecUnits = new HashSet<String>(16);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject dyo = dataEntity.getDataEntity();
            ecUnits.add(dyo.getString("ecunit"));
        }
        if (ecUnits.size() > 0) {
            QFilter qFilter = new QFilter("ecunit", "in", ecUnits);
            DynamicObjectCollection pmm_unitmapping = QueryServiceHelper.query((String)"pmm_unitmapping", (String)"id,ecunit,platform", (QFilter[])qFilter.toArray());
            HashMap<String, Long> unitMap = new HashMap<String, Long>(16);
            for (DynamicObject row : pmm_unitmapping) {
                unitMap.put(row.getString("ecunit") + "_" + row.getString("platform"), row.getLong("id"));
            }
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                long srdId;
                DynamicObject dyo = dataEntity.getDataEntity();
                String ecunit = dyo.getString("ecunit");
                String platform = dyo.getString("platform");
                long id = dyo.getLong("id");
                String key = ecunit + "_" + platform;
                if (null == unitMap.get(key) || (srdId = ((Long)unitMap.get(key)).longValue()) == id) continue;
                String msg = ResManager.loadKDString((String)"\u7535\u5546\u5e73\u53f0\uff1a{0}\uff0c\u5df2\u5b58\u5728\u540d\u79f0\u4e3a\u201c{1}\u201d\u7684\u8ba1\u91cf\u5355\u4f4d\uff0c\u4e0d\u5141\u8bb8\u5f15\u5165\u3002", (String)"PmmUnitMappingSaveValidator_0", (String)"scm-pmm-opplugin", (Object[])new Object[]{standardMap.get(platform), ecunit});
                this.addMessage(dataEntity, msg);
            }
        }
    }

    private Map<String, String> getStandardMap() {
        HashMap<String, String> standardMap = new HashMap<String, String>(16);
        DynamicObjectCollection standardDyos = this.getStandardDyos();
        for (DynamicObject row : standardDyos) {
            standardMap.put(row.getString("platform"), row.getString("name"));
        }
        return standardMap;
    }

    private DynamicObjectCollection getStandardDyos() {
        QFilter qFilter = new QFilter("enable", "=", (Object)Boolean.TRUE).and(new QFilter("openstatus", "=", (Object)"2").and(new QFilter("tenantid", "=", (Object)RequestContext.getOrCreate().getTenantId())));
        return QueryServiceHelper.query((String)"pmm_ecadmit", (String)"id,number,name,platform,standard.id,standard.number,standard.name", (QFilter[])new QFilter[]{qFilter}, (String)"platform desc");
    }
}

