/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pssc.opplugin.validator;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.scm.common.eip.errorcode.EipErrorCode;

public class PsscCommonValidator
extends AbstractValidator {
    private static Log logger = LogFactory.getLog(PsscCommonValidator.class);

    public Set<String> preparePropertys() {
        Set preparePropertys = super.preparePropertys();
        preparePropertys.add("srcbillid");
        return preparePropertys;
    }

    public void validate() throws KDBizException {
        HashSet<Long> srcidSet = new HashSet<Long>(16);
        for (ExtendedDataEntity rowDataEntity : this.getDataEntities()) {
            DynamicObject model = rowDataEntity.getDataEntity();
            String srcbillid = model.getString("srcbillid");
            srcidSet.add(Long.parseLong(srcbillid));
        }
        try {
            Object result = DispatchServiceHelper.invokeBizService((String)"scmc", (String)"pm", (String)"PurApplyService", (String)"getPurApplyChangeStatus", (Object[])new Object[]{srcidSet});
            if (result instanceof Map) {
                Map resultMap = (Map)result;
                for (ExtendedDataEntity rowDataEntity : this.getDataEntities()) {
                    DynamicObject dataEntity = rowDataEntity.getDataEntity();
                    String srcbillid = dataEntity.getString("srcbillid");
                    long applybillId = Long.parseLong(srcbillid);
                    Boolean isChanging = (Boolean)resultMap.get(applybillId);
                    if (isChanging == null || !isChanging.booleanValue()) continue;
                    String message = ResManager.loadKDString((String)"\u4efb\u52a1\u5173\u8054\u7684\u91c7\u8d2d\u7533\u8bf7\u6b63\u5728\u53d8\u66f4\u4e2d\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u3002", (String)"PsscCommonValidator_0", (String)"scm-pssc-opplugin", (Object[])new Object[0]);
                    this.addErrorMessage(rowDataEntity, message);
                }
            }
        }
        catch (Exception e) {
            String msg = ResManager.loadKDString((String)"\u67e5\u8be2\u7533\u8bf7\u5355\u53d8\u66f4\u72b6\u6001\u5931\u8d25", (String)"PsscCommonValidator_1", (String)"scm-pssc-opplugin", (Object[])new Object[0]);
            logger.error(msg, (Throwable)e);
            throw new KDException(EipErrorCode.INVOKE_FAILED, new Object[]{e.getMessage()});
        }
    }
}

