/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.opplugin.reqapply;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.mpscmm.msbd.business.helper.OrgHelper;
import kd.mpscmm.msbd.opplugin.BillTypeCoreValidator;
import kd.scm.pssc.business.helper.LastUpdateBillHelper;
import kd.scm.pssc.business.helper.ReqApplyBillHelper;
import kd.scmc.pm.validation.reqapply.MaterialMasterNameValidator;

public class RequirApplyBillSubmitOp
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(RequirApplyBillSubmitOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List keys = e.getFieldKeys();
        keys.add("lastupdateuser");
        keys.add("lastupdatetime");
        keys.add("materialname");
        keys.add("billtype");
        keys.add("biztype");
        keys.add("linetype");
        keys.add("bizorg");
        keys.add("org");
        keys.add("originorg");
        keys.add("classtype");
        keys.add("reqkind");
        keys.add("materialmasterid");
        keys.add("entrybizorg");
        keys.add("unmaterialtag");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new MaterialMasterNameValidator());
        e.addValidator((AbstractValidator)new BillTypeCoreValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        String key = e.getOperationKey();
        if (key != null && "submit".equals(key)) {
            DynamicObject currentUserId = LastUpdateBillHelper.getCurrentUserId();
            DynamicObject[] billList = e.getDataEntities();
            boolean kindParameter = this.getKindParameter();
            Map data = null;
            if (kindParameter) {
                List<Map<String, Object>> inParameterList = this.collectEBInParameter(billList);
                data = ReqApplyBillHelper.getEBPurOrgData(inParameterList, (String)"pm_requirapplybill");
            }
            for (DynamicObject bill : billList) {
                bill.set("lastupdateuser", (Object)currentUserId);
                bill.set("lastupdatetime", (Object)LastUpdateBillHelper.getCurrentDate());
                DynamicObject bizOrg = bill.getDynamicObject("bizorg");
                DynamicObject org = bill.getDynamicObject("org");
                if (org == null) continue;
                Long orgId = (Long)org.getPkValue();
                DynamicObjectCollection entryEntity = bill.getDynamicObjectCollection("billentry");
                this.setOriginOrg(entryEntity, org);
                if (kindParameter) {
                    for (DynamicObject row : entryEntity) {
                        DynamicObject materialMaster;
                        ReqApplyBillHelper.setUnMaterialTag((DynamicObject)row);
                        String reqKind = row.getString("reqkind");
                        if (StringUtils.isBlank((CharSequence)reqKind) || (materialMaster = row.getDynamicObject("materialmasterid")) == null) continue;
                        Long materialMasterId = (Long)materialMaster.getPkValue();
                        DynamicObject ebPurOrg = this.getEBPurOrg(data, orgId, reqKind, materialMasterId, row);
                        if (ebPurOrg != null) {
                            row.set("entrybizorg", (Object)ebPurOrg);
                            continue;
                        }
                        Object entryBizOrg = row.get("entrybizorg");
                        if (bizOrg != null && entryBizOrg == null) {
                            row.set("entrybizorg", (Object)bizOrg);
                            continue;
                        }
                        if (entryBizOrg != null) continue;
                        DynamicObject fromOrg = OrgHelper.getOrgForFormDefObjValue((Long)((Long)org.getPkValue()), (String)"", (String)"02", (String)"toorg");
                        row.set("entrybizorg", (Object)fromOrg);
                    }
                    continue;
                }
                for (DynamicObject row : entryEntity) {
                    Object entryBizOrg = row.get("entrybizorg");
                    if (bizOrg != null && entryBizOrg == null) {
                        row.set("entrybizorg", (Object)bizOrg);
                        continue;
                    }
                    if (entryBizOrg != null) continue;
                    DynamicObject fromOrg = OrgHelper.getOrgForFormDefObjValue((Long)((Long)org.getPkValue()), (String)"", (String)"02", (String)"toorg");
                    row.set("entrybizorg", (Object)fromOrg);
                }
            }
        }
    }

    private DynamicObject getEBPurOrg(Map<String, Map<String, Object>> data, Long orgId, String reqKind, Long materialMasterId, DynamicObject row) {
        return ReqApplyBillHelper.getEBPurOrg(data, (Long)orgId, (String)reqKind, (Long)materialMasterId, (DynamicObject)row);
    }

    private void setOriginOrg(DynamicObjectCollection entryEntity, DynamicObject org) {
        for (DynamicObject row : entryEntity) {
            DynamicObject originOrg = row.getDynamicObject("originorg");
            if (originOrg != null) continue;
            row.set("originorg", (Object)org);
        }
    }

    private List<Map<String, Object>> collectEBInParameter(DynamicObject[] billList) {
        ArrayList<Map<String, Object>> inParameterList = new ArrayList<Map<String, Object>>(16);
        for (DynamicObject bill : billList) {
            DynamicObject org = bill.getDynamicObject("org");
            if (org == null) continue;
            DynamicObjectCollection entryList = bill.getDynamicObjectCollection("billentry");
            for (DynamicObject row : entryList) {
                DynamicObject material = row.getDynamicObject("materialmasterid");
                if (material == null) continue;
                HashMap<String, Object> parameter = new HashMap<String, Object>(16);
                String reqKind = row.getString("reqkind");
                if (StringUtils.isBlank((CharSequence)reqKind)) continue;
                parameter.put("baseDataType", "2");
                parameter.put("orgId", org.getPkValue());
                Long materialId = (Long)material.getPkValue();
                parameter.put("baseDataId", materialId);
                if ("A".equals(reqKind)) {
                    parameter.put("bizType", "2");
                } else if ("B".equals(reqKind)) {
                    parameter.put("bizType", "3");
                }
                inParameterList.add(parameter);
            }
        }
        return inParameterList;
    }

    private Map<String, Map<String, Object>> getEBPurOrgData(List<Map<String, Object>> inParameterList, String entityKey) {
        Boolean success;
        log.info("\u8c03\u7528\u96c6\u91c7\u76ee\u5f55\u7684\u91c7\u8d2d\u7ec4\u7ec7\u670d\u52a1\u5165\u53c2parameter1:{}\uff0cparameter2:{}", (Object)SerializationUtils.toJsonString(inParameterList), (Object)entityKey);
        Map result = (Map)DispatchServiceHelper.invokeBizService((String)"bd", (String)"pbd", (String)"ICategoryService", (String)"batchGetPurChaseOrg", (Object[])new Object[]{inParameterList, entityKey});
        log.info("\u8c03\u7528\u96c6\u91c7\u76ee\u5f55\u7684\u91c7\u8d2d\u7ec4\u7ec7\u670d\u52a1\u51fa\u53c2\u7ed3\u679c:{}", (Object)SerializationUtils.toJsonString((Object)result));
        Map data = null;
        if (result != null && (success = (Boolean)result.get("success")) == Boolean.TRUE) {
            data = (Map)result.get("data");
        }
        return data;
    }

    private boolean getKindParameter() {
        return ReqApplyBillHelper.getKindParameter();
    }
}

