/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pssc.common.helper;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.MaterialGroupStandardUtils;
import kd.scm.pssc.common.helper.MaterialOperatorInfo;
import kd.scm.pssc.common.utils.PsscCommonUtils;

public class MaterialOperatorHelper {
    public Set<MaterialOperatorInfo> getOperatorByMaterial(Set<MaterialOperatorInfo> set, String billtype) {
        HashSet<Long> orgidSet = new HashSet<Long>(set.size());
        HashSet<Long> materialidSet = new HashSet<Long>(set.size());
        HashSet<Long> materialgroupSet = new HashSet<Long>(1024);
        HashMap<String, MaterialOperatorInfo> unDodataMap = new HashMap<String, MaterialOperatorInfo>(set.size());
        HashSet<MaterialOperatorInfo> dataList = new HashSet<MaterialOperatorInfo>(set.size());
        for (MaterialOperatorInfo row : set) {
            unDodataMap.put(row.getkey(), row);
            orgidSet.add(row.getOrgid());
            if (row.getMaterialtype() == 2) {
                materialgroupSet.add(row.getMaterialgroupid());
                continue;
            }
            materialidSet.add(row.getMaterialid());
        }
        Map<String, Map<String, Long>> materFitOpeMap = this.getMaterialFitOperatorNew(orgidSet, materialidSet, true);
        Map<String, Long> personidMap = materFitOpeMap.get("person");
        Map<String, Long> operatoridMap = materFitOpeMap.get("operator");
        Map<String, Long> operatorgroupMap = materFitOpeMap.get("operatorgroup");
        Iterator undodatas = unDodataMap.entrySet().iterator();
        while (undodatas.hasNext()) {
            Map.Entry row = undodatas.next();
            String key = (String)row.getKey() + "OPER_MATER";
            MaterialOperatorInfo value = (MaterialOperatorInfo)row.getValue();
            if (value.getMaterialtype() == 2) continue;
            Long operator = operatoridMap.get(key);
            if (null != operator) {
                Long operatorgroup;
                value.setOperatorid(operator);
                Long person = personidMap.get(key);
                if (null != person) {
                    value.setPersonid(person);
                }
                if (null != (operatorgroup = operatorgroupMap.get(key))) {
                    value.setOperatorgroupid(operatorgroup);
                }
                dataList.add(value);
                undodatas.remove();
                set.remove(value);
                continue;
            }
            materialgroupSet.add(value.getMaterialgroupid());
        }
        if (materialgroupSet == null || materialgroupSet.size() == 0) {
            dataList.addAll(set);
            return dataList;
        }
        Long standardId = MaterialGroupStandardUtils.getMaterialGroupType((String)billtype);
        Map<Long, LinkedList<Long>> allMaterialgroupMap = PsscCommonUtils.getLongNumMapByCategory(materialgroupSet, standardId);
        Set<Long> allmaterialgroupSet = this.mergeAllCategory(materialgroupSet, allMaterialgroupMap);
        Map<String, Map<String, Long>> materialGroupOperatorMap = this.getMaterialFitOperatorNew(orgidSet, allmaterialgroupSet, false);
        Map<String, Long> personidMap2 = materialGroupOperatorMap.get("person");
        Map<String, Long> operatoridMap2 = materialGroupOperatorMap.get("operator");
        Map<String, Long> operatorgroupMap2 = materialGroupOperatorMap.get("operatorgroup");
        Iterator undodatas2 = unDodataMap.entrySet().iterator();
        while (undodatas2.hasNext()) {
            Long operatorgroup;
            String key;
            Long operator;
            Map.Entry row = undodatas2.next();
            MaterialOperatorInfo value = (MaterialOperatorInfo)row.getValue();
            if (allMaterialgroupMap.get(value.getMaterialgroupid()) == null || null == (operator = operatoridMap2.get(key = this.getMaterialGroupKey(value, allMaterialgroupMap.get(value.getMaterialgroupid()), operatoridMap2, "OPER_MATERGRP")))) continue;
            value.setOperatorid(operator);
            Long person = personidMap2.get(key);
            if (null != person) {
                value.setPersonid(person);
            }
            if (null != (operatorgroup = operatorgroupMap2.get(key))) {
                value.setOperatorgroupid(operatorgroup);
            }
            dataList.add(value);
            undodatas2.remove();
            set.remove(value);
        }
        dataList.addAll(set);
        return dataList;
    }

    private String getMaterialGroupKey(MaterialOperatorInfo value, LinkedList<Long> groupList, Map<String, Long> operatoridMap2, String controldimension) {
        String realKey = value.getkey() + controldimension;
        if (operatoridMap2.containsKey(realKey)) {
            return realKey;
        }
        String key = null;
        for (int i = groupList.size() - 1; i >= 0; --i) {
            String groupid = String.valueOf(groupList.get(i));
            key = String.valueOf(value.getOrgid()) + groupid + controldimension;
            if (operatoridMap2.containsKey(key)) break;
        }
        return key;
    }

    private Map<String, Map<String, Long>> getMaterialFitOperatorNew(Set<Long> orgidSet, Set<Long> materialIDSet, boolean ismaterial) {
        HashMap<String, Map<String, Long>> materFitOpeMap = new HashMap<String, Map<String, Long>>(64);
        if (orgidSet == null || materialIDSet == null || materialIDSet.size() == 0) {
            HashMap personidMap = new HashMap(1024);
            HashMap operatoridMap = new HashMap(1024);
            materFitOpeMap.put("operator", operatoridMap);
            materFitOpeMap.put("person", personidMap);
            return materFitOpeMap;
        }
        HashSet<String> controldimensionSet = new HashSet<String>(8);
        QFilter qFilterNumber = null;
        if (ismaterial) {
            controldimensionSet.add("OPER_MATER");
            qFilterNumber = new QFilter("entryentity.material.masterid", "in", materialIDSet);
        } else {
            controldimensionSet.add("OPER_MATERGRP");
            qFilterNumber = new QFilter("entryentity.materialgroup", "in", materialIDSet);
        }
        QFilter qFilter = new QFilter("controldimension", "in", controldimensionSet);
        QFilter qFilterOrg = new QFilter("org", "in", orgidSet);
        QFilter qFilterControlType = new QFilter("controltype", "=", (Object)"ALLOW");
        QFilter qFilterEnable = new QFilter("enable", "=", (Object)"1");
        QFilter qFilterStatus = new QFilter("status", "=", (Object)"C");
        QFilter operatorgroup = new QFilter("entryentity.operatorgroup.enable", "!=", (Object)"0");
        QFilter operator = new QFilter("entryentity.operator.invalid", "!=", (Object)Boolean.TRUE);
        String selector = "id,org,controldimension,entryentity.seq,entryentity.materialgroup.masterid,entryentity.material.masterid,entryentity.operator.operatorid,entryentity.operator,entryentity.operatorgroup";
        HashMap<String, Long> personidMap = new HashMap<String, Long>(1024);
        HashMap<String, Long> operatoridMap = new HashMap<String, Long>(1024);
        HashMap<String, Long> operatorgroupMap = new HashMap<String, Long>(1024);
        QFilter[] qfilters = new QFilter[]{qFilter.and(qFilterOrg).and(qFilterEnable).and(qFilterStatus).and(qFilterControlType).and(qFilterNumber).and(operatorgroup).and(operator)};
        try (DataSet pur0perMaters = QueryServiceHelper.queryDataSet((String)"materialOperatorHelper.dataset", (String)"msbd_puropermaterctrl", (String)selector, (QFilter[])qfilters, (String)"modifytime desc,entryentity.seq asc");){
            for (Row row : pur0perMaters) {
                Long orgID = row.getLong("org");
                Long materialID = 0L;
                materialID = ismaterial ? row.getLong("entryentity.material.masterid") : row.getLong("entryentity.materialgroup.masterid");
                String key = String.valueOf(orgID) + String.valueOf(materialID) + row.getString("controldimension");
                if (operatoridMap.containsKey(key)) continue;
                if (row.getLong("entryentity.operator") != null && !row.getLong("entryentity.operator").equals(0L)) {
                    operatoridMap.put(key, row.getLong("entryentity.operator"));
                }
                if (row.getLong("entryentity.operatorgroup") != null && !row.getLong("entryentity.operatorgroup").equals(0L)) {
                    operatorgroupMap.put(key, row.getLong("entryentity.operatorgroup"));
                }
                if (row.getLong("entryentity.operator.operatorid") == null || row.getLong("entryentity.operator.operatorid").equals(0L)) continue;
                personidMap.put(key, row.getLong("entryentity.operator.operatorid"));
            }
        }
        materFitOpeMap.put("operator", operatoridMap);
        materFitOpeMap.put("operatorgroup", operatorgroupMap);
        materFitOpeMap.put("person", personidMap);
        return materFitOpeMap;
    }

    private Set<Long> mergeAllCategory(Set<Long> baseDataIds, Map<Long, LinkedList<Long>> groupLongNumMaps) {
        HashSet<Long> resultMap = new HashSet<Long>();
        if (baseDataIds == null || baseDataIds.size() < 1) {
            return resultMap;
        }
        if (groupLongNumMaps != null) {
            for (Long baseDataId : baseDataIds) {
                LinkedList<Long> longs = groupLongNumMaps.get(baseDataId);
                if (longs == null) continue;
                resultMap.addAll(longs);
            }
        }
        return resultMap;
    }

    public static Set<Long> getPurchasableDataInfoByOperator(long operatorId, String controlDimension) {
        HashSet<Long> ids = new HashSet<Long>(16);
        QFilter qFilter = new QFilter("controldimension", "=", (Object)controlDimension);
        QFilter qFilterControlType = new QFilter("controltype", "=", (Object)"ALLOW");
        QFilter qFilterEnable = new QFilter("enable", "=", (Object)"1");
        QFilter qFilterStatus = new QFilter("status", "=", (Object)"C");
        QFilter operatorgroup = new QFilter("entryentity.operatorgroup.enable", "!=", (Object)"0");
        QFilter operator = new QFilter("entryentity.operator.invalid", "!=", (Object)Boolean.TRUE);
        QFilter operator1 = new QFilter("entryentity.operator.operatorid", "=", (Object)operatorId);
        DynamicObjectCollection pur0perMaters = QueryServiceHelper.query((String)"msbd_puropermaterctrl", (String)"id,org,entryentity.seq,entryentity.materialgroup,entryentity.material.masterid,entryentity.operator,entryentity.operatorgroup", (QFilter[])new QFilter[]{qFilter.and(qFilterEnable).and(qFilterStatus).and(qFilterControlType).and(operatorgroup).and(operator).and(operator1)}, (String)"audittime");
        String property = "entryentity.materialgroup";
        if (StringUtils.equals((CharSequence)"OPER_MATER", (CharSequence)controlDimension)) {
            property = "entryentity.material.masterid";
        }
        for (DynamicObject pur0perMater : pur0perMaters) {
            ids.add(pur0perMater.getLong(property));
        }
        return ids;
    }
}

