/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pssc.common.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.botp.runtime.AbstractConvertServiceArgs;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.operate.botp.Push;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.botp.ConvertRuleReader;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.scm.pssc.common.helper.status.PsscSrcProjectStatusConvertService;
import kd.scm.pssc.common.utils.TaskBotpDispatchUtils;

public class PsscTaskToSrcProjectHelper {
    public static void pushSrcProject(List<String> properties, Object[] pkIds, IFormView view) {
        ArrayList<ConvertOperationResult> errorResults = new ArrayList<ConvertOperationResult>(1);
        ArrayList<ConvertOperationResult> successResult = new ArrayList<ConvertOperationResult>();
        PushArgs pushArgs = new PushArgs();
        if (properties != null) {
            String taskSelect = PsscTaskToSrcProjectHelper.getSelect(properties);
            QFilter filter = new QFilter("id", "in", (Object)pkIds);
            DynamicObjectCollection tasks = QueryServiceHelper.query((String)"pssc_mytask", (String)taskSelect, (QFilter[])new QFilter[]{filter}, null);
            HashMap<String, ArrayList<ListSelectedRow>> rowsMap = new HashMap<String, ArrayList<ListSelectedRow>>(16);
            HashMap<String, HashMap<String, Long>> propertyMap = new HashMap<String, HashMap<String, Long>>(16);
            List<String> requireSelect = PsscTaskToSrcProjectHelper.getPurRequireSelectsInfo();
            HashSet<String> requireSelect2 = new HashSet<String>(16);
            requireSelect2.add("billentry.id");
            requireSelect2.addAll(requireSelect);
            String select1 = StringUtils.join((Object[])requireSelect2.toArray(), (String)",");
            ArrayList<Long> srcBillIds = new ArrayList<Long>();
            for (DynamicObject task : tasks) {
                srcBillIds.add(task.getLong("srcbillid"));
            }
            QFilter filter1 = new QFilter("id", "in", srcBillIds);
            DynamicObjectCollection purApplyBills = QueryServiceHelper.query((String)"pm_purapplybill", (String)select1, (QFilter[])new QFilter[]{filter1}, null);
            HashMap<String, DynamicObject> entryMap = new HashMap<String, DynamicObject>();
            for (DynamicObject applyBill : purApplyBills) {
                entryMap.put(applyBill.getString("billentry.id"), applyBill);
            }
            for (DynamicObject task : tasks) {
                String splitType = TaskBotpDispatchUtils.makeRowKey(task, properties);
                DynamicObject applyBill = (DynamicObject)entryMap.get(task.getString("srcentryid"));
                if (applyBill == null) continue;
                String reqSplit = TaskBotpDispatchUtils.makeRowKey(applyBill, requireSelect);
                splitType = splitType + "-" + reqSplit;
                ListSelectedRow row = new ListSelectedRow();
                row.setPrimaryKeyValue((Object)Long.parseLong(task.getString("srcbillid")));
                row.setEntryEntityKey("billentry");
                row.setEntryPrimaryKeyValue((Object)Long.parseLong(task.getString("srcentryid")));
                HashMap<String, Long> valuesMap = (HashMap<String, Long>)propertyMap.get(splitType);
                if (valuesMap == null) {
                    valuesMap = new HashMap<String, Long>(16);
                    propertyMap.put(splitType, valuesMap);
                }
                valuesMap.put("taskid", task.getLong("id"));
                valuesMap.put("sourceorg", task.getLong("sourceorg"));
                valuesMap.put("sourcetype", task.getLong("sourcetype"));
                valuesMap.put("srctype", task.getLong("srctype"));
                ArrayList<ListSelectedRow> listSelectedRows = (List)rowsMap.get(splitType);
                if (listSelectedRows != null) {
                    listSelectedRows.add(row);
                    continue;
                }
                listSelectedRows = new ArrayList<ListSelectedRow>();
                listSelectedRows.add(row);
                rowsMap.put(splitType, listSelectedRows);
            }
            Set entries = rowsMap.entrySet();
            for (Map.Entry next : entries) {
                List value = (List)next.getValue();
                pushArgs = new PushArgs();
                pushArgs.setHasRight(false);
                pushArgs.setAutoSave(true);
                pushArgs.setBuildConvReport(true);
                pushArgs.getCustomParams().put("formId", "pssc_mytask");
                pushArgs.setSourceEntityNumber("pm_purapplybill");
                pushArgs.setTargetEntityNumber("src_project");
                pushArgs.setRuleId("2011067992909157376");
                if (value == null || value.size() <= 0) continue;
                pushArgs.setSelectedRows(value);
                Map propertyInfos = (Map)propertyMap.get(next.getKey());
                pushArgs.getCustomParams().put("data", SerializationUtils.toJsonString((Object)propertyInfos));
                ConvertOperationResult result = ConvertServiceHelper.pushAndSave((PushArgs)pushArgs);
                if (result.isSuccess()) {
                    Set targetBillIds = result.getTargetBillIds();
                    for (Object billId : targetBillIds) {
                        DispatchServiceHelper.invokeBizService((String)"scm", (String)"src", (String)"ISrcProjectBillService", (String)"initProjectById", (Object[])new Object[]{billId});
                        propertyInfos.put("parentid", billId);
                    }
                    ConvertOperationResult operationResult = PsscTaskToSrcProjectHelper.pushBillEntry(pushArgs, value, propertyInfos);
                    if (!operationResult.isSuccess()) {
                        Set entryBillId = operationResult.getTargetBillIds();
                        MainEntityType srcPurlistcomType = MetadataServiceHelper.getDataEntityType((String)"src_purlistcomptpl");
                        MainEntityType srcProjectType = MetadataServiceHelper.getDataEntityType((String)"src_project");
                        DeleteServiceHelper.delete((IDataEntityType)srcPurlistcomType, (Object[])entryBillId.toArray());
                        DeleteServiceHelper.delete((IDataEntityType)srcProjectType, (Object[])targetBillIds.toArray());
                        errorResults.add(operationResult);
                        continue;
                    }
                    successResult.add(result);
                    continue;
                }
                errorResults.add(result);
            }
        }
        PsscTaskToSrcProjectHelper.dealPushResult(view, pushArgs, successResult, errorResults);
    }

    private static void dealPushResult(IFormView view, PushArgs pushArgs, List<ConvertOperationResult> successResult, List<ConvertOperationResult> errorResults) {
        List<String> ids;
        PsscSrcProjectStatusConvertService srcProjectStatusConvertService;
        if (successResult.size() > 0) {
            errorResults.clear();
            errorResults.addAll(successResult);
        }
        ConvertOperationResult mergeResult = new ConvertOperationResult();
        if (errorResults.size() > 0) {
            mergeResult = errorResults.get(0);
            for (ConvertOperationResult result : errorResults) {
                if (mergeResult == result) continue;
                mergeResult.setMessage(mergeResult.getMessage() + result.getMessage());
                mergeResult.setSuccess(mergeResult.isSuccess() && result.isSuccess());
                mergeResult.getCachePageIds().addAll(result.getCachePageIds());
                mergeResult.getCacheTargetObjStr().putAll(result.getCacheTargetObjStr());
                mergeResult.getTargetBillIds().addAll(result.getTargetBillIds());
                mergeResult.getDataMutexSrcBillIds().addAll(result.getDataMutexSrcBillIds());
                mergeResult.getBillReports().addAll(result.getBillReports());
                mergeResult.setFinishedTime(result.getFinishedTime());
            }
        }
        if (!mergeResult.isSuccess() || mergeResult.getCachePageIds().size() + mergeResult.getTargetBillIds().size() == 0) {
            Push.showReport((IFormView)view, (AbstractConvertServiceArgs)pushArgs, (ConvertOperationResult)mergeResult);
        } else if (mergeResult.getCachePageIds().size() + mergeResult.getTargetBillIds().size() == 1) {
            srcProjectStatusConvertService = new PsscSrcProjectStatusConvertService();
            ids = mergeResult.getTargetBillIds().stream().map(String::valueOf).collect(Collectors.toList());
            srcProjectStatusConvertService.statusConvert(ids, "save", null);
            Push.showTargetBill((IFormView)view, (PushArgs)pushArgs, (ConvertOperationResult)mergeResult, (boolean)false);
        } else {
            srcProjectStatusConvertService = new PsscSrcProjectStatusConvertService();
            ids = mergeResult.getTargetBillIds().stream().map(String::valueOf).collect(Collectors.toList());
            srcProjectStatusConvertService.statusConvert(ids, "save", null);
            PsscTaskToSrcProjectHelper.showTargetPage(view, mergeResult.getTargetBillIds());
        }
    }

    private static void showTargetPage(IFormView view, Set<Object> targetBillIds) {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId("src_project");
        showParameter.getCustomParams().put("isIgnoreLicense", Boolean.TRUE);
        showParameter.getCustomParams().put("bos_call_source_type", "botp_track");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setShowTitle(false);
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)"src_project");
        showParameter.setCaption(mainType.getDisplayName().toString());
        for (Object billId : targetBillIds) {
            showParameter.addLinkQueryPkId(billId);
        }
        showParameter.addCustPlugin("kd.bos.form.plugin.botp.LookUpTrackerList");
        showParameter.setHasRight(true);
        view.showForm((FormShowParameter)showParameter);
    }

    private static ConvertOperationResult pushBillEntry(PushArgs pushArgs, List<ListSelectedRow> value, Map<String, Object> propertyInfos) {
        pushArgs.getCustomParams().put("data", SerializationUtils.toJsonString(propertyInfos));
        pushArgs.setSelectedRows(value);
        pushArgs.setRuleId("2011078128579115008");
        pushArgs.setTargetEntityNumber("src_purlistcomptpl");
        pushArgs.setSourceEntityNumber("pm_purapplybill");
        return ConvertServiceHelper.pushAndSave((PushArgs)pushArgs);
    }

    private static List<String> getPurRequireSelectsInfo() {
        ConvertRuleReader reader = new ConvertRuleReader();
        List convertRuleElements = reader.loadRules("pm_purapplybill", "src_project");
        ConvertRuleElement element = null;
        for (ConvertRuleElement convertRuleElement : convertRuleElements) {
            if (!convertRuleElement.getId().equals("2011067992909157376")) continue;
            element = convertRuleElement;
        }
        ArrayList<String> requireSelect = new ArrayList<String>(16);
        if (element != null) {
            String[] split;
            String groupByField = element.getGroupByPolicy().getGroupByField();
            for (String s : split = groupByField.split(",")) {
                requireSelect.add(s);
            }
        }
        return requireSelect;
    }

    private static String getSelect(List<String> properties) {
        HashSet<String> selectInfos = new HashSet<String>(16);
        selectInfos.addAll(properties);
        selectInfos.add("id");
        selectInfos.add("srcbillid");
        selectInfos.add("srcentryid");
        selectInfos.add("biztype");
        selectInfos.add("currency");
        selectInfos.add("sourceorg");
        selectInfos.add("sourcetype");
        selectInfos.add("srctype");
        selectInfos.add("packagegroup");
        return StringUtils.join((Object[])selectInfos.toArray(), (String)",");
    }
}

