/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pssc.common.helper.status;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pssc.common.helper.status.IPsscStatusConvertService;
import kd.scm.pssc.common.helper.status.PsscStatusConvertHelper;
import kd.scm.pssc.common.utils.PsscParamUtil;

public class PsscPurOrderStatusConvertService
implements IPsscStatusConvertService {
    @Override
    public void statusConvert(List<String> businesskeys, String operation, String variables) {
        if (businesskeys == null) {
            return;
        }
        List ids = businesskeys.stream().map(Long::parseLong).collect(Collectors.toList());
        if ("save".equals(operation) || "submit".equals(operation)) {
            QFilter idFilter = new QFilter("id", "in", ids);
            DynamicObjectCollection orders = QueryServiceHelper.query((String)"pm_purorderbill", (String)"id, org,billentry.srcbillentryid srcbillentryid,billentry.srcbillentity srcbillentity", (QFilter[])idFilter.toArray());
            HashSet<String> orgSet = new HashSet<String>();
            HashMap<Long, String> idOrgidMap = new HashMap<Long, String>();
            for (DynamicObject order : orders) {
                orgSet.add(order.getString("org"));
                idOrgidMap.put(order.getLong("id"), order.getString("org"));
            }
            Map<String, String> poolEnableMap = PsscParamUtil.ifTaskPoolEnable(orgSet);
            ids.removeIf(id -> "false".equals(poolEnableMap.get(idOrgidMap.get(id))));
            if (ids.isEmpty()) {
                return;
            }
            HashSet<String> relationEntryIdSet = PsscStatusConvertHelper.getRelationEntryIdList(orders);
            if (relationEntryIdSet.isEmpty()) {
                for (DynamicObject order : orders) {
                    relationEntryIdSet.add(order.getString("srcbillentryid"));
                }
            }
            PsscStatusConvertHelper.calculateMyTaskStatus(relationEntryIdSet);
        } else if ("delete".equals(operation)) {
            if (variables == null || variables.isEmpty()) {
                return;
            }
            PsscStatusConvertHelper.changeStatusWhenDelete(businesskeys, variables);
            PsscStatusConvertHelper.removeRelationInfo(businesskeys);
        }
    }
}

