/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pssc.common.helper.status;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pssc.common.helper.status.IPsscStatusConvertService;
import kd.scm.pssc.common.helper.status.PsscStatusConvertHelper;
import kd.scm.pssc.common.utils.PsscParamUtil;

public class PsscSrcDemandStatusConvertService
implements IPsscStatusConvertService {
    @Override
    public void statusConvert(List<String> businesskeys, String operation, String variables) {
        if (businesskeys == null) {
            return;
        }
        List ids = businesskeys.stream().map(Long::parseLong).collect(Collectors.toList());
        if ("save".equals(operation) || "submit".equals(operation)) {
            QFilter idFilter = new QFilter("id", "in", ids);
            DynamicObjectCollection demands = QueryServiceHelper.query((String)"src_demand", (String)"id, org,entryentity.srcentryid srcentryid", (QFilter[])idFilter.toArray());
            HashSet<String> orgSet = new HashSet<String>();
            HashMap<Long, String> idOrgidMap = new HashMap<Long, String>();
            for (DynamicObject demand : demands) {
                orgSet.add(demand.getString("org"));
                idOrgidMap.put(demand.getLong("id"), demand.getString("org"));
            }
            Map<String, String> poolEnableMap = PsscParamUtil.ifTaskPoolEnable(orgSet);
            ids.removeIf(id -> "false".equals(poolEnableMap.get(idOrgidMap.get(id))));
            HashSet<String> srcentryidSet = new HashSet<String>(ids.size());
            for (DynamicObject demand : demands) {
                if (!ids.contains(demand.getLong("id"))) continue;
                srcentryidSet.add(demand.getString("srcentryid"));
            }
            PsscStatusConvertHelper.calculateMyTaskStatus(srcentryidSet);
        } else if ("delete".equals(operation)) {
            if (variables == null || variables.isEmpty()) {
                return;
            }
            PsscStatusConvertHelper.changeStatusWhenDelete(businesskeys, variables);
        }
    }
}

