/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pssc.common.helper.status.manager;

import java.math.BigDecimal;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pssc.common.enums.HandleStatusEnums;
import kd.scm.pssc.common.helper.status.manager.AbstractStatusCalculatetor;

public class PsscMalPlanStatusCalculatetor
extends AbstractStatusCalculatetor {
    @Override
    protected void calcStatus(Map<String, HandleStatusEnums> statusMap, Set<String> applyEntryIds) {
        QFilter planFilter = new QFilter("entryentity.srcentryid", "in", applyEntryIds);
        DynamicObjectCollection malplans = QueryServiceHelper.query((String)"mal_plan", (String)"entryentity.srcentryid srcentryid, entryentity.joinqty joinqty, entryentity.reqqty reqqty", (QFilter[])planFilter.toArray());
        for (DynamicObject plan : malplans) {
            BigDecimal joinqty = plan.getBigDecimal("joinqty");
            if (joinqty.compareTo(BigDecimal.ZERO) <= 0) continue;
            if (joinqty.compareTo(plan.getBigDecimal("reqqty")) >= 0) {
                statusMap.put(plan.getString("srcentryid"), HandleStatusEnums.TOORDER);
                applyEntryIds.remove(plan.getString("srcentryid"));
                continue;
            }
            statusMap.put(plan.getString("srcentryid"), HandleStatusEnums.PARTORDER);
            applyEntryIds.remove(plan.getString("srcentryid"));
        }
    }
}

