/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pssc.common.helper.status.manager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.pssc.common.enums.HandleStatusEnums;
import kd.scm.pssc.common.helper.status.manager.IStatusCalculatetor;
import kd.scm.pssc.common.helper.status.manager.PsscMalPlanStatusCalculatetor;
import kd.scm.pssc.common.helper.status.manager.PsscOrderStatusCalculatetor;
import kd.scm.pssc.common.helper.status.manager.PsscSrcDemandStatusCalculatetor;
import kd.scm.pssc.common.helper.status.manager.PsscSrcProjectStatusCalculatetor;

public class StatusManager {
    private List<IStatusCalculatetor> statusCalculatetors = new ArrayList<IStatusCalculatetor>(4);
    private Set<String> applyentryidSet;
    private DynamicObject[] tasks;

    public StatusManager(Set<String> applyentryidSet) {
        this.statusCalculatetors.add(new PsscOrderStatusCalculatetor());
        this.statusCalculatetors.add(new PsscMalPlanStatusCalculatetor());
        this.statusCalculatetors.add(new PsscSrcDemandStatusCalculatetor());
        this.statusCalculatetors.add(new PsscSrcProjectStatusCalculatetor());
        this.applyentryidSet = applyentryidSet;
    }

    public StatusManager(Set<String> applyentryidSet, boolean queryOrder) {
        PsscOrderStatusCalculatetor psscOrderStatusCalculatetor = new PsscOrderStatusCalculatetor();
        psscOrderStatusCalculatetor.setQueryOrder(queryOrder);
        this.statusCalculatetors.add(psscOrderStatusCalculatetor);
        this.statusCalculatetors.add(new PsscMalPlanStatusCalculatetor());
        this.statusCalculatetors.add(new PsscSrcDemandStatusCalculatetor());
        this.statusCalculatetors.add(new PsscSrcProjectStatusCalculatetor());
        this.applyentryidSet = applyentryidSet;
    }

    public static HashSet<String> getordeSet(List<Long> srcentryidList) {
        QFilter orderfilter = new QFilter("billentry.srcbillentryid", "in", srcentryidList);
        DynamicObjectCollection pm_purorderbill = QueryServiceHelper.query((String)"pm_purorderbill", (String)"billentry.srcbillentryid srcbillentryid", (QFilter[])orderfilter.toArray());
        HashSet<String> orderSet = new HashSet<String>();
        for (DynamicObject order : pm_purorderbill) {
            orderSet.add(order.getString("srcbillentryid"));
        }
        return orderSet;
    }

    public void calcStatusForTask() {
        if (this.applyentryidSet == null || this.applyentryidSet.size() == 0) {
            return;
        }
        QFilter taskSrcidFilter = new QFilter("srcentryid", "in", this.applyentryidSet);
        DynamicObject[] tasks = BusinessDataServiceHelper.load((String)"pssc_mytask", (String)"handlestatus,srcentryid,statusbeforeend,handler", (QFilter[])taskSrcidFilter.toArray());
        this.tasks = tasks;
        HashMap<String, HandleStatusEnums> statusEnumsMap = new HashMap<String, HandleStatusEnums>(this.applyentryidSet.size());
        for (IStatusCalculatetor statusCalculatetor : this.statusCalculatetors) {
            statusEnumsMap.putAll(statusCalculatetor.calculate(this.applyentryidSet));
        }
        for (DynamicObject task : this.tasks) {
            String srcentryid = task.getString("srcentryid");
            HandleStatusEnums handleStatusEnums = (HandleStatusEnums)((Object)statusEnumsMap.get(srcentryid));
            if (handleStatusEnums == null && this.applyentryidSet != null && !this.applyentryidSet.contains(srcentryid)) continue;
            if (handleStatusEnums == null) {
                this.setHandleStatus(task, HandleStatusEnums.PROCESSING);
                continue;
            }
            if (HandleStatusEnums.TERMINATED.getValue().equals(handleStatusEnums.getValue())) {
                this.setHandleStatus(task, HandleStatusEnums.TERMINATED);
                continue;
            }
            long handlerId = task.getLong("handler_id");
            if (handlerId == 0L) {
                this.setHandleStatus(task, HandleStatusEnums.TOALLOCATE);
                continue;
            }
            this.setHandleStatus(task, handleStatusEnums);
        }
    }

    private void setHandleStatus(DynamicObject task, HandleStatusEnums status) {
        String curSatus = task.getString("handlestatus");
        task.set(HandleStatusEnums.SUSPEND.getValue().equals(curSatus) || HandleStatusEnums.TERMINATED.getValue().equals(curSatus) ? "statusbeforeend" : "handlestatus", (Object)status);
    }

    public void persisTask() {
        if (this.tasks != null && this.tasks.length > 0) {
            SaveServiceHelper.save((DynamicObject[])this.tasks);
        }
    }
}

