/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pssc.common.utils;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scm.pssc.common.log.HandleLogEntity;
import kd.scm.pssc.common.log.PsscHandleLogService;
import kd.scm.pssc.common.utils.PsscCommonUtils;
import kd.scm.pssc.common.utils.PsscDispatchServiceUtil;
import kd.scm.pssc.common.utils.PsscPackageGroupUtils;
import kd.scm.pssc.common.utils.PsscParamUtil;
import kd.scm.pssc.common.utils.PsscTaskPoolUtil;

public class PsscAutoprocessUtil {
    private static Log log = LogFactory.getLog(PsscAutoprocessUtil.class);

    public static void autoProcess(List<DynamicObject> targetObjects, boolean isBillChange) {
        long begin = System.currentTimeMillis();
        log.info("begin:setValByCategoryStrategy" + begin);
        boolean flag = PsscDispatchServiceUtil.isMcmServiceOn();
        if (flag) {
            PsscTaskPoolUtil.setValByCategoryStrategy(targetObjects, false);
        }
        long end = System.currentTimeMillis();
        log.info("end:setValByCategoryStrategy" + (end - begin));
        begin = System.currentTimeMillis();
        PsscTaskPoolUtil.setTargetValByPrice(targetObjects, false);
        end = System.currentTimeMillis();
        log.info("end:setTargetValByPrice" + (end - begin));
        PsscAutoprocessUtil.setDefaultValue(targetObjects);
        begin = System.currentTimeMillis();
        String autogetorg = PsscParamUtil.ifAutoGetSrcOrg();
        if (flag && "true".equals(autogetorg) && !isBillChange) {
            PsscCommonUtils.setSourceOrg(targetObjects, false);
        }
        PsscAutoprocessUtil.setDefaultSourceOrg(targetObjects);
        end = System.currentTimeMillis();
        log.info("end:setSourceOrg" + (end - begin));
        begin = System.currentTimeMillis();
        PsscTaskPoolUtil.setBizPersonOrBizGroup(targetObjects, false);
        end = System.currentTimeMillis();
        log.info("end:setBizPersonOrBizGroup" + (end - begin));
        begin = System.currentTimeMillis();
        PsscAutoprocessUtil.packageGroup(targetObjects);
        end = System.currentTimeMillis();
        log.info("end:packageGroup" + (end - begin));
        if (!isBillChange) {
            for (DynamicObject targetObject : targetObjects) {
                PsscTaskPoolUtil.setHandleStatus(targetObject, false);
            }
        }
        if (!isBillChange) {
            ArrayList<DynamicObject> poolRows = new ArrayList<DynamicObject>(32);
            poolRows.addAll(targetObjects);
            OperationServiceHelper.executeOperate((String)"save", (String)"pssc_mytask", (DynamicObject[])poolRows.toArray(new DynamicObject[0]), null);
            OperationServiceHelper.executeOperate((String)"syncdata", (String)"pssc_mytask", (DynamicObject[])poolRows.toArray(new DynamicObject[0]), null);
            OperationServiceHelper.executeOperate((String)"sendmsg", (String)"pssc_mytask", (DynamicObject[])poolRows.toArray(new DynamicObject[0]), null);
        }
    }

    private static void packageGroup(List<DynamicObject> targetObjects) {
        Map<Long, Object> packageGroups = new HashMap<Long, JSONObject>(16);
        for (DynamicObject myTask : targetObjects) {
            PsscPackageGroupUtils.dealUnPackageData(myTask, packageGroups, true);
        }
        if ((packageGroups = (Map)DispatchServiceHelper.invokeBizService((String)"scm", (String)"pssc", (String)"IPsscPackGroupService", (String)"dealPackageGroupInfo", (Object[])new Object[]{packageGroups, 0L})) != null && packageGroups.size() > 0) {
            for (DynamicObject task : targetObjects) {
                Object tag;
                JSONObject jsonObject = (JSONObject)packageGroups.get(task.getLong("id"));
                if (jsonObject == null || (tag = jsonObject.get((Object)"tag")) == null) continue;
                task.set("packagegroup", tag);
            }
        }
    }

    public static void setDefaultSourceOrg(List<DynamicObject> targetObjects) {
        for (DynamicObject targetObject : targetObjects) {
            if (0L != targetObject.getLong("sourceorg_id")) continue;
            targetObject.set("sourceorg", targetObject.get("purorg"));
        }
    }

    public static void setDefaultValue(List<DynamicObject> targetObjects) {
        PsscHandleLogService psscHandleLogService = new PsscHandleLogService();
        ArrayList<HandleLogEntity> logEntityList = new ArrayList<HandleLogEntity>(16);
        for (DynamicObject targetObject : targetObjects) {
            String purmethod = targetObject.getString("purmethod");
            if (purmethod == null || purmethod.isEmpty()) {
                targetObject.set("purmethod", (Object)"sourc");
                PsscTaskPoolUtil.recordTargetLog(psscHandleLogService, logEntityList, targetObject, "sourc");
            }
            targetObject.set("taskcreatetime", (Object)TimeServiceHelper.now());
            targetObject.set("priority", (Object)"0");
            DynamicObject handler = targetObject.getDynamicObject("handler");
            if (handler == null) continue;
            Long userId = handler.getLong("operatorid.id");
            targetObject.set("handleuser_id", (Object)userId);
        }
        PsscTaskPoolUtil.saveHandleLog(logEntityList);
    }
}

