/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pssc.common.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.StringUtils;
import kd.scm.pssc.common.utils.CollectionUtils;

public class PsscExchangeRateUtils {
    public static Long getRateTableIdByOrg(long orgId) {
        long exchangeTableId = 0L;
        Map companyMap = OrgUnitServiceHelper.getCompanyByOrg((Long)orgId, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
        if (companyMap == null || companyMap.size() == 0) {
            return exchangeTableId;
        }
        Map baseAccountingInfo = BaseDataServiceHelper.getBaseAccountingInfo((Long)((Long)companyMap.get("id")));
        if (baseAccountingInfo == null || baseAccountingInfo.size() == 0) {
            return exchangeTableId;
        }
        exchangeTableId = (Long)baseAccountingInfo.get("exchangeRateTableID");
        return exchangeTableId;
    }

    public static void setCalcLocalValue(DynamicObject billObj, DynamicObject entryObj, String sourceField, String targetField, String precisionField) {
        entryObj.set(targetField, (Object)PsscExchangeRateUtils.calcLocalValue(billObj, entryObj, sourceField, precisionField));
    }

    public static BigDecimal calcLocalValue(DynamicObject billObj, DynamicObject entryObj, String sourceField, String precisionField) {
        return PsscExchangeRateUtils.calc(billObj, entryObj, sourceField, precisionField, true);
    }

    public static BigDecimal calcValue(DynamicObject billObj, DynamicObject entryObj, String sourceField, String precisionField) {
        return PsscExchangeRateUtils.calc(billObj, entryObj, sourceField, precisionField, false);
    }

    private static BigDecimal calc(DynamicObject billObj, DynamicObject entryObj, String sourceField, String precisionField, boolean isLoc) {
        BigDecimal calcValue = entryObj.getBigDecimal(sourceField);
        DynamicObject locCurr = billObj.getDynamicObject("loccurr");
        DynamicObject curr = billObj.getDynamicObject("currency");
        int precision = null == locCurr ? 4 : locCurr.getInt(precisionField);
        String quotation = entryObj.getString("quotation");
        BigDecimal exrate = entryObj.getBigDecimal("exrate");
        if (Objects.isNull(locCurr) || Objects.isNull(curr) || Objects.equals(locCurr.getPkValue(), curr.getPkValue()) || exrate.compareTo(BigDecimal.ZERO) <= 0) {
            exrate = BigDecimal.ONE;
            quotation = "0";
        }
        switch (quotation) {
            case "0": {
                if (isLoc) {
                    calcValue = calcValue.multiply(exrate).setScale(precision, RoundingMode.HALF_UP);
                    break;
                }
                calcValue = calcValue.divide(exrate, precision, RoundingMode.HALF_UP);
                break;
            }
            case "1": {
                if (isLoc) {
                    calcValue = calcValue.divide(exrate, precision, RoundingMode.HALF_UP);
                    break;
                }
                calcValue = calcValue.multiply(exrate).setScale(precision, RoundingMode.HALF_UP);
                break;
            }
        }
        return calcValue;
    }

    public static Map<String, Object> getExchangeRate(DynamicObject billObj, DynamicObject entryObj, StringBuilder currMsgSb, Map<String, Object> cacheMap) {
        HashMap<String, Object> exchangeRateMap = new HashMap<String, Object>(16);
        long rateTableId = entryObj.getLong("exratetable.id");
        if (rateTableId == 0L) {
            rateTableId = PsscExchangeRateUtils.getRateTableIdByOrg(entryObj.getLong("org.id"));
            entryObj.set("exratetable_id", (Object)rateTableId);
        }
        String quotation = entryObj.getString("quotation");
        BigDecimal exrate = entryObj.getBigDecimal("exrate");
        if (exrate.compareTo(BigDecimal.ZERO) <= 0 || StringUtils.isBlank((String)quotation)) {
            long currency;
            long loccurr = billObj.getLong("loccurr.id");
            if (loccurr == (currency = billObj.getLong("currency.id"))) {
                exchangeRateMap.put("exrate", BigDecimal.ONE);
                exchangeRateMap.put("quotation", "0");
                entryObj.set("quotation", (Object)"0");
                entryObj.set("exrate", (Object)BigDecimal.ONE);
                return exchangeRateMap;
            }
            String key = String.valueOf(rateTableId) + '|' + currency + '|' + loccurr;
            if (cacheMap.get(key + '|' + "exrate") != null) {
                exchangeRateMap.put("exrate", cacheMap.get(key + '|' + "exrate"));
                exchangeRateMap.put("quotation", cacheMap.get(key + '|' + "quotation"));
            } else {
                Map exchangeRateByRules;
                Date exrateDate = entryObj.getDate("exratedate");
                if (Objects.isNull(exrateDate)) {
                    exrateDate = Calendar.getInstance().getTime();
                    entryObj.set("exratedate", (Object)exrateDate);
                }
                if (CollectionUtils.isEmpty(exchangeRateByRules = BaseDataServiceHelper.getExchangeRateMap((Long)currency, (Long)loccurr, (Long)rateTableId, (Date)exrateDate)) || Objects.isNull(exchangeRateByRules.get("exchangeRate"))) {
                    currMsgSb.append(billObj.getString("currency.name"));
                    currMsgSb.append('-');
                    currMsgSb.append(billObj.getString("loccurr.name"));
                    currMsgSb.append("; ");
                } else {
                    exrate = (BigDecimal)exchangeRateByRules.get("exchangeRate");
                    quotation = (Boolean)exchangeRateByRules.get("quoteType") != false ? "1" : "0";
                    exchangeRateMap.put("exrate", exrate);
                    exchangeRateMap.put("quotation", quotation);
                    cacheMap.put(key + '|' + "quotation", quotation);
                    cacheMap.put(key + '|' + "exrate", exrate);
                    entryObj.set("quotation", (Object)quotation);
                    entryObj.set("exrate", (Object)exrate);
                }
            }
        }
        return exchangeRateMap;
    }

    public static void setExchangeRate(DynamicObject entryObj, Map<String, Object> cacheMap) {
        long currency;
        long loccurr;
        long rateTableId = entryObj.getLong("exratetable.id");
        if (rateTableId == 0L) {
            rateTableId = PsscExchangeRateUtils.getRateTableIdByOrg(entryObj.getLong("org.id"));
            entryObj.set("exratetable_id", (Object)rateTableId);
        }
        if ((loccurr = entryObj.getLong("loccurr.id")) == (currency = entryObj.getLong("currency.id"))) {
            entryObj.set("quotation", (Object)"0");
            entryObj.set("exrate", (Object)BigDecimal.ONE);
            return;
        }
        String key = String.valueOf(rateTableId) + '|' + currency + '|' + loccurr;
        BigDecimal exrate = BigDecimal.ZERO;
        String quotation = "";
        if (cacheMap.get(key + '|' + "exrate") != null) {
            exrate = (BigDecimal)cacheMap.get(key + '|' + "exrate");
            quotation = (String)cacheMap.get(key + '|' + "quotation");
        } else {
            Map exchangeRateByRules;
            Date exrateDate = entryObj.getDate("exratedate");
            if (Objects.isNull(exrateDate)) {
                exrateDate = Calendar.getInstance().getTime();
                entryObj.set("exratedate", (Object)exrateDate);
            }
            if (CollectionUtils.isNotEmpty(exchangeRateByRules = BaseDataServiceHelper.getExchangeRateMap((Long)currency, (Long)loccurr, (Long)rateTableId, (Date)exrateDate))) {
                exrate = (BigDecimal)exchangeRateByRules.get("exchangeRate");
                quotation = (Boolean)exchangeRateByRules.get("quoteType") != false ? "1" : "0";
                cacheMap.put(key + '|' + "quotation", quotation);
                cacheMap.put(key + '|' + "exrate", exrate);
            }
        }
        entryObj.set("quotation", (Object)quotation);
        entryObj.set("exrate", (Object)exrate);
    }
}

