/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pssc.common.utils;

import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class PsscPackageGroupUtils {
    public static void switchToUnDefault(DynamicObject[] bills) {
        HashMap<Long, Long> userMapToBillIds = new HashMap<Long, Long>(bills.length);
        for (DynamicObject bill : bills) {
            long handleUser = bill.getLong("handleuser_id");
            boolean aDefault = bill.getBoolean("default");
            if (!aDefault) continue;
            userMapToBillIds.put(handleUser, bill.getLong("id"));
        }
        Set userIds = userMapToBillIds.keySet();
        Collection values = userMapToBillIds.values();
        if (userIds.size() > 0) {
            DynamicObject[] waitDealInfos;
            for (DynamicObject waitDealInfo : waitDealInfos = BusinessDataServiceHelper.load((String)"pssc_grouppackage", (String)"default,handleuser", (QFilter[])new QFilter[]{new QFilter("handleuser.id", "in", userIds), new QFilter("id", "not in", values)})) {
                waitDealInfo.set("default", (Object)Boolean.FALSE);
            }
            SaveServiceHelper.save((DynamicObject[])waitDealInfos);
        }
    }

    public static void dealUnPackageData(DynamicObject row, Map<Long, JSONObject> unDealRows, boolean isPurMaster) {
        if (row != null && unDealRows != null) {
            JSONObject json = new JSONObject();
            Object handleuser = row.get("handleuser");
            if (handleuser instanceof Long) {
                json.put("hander", (Object)row.getLong("handleuser"));
            } else {
                json.put("hander", (Object)row.getLong("handleuser_id"));
            }
            if (isPurMaster) {
                json.put("material", (Object)row.getLong("material.masterid_id"));
            } else {
                json.put("material", (Object)row.getLong("material.id"));
            }
            unDealRows.put(row.getLong("id"), json);
        }
    }

    public static void dealPackageGroupInfos(DynamicObjectCollection entryEntity, Map<Long, JSONObject> packageGroupInfo, String property) {
        if (entryEntity == null || packageGroupInfo == null) {
            return;
        }
        for (DynamicObject row : entryEntity) {
            PsscPackageGroupUtils.dealPackageGroupInfo(row, packageGroupInfo, property);
        }
    }

    public static void dealPackageGroupInfo(DynamicObject row, Map<Long, JSONObject> packageGroupInfo, String property) {
        if (row == null || packageGroupInfo == null) {
            return;
        }
        long taskId = row.getLong(property);
        JSONObject jsonObject = packageGroupInfo.get(taskId);
        if (jsonObject != null && jsonObject.containsKey((Object)"tag")) {
            String tag = jsonObject.getString("tag");
            row.set("packagegroup", (Object)tag);
        }
    }

    public static String validateBaseData(String property, Map<String, Integer> baseDataMap, int rowIndex, String number) {
        if (StringUtils.isNotBlank((CharSequence)number)) {
            if (baseDataMap.containsKey(number)) {
                Integer index = baseDataMap.get(number);
                if (index != null) {
                    if (StringUtils.equals((CharSequence)property, (CharSequence)"category")) {
                        return String.format(ResManager.loadKDString((String)"\u7b2c%1$s,%2$s\u884c\u7269\u6599\u5206\u7c7b\u7f16\u7801\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PsscPackageGroupUtils_0", (String)"scm-pssc-common", (Object[])new Object[0]), index, rowIndex);
                    }
                    return String.format(ResManager.loadKDString((String)"\u7b2c%1$s,%2$s\u884c\u7269\u6599\u7f16\u7801\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PsscPackageGroupUtils_1", (String)"scm-pssc-common", (Object[])new Object[0]), index, rowIndex);
                }
            } else {
                baseDataMap.put(number, rowIndex);
            }
        }
        return "";
    }
}

