/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pssc.common.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.botp.jobtask.BackgroundTaskManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.scm.pssc.common.helper.PsscTaskToSrcProjectHelper;
import kd.scm.pssc.common.utils.PsscCommonUtils;
import kd.scm.pssc.common.utils.PsscTaskPoolUtil;
import kd.sdk.scm.pssc.task.IPsscTaskSplitBillBasis;

public final class TaskBotpDispatchUtils {
    private static final Character SPLITE = Character.valueOf('|');

    public static void doPush(IFormView view, Object[] pkIds, String operateKey) {
        if ("pushsrcdemand".equals(operateKey)) {
            TaskBotpDispatchUtils.pushsrcdemand(view, pkIds);
        } else if ("pushorder".equals(operateKey)) {
            TaskBotpDispatchUtils.pushorder(view, pkIds);
        } else if ("pushsrcproject".equals(operateKey)) {
            TaskBotpDispatchUtils.pushproject(view, pkIds);
        }
    }

    private static void pushproject(IFormView view, Object[] pkIds) {
        List<String> properties = TaskBotpDispatchUtils.getSplitTaskProperties("pushsrcproject");
        PsscTaskToSrcProjectHelper.pushSrcProject(properties, pkIds, view);
    }

    private static void pushorder(IFormView view, Object[] pkIds) {
        List<String> properties = TaskBotpDispatchUtils.getSplitTaskProperties("order");
        DynamicObjectCollection tasks = TaskBotpDispatchUtils.getSelectedTaskData(properties, pkIds);
        HashMap taskGroupMap = new HashMap(1);
        for (DynamicObject task : tasks) {
            String groupKey = TaskBotpDispatchUtils.makeRowKey(task, properties);
            ArrayList<ListSelectedRow> listSelectedRows = (ArrayList<ListSelectedRow>)taskGroupMap.get(groupKey);
            if (listSelectedRows == null) {
                listSelectedRows = new ArrayList<ListSelectedRow>(8);
                taskGroupMap.put(groupKey, listSelectedRows);
            }
            ListSelectedRow row = new ListSelectedRow();
            row.setPrimaryKeyValue((Object)Long.parseLong(task.getString("srcbillid")));
            row.setEntryEntityKey("billentry");
            row.setEntryPrimaryKeyValue((Object)Long.parseLong(task.getString("srcentryid")));
            listSelectedRows.add(row);
        }
        ArrayList<ConvertOperationResult> successResult = new ArrayList<ConvertOperationResult>();
        ArrayList<ConvertOperationResult> results = new ArrayList<ConvertOperationResult>();
        Iterator pushSelectedRows = taskGroupMap.entrySet().iterator();
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber("pm_purapplybill");
        pushArgs.setTargetEntityNumber("pm_purorderbill");
        pushArgs.setBuildConvReport(false);
        pushArgs.setAutoSave(true);
        pushArgs.setHasRight(false);
        pushArgs.setShowReport(true);
        pushArgs.setBuildConvReport(true);
        while (pushSelectedRows.hasNext()) {
            Map.Entry next = pushSelectedRows.next();
            List selectedRowList = (List)next.getValue();
            pushArgs.setSelectedRows(selectedRowList);
            if (selectedRowList.size() <= 20000) {
                ConvertOperationResult result = ConvertServiceHelper.push((PushArgs)pushArgs);
                if (result.isSuccess()) {
                    MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)"pm_purorderbill");
                    List targetObjects = result.loadTargetDataObjects(BusinessDataServiceHelper::loadRefence, mainType);
                    PsscCommonUtils.saveRelation(targetObjects);
                    successResult.add(result);
                    continue;
                }
                results.add(result);
                continue;
            }
            pushArgs.setShowReport(true);
            TaskBotpDispatchUtils.pushAndSaveBackGround(pushArgs, view);
        }
        PsscTaskPoolUtil.dealResult(successResult, results, pushArgs, view);
    }

    private static void pushsrcdemand(IFormView view, Object[] pkIds) {
        List<String> properties = TaskBotpDispatchUtils.getSplitTaskProperties("src");
        DynamicObjectCollection tasks = TaskBotpDispatchUtils.getSelectedTaskData(properties, pkIds);
        HashMap<String, List<ListSelectedRow>> rowsMap = new HashMap<String, List<ListSelectedRow>>(16);
        HashMap<String, Map<String, Object>> propertyMap = new HashMap<String, Map<String, Object>>(16);
        TaskBotpDispatchUtils.makeGroupBill(tasks, rowsMap, propertyMap, properties);
        PushArgs pushArgs = new PushArgs();
        pushArgs.setHasRight(false);
        pushArgs.setAutoSave(false);
        pushArgs.setBuildConvReport(true);
        pushArgs.setRuleId("1873292497963603968");
        pushArgs.getCustomParams().put("formId", "pssc_mytask");
        pushArgs.setSourceEntityNumber("pm_purapplybill");
        pushArgs.setTargetEntityNumber("src_demand");
        TaskBotpDispatchUtils.doPushToBill(pushArgs, rowsMap, propertyMap, view);
    }

    private static void makeGroupBill(DynamicObjectCollection tasks, Map<String, List<ListSelectedRow>> rowsMap, Map<String, Map<String, Object>> propertyMap, List<String> properties) {
        for (DynamicObject task : tasks) {
            String splitType = TaskBotpDispatchUtils.makeRowKey(task, properties);
            List<ListSelectedRow> listSelectedRows = rowsMap.get(splitType);
            ListSelectedRow row = new ListSelectedRow();
            row.setPrimaryKeyValue((Object)Long.parseLong(task.getString("srcbillid")));
            row.setEntryEntityKey("billentry");
            row.setEntryPrimaryKeyValue((Object)Long.parseLong(task.getString("srcentryid")));
            TaskBotpDispatchUtils.wrapPropetyMap(splitType, propertyMap, task);
            if (listSelectedRows != null) {
                listSelectedRows.add(row);
                continue;
            }
            listSelectedRows = new ArrayList<ListSelectedRow>();
            listSelectedRows.add(row);
            rowsMap.put(splitType, listSelectedRows);
        }
    }

    private static void doPushToBill(PushArgs pushArgs, Map<String, List<ListSelectedRow>> rowsMap, Map<String, Map<String, Object>> propertyMap, IFormView view) {
        Set<Map.Entry<String, List<ListSelectedRow>>> entries = rowsMap.entrySet();
        Iterator<Map.Entry<String, List<ListSelectedRow>>> iterator = entries.iterator();
        ArrayList<ConvertOperationResult> successResult = new ArrayList<ConvertOperationResult>();
        ArrayList<ConvertOperationResult> results = new ArrayList<ConvertOperationResult>();
        while (iterator.hasNext()) {
            Map.Entry<String, List<ListSelectedRow>> next = iterator.next();
            List<ListSelectedRow> value = next.getValue();
            if (value == null || value.size() <= 0) continue;
            pushArgs.setSelectedRows(value);
            Map<String, Object> propertyInfos = propertyMap.get(next.getKey());
            pushArgs.getCustomParams().put("data", SerializationUtils.toJsonString(propertyInfos));
            ConvertOperationResult result = ConvertServiceHelper.push((PushArgs)pushArgs);
            if (result.isSuccess()) {
                successResult.add(result);
                continue;
            }
            results.add(result);
        }
        PsscTaskPoolUtil.dealResult(successResult, results, pushArgs, view);
    }

    public static String makeRowKey(DynamicObject task, List<String> properties) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < properties.size(); ++i) {
            sb.append(task.getString(properties.get(i)));
            if (i == properties.size() - 1) continue;
            sb.append(SPLITE);
        }
        return sb.toString();
    }

    private static void wrapPropetyMap(String splitType, Map<String, Map<String, Object>> propertyMap, DynamicObject task) {
        Map<String, Object> valuesMap = propertyMap.get(splitType);
        if (valuesMap == null) {
            valuesMap = new HashMap<String, Object>(16);
            propertyMap.put(splitType, valuesMap);
        }
        valuesMap.put(task.getString("srcentryid"), task.getLong("id"));
    }

    private static DynamicObjectCollection getSelectedTaskData(List<String> properties, Object[] pks) {
        HashSet<String> selectInfos = new HashSet<String>(16);
        selectInfos.addAll(properties);
        selectInfos.add("id");
        selectInfos.add("srcbillid");
        selectInfos.add("srcentryid");
        selectInfos.add("biztype");
        selectInfos.add("currency");
        selectInfos.add("sourceorg");
        selectInfos.add("sourcetype");
        selectInfos.add("srctype");
        selectInfos.add("packagegroup");
        String select = StringUtils.join((Object[])selectInfos.toArray(), (String)",");
        QFilter filter = new QFilter("id", "in", (Object)pks);
        return QueryServiceHelper.query((String)"pssc_mytask", (String)select, (QFilter[])filter.toArray());
    }

    private static List<String> getSplitTaskProperties(String type) {
        LinkedList<String> properties = new LinkedList<String>();
        PluginProxy pluginProxy = PluginProxy.create((typeInfo, pros) -> {
            switch (typeInfo) {
                case "src": {
                    pros.add("biztype");
                    pros.add("currency");
                    pros.add("sourceorg");
                    pros.add("sourcetype");
                    pros.add("srctype");
                    pros.add("packagegroup");
                    break;
                }
                case "order": {
                    pros.add("packagegroup");
                    break;
                }
                case "pushsrcproject": {
                    pros.add("sourceorg");
                    pros.add("sourcetype");
                    pros.add("srctype");
                    pros.add("packagegroup");
                }
            }
        }, IPsscTaskSplitBillBasis.class, (String)"SCM_PSSC_TASK_SPLITBILLBASIS", null);
        pluginProxy.callAfter(p -> {
            p.splitBillBasisProperties(type, properties);
            return null;
        });
        return properties;
    }

    private static void pushAndSaveBackGround(PushArgs args, IFormView view) {
        BackgroundTaskManager pushAndSaveJob = BackgroundTaskManager.newInstance((IFormView)view);
        pushAndSaveJob.dispatchBackgroundTask(args);
        view.showTipNotification(ResManager.loadKDString((String)"\u4e0b\u63a8\u6570\u91cf\u8d85\u8fc720000\u6761, \u5df2\u8f6c\u540e\u53f0\u6267\u884c\u3002", (String)"PsscTaskPushList_0", (String)"scm-pssc-formplugin", (Object[])new Object[0]));
    }
}

