/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pssc.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.org.model.OrgRelationParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.scm.pssc.common.utils.PsscCommonUtils;
import kd.scm.pssc.common.utils.PsscDispatchServiceUtil;
import kd.scm.pssc.common.utils.PsscTaskPoolUtil;

public final class PsscAutoProcessPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit handler = (BasedataEdit)this.getControl("handler");
        BasedataEdit newhandler = (BasedataEdit)this.getControl("newhandler");
        BasedataEdit sourceorg = (BasedataEdit)this.getControl("sourceorg");
        if (null != handler) {
            handler.addBeforeF7SelectListener(this::beforeF7Select);
        }
        if (null != newhandler) {
            newhandler.addBeforeF7SelectListener(this::beforeF7Select);
        }
        if (null != sourceorg) {
            sourceorg.addBeforeF7SelectListener(this::beforeF7Select);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String pro = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        IDataModel model = this.getModel();
        String entityId = this.getView().getEntityId();
        switch (pro) {
            case "sourceorg": {
                model.beginInit();
                for (ChangeData data : changeSet) {
                    if ("pssc_reqpool_allocate".equals(entityId)) {
                        model.setValue("handler", null, data.getRowIndex());
                        model.setValue("purgroup", null, data.getRowIndex());
                        continue;
                    }
                    if (!"pssc_reqpool_transmit".equals(entityId)) continue;
                    model.setValue("newhandler", null, data.getRowIndex());
                    model.setValue("newpurgroup", null, data.getRowIndex());
                }
                model.endInit();
                this.getView().updateView("entryentity");
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String name = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        switch (name) {
            case "handler": 
            case "newhandler": {
                ArrayList<Long> orgidList = new ArrayList<Long>();
                DynamicObject purorg = (DynamicObject)this.getModel().getValue("purorg", e.getRow());
                DynamicObject sourceorg = (DynamicObject)this.getModel().getValue("sourceorg", e.getRow());
                if (purorg != null) {
                    orgidList.add((Long)purorg.getPkValue());
                }
                if (sourceorg != null) {
                    orgidList.add((Long)sourceorg.getPkValue());
                }
                QFilter q1 = new QFilter("operatorgrpid", "in", this.getOperatorGroupByOrg(orgidList));
                QFilter q2 = new QFilter("invalid", "=", (Object)Boolean.FALSE);
                showParameter.getListFilterParameter().getQFilters().add(q1.and(q2));
                break;
            }
            case "sourceorg": {
                showParameter.setMultiSelect(false);
                DynamicObject row = this.getModel().getEntryRowEntity("entryentity", e.getRow());
                boolean flag = PsscDispatchServiceUtil.isMcmServiceOn();
                List qfilters = showParameter.getListFilterParameter().getQFilters();
                ArrayList<Long> orgIds = new ArrayList<Long>(8);
                if (flag) {
                    Long sourceOrgId;
                    Map<String, Object> relation;
                    Object relationParam = showParameter.getCustomParams().get("orgRelation");
                    if (relationParam != null && (relation = this.getRelationMap((HashMap)relationParam)) != null) {
                        orgIds.addAll((List)relation.get("orgId"));
                    }
                    if ((sourceOrgId = this.getPurOrgIdByCategory(row)) > 0L) {
                        orgIds.add(sourceOrgId);
                        if (orgIds.size() <= 1) break;
                        qfilters.add(new QFilter("id", "in", orgIds));
                        showParameter.getCustomParams().remove("orgRelation");
                        break;
                    }
                    if (orgIds.size() != 0) break;
                    showParameter.getCustomParams().remove("orgRelation");
                    break;
                }
                Object relationParam = showParameter.getCustomParams().get("orgRelation");
                Map<String, Object> relationMap = this.getRelationMap((HashMap)relationParam);
                if (relationMap == null || relationMap.get("orgId") == null) {
                    showParameter.getCustomParams().remove("orgRelation");
                    return;
                }
                List orgIdList = (List)relationMap.get("orgId");
                if (!orgIdList.isEmpty()) break;
                showParameter.getCustomParams().remove("orgRelation");
                return;
            }
        }
    }

    private Map<String, Object> getRelationMap(HashMap<String, Object> relationParam) {
        HashMap<String, Object> orgRelation = relationParam;
        Long orgpkid = (Long)orgRelation.get("orgpkid");
        String fromtype = (String)orgRelation.get("fromtype");
        String totype = (String)orgRelation.get("totype");
        String directtype = (String)orgRelation.get("directtype");
        OrgRelationParam orgRelationParam = this.buildOrgRelationParam(orgpkid, fromtype, totype, directtype);
        return OrgUnitServiceHelper.getOrgRelation((OrgRelationParam)orgRelationParam);
    }

    private OrgRelationParam buildOrgRelationParam(Long orgId, String fromViewType, String toViewType, String getDirectOrgType) {
        OrgRelationParam param = new OrgRelationParam();
        param.setOrgId(orgId.longValue());
        param.setFromViewType(fromViewType);
        param.setToViewType(toViewType);
        param.setDirectViewType(getDirectOrgType);
        return param;
    }

    private Long getPurOrgIdByCategory(DynamicObject row) {
        Long purOrgId = 0L;
        ArrayList<DynamicObject> rowList = new ArrayList<DynamicObject>(1);
        rowList.add(row);
        Map data = PsscCommonUtils.getPurOrgByCategory(rowList);
        if (null != data) {
            for (Map.Entry dataMapEntry : data.entrySet()) {
                Map valMap = (Map)dataMapEntry.getValue();
                if (null == valMap) continue;
                purOrgId = (Long)valMap.get("orgId");
            }
        }
        return purOrgId;
    }

    private List<Long> getOperatorGroupByOrg(List<Long> orgIds) {
        QFilter q3;
        QFilter q2;
        ArrayList<Long> operatorGroupList = null;
        QFilter q1 = BaseDataServiceHelper.getBaseDataFilter((String)"bd_operatorgroup", orgIds, (boolean)true);
        Map map = BusinessDataServiceHelper.loadFromCache((String)"bd_operatorgroup", (String)"id,createorg,operatorgrouptype,enable", (QFilter[])new QFilter[]{q1, q2 = new QFilter("operatorgrouptype", "in", (Object)"CGZ"), q3 = new QFilter("enable", "in", (Object)"1")});
        if (map != null && map.size() > 0) {
            operatorGroupList = new ArrayList<Long>(map.size());
            for (DynamicObject dyn : map.values()) {
                if (dyn == null) continue;
                operatorGroupList.add((Long)dyn.getPkValue());
            }
        }
        return operatorGroupList;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String opkey = ((AbstractOperate)args.getSource()).getOperateKey();
        DynamicObjectCollection cols = this.getModel().getEntryEntity("entryentity");
        switch (opkey) {
            case "autoprocess": {
                if (cols.size() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e\u3002", (String)"PsscReqPoolAllocatePlugin_0", (String)"scm-pssc-formplugin", (Object[])new Object[0]));
                    return;
                }
                PsscTaskPoolUtil.setBizPersonOrBizGroup((List)cols, (boolean)true);
                ArrayList<String> handProList = new ArrayList<String>(4);
                handProList.add("handler");
                handProList.add("purgroup");
                HashSet<Integer> indexSet = new HashSet<Integer>(cols.size());
                this.getModel().beginInit();
                for (int i = 0; i < cols.size(); ++i) {
                    for (String pro : handProList) {
                        Object proVal = ((DynamicObject)cols.get(i)).get(pro);
                        if (!(proVal instanceof Long) || (Long)proVal <= 0L) continue;
                        this.getModel().setValue(pro, proVal, i);
                        indexSet.add(i);
                    }
                }
                int failNum = cols.size() - indexSet.size();
                this.getModel().endInit();
                this.getView().updateView("entryentity");
                this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u81ea\u52a8\u5206\u914d\u5b8c\u6210\uff0c\u5df2\u5206\u914d%1$s\u6761\uff0c\u672a\u5206\u914d%2$s\u6761\u3002", (String)"PsscAutoProcessPlugin_0", (String)"scm-pssc-formplugin", (Object[])new Object[0]), indexSet.size(), failNum));
                break;
            }
            case "getsourcorg": {
                int i;
                HashMap<Integer, Long> entryorgMap = new HashMap<Integer, Long>(cols.size());
                for (i = 0; i < cols.size(); ++i) {
                    DynamicObject dynamicObject = (DynamicObject)cols.get(i);
                    entryorgMap.put(i, dynamicObject.getLong("sourceorg.id"));
                }
                PsscCommonUtils.setSourceOrg((List)cols, (boolean)true);
                this.getModel().beginInit();
                for (i = 0; i < cols.size(); ++i) {
                    Long oldSourceOrg;
                    Object sourceorg = ((DynamicObject)cols.get(i)).get("sourceorg_id");
                    if (!(sourceorg instanceof Long) || (Long)sourceorg <= 0L || (oldSourceOrg = (Long)entryorgMap.get(i)).equals(sourceorg)) continue;
                    this.getModel().setValue("sourceorg", sourceorg, i);
                    if ("pssc_reqpool_allocate".equals(this.getView().getEntityId())) {
                        this.getModel().setValue("handler", null, i);
                        this.getModel().setValue("purgroup", null, i);
                        continue;
                    }
                    if (!"pssc_reqpool_transmit".equals(this.getView().getEntityId())) continue;
                    this.getModel().setValue("newhandler", null, i);
                    this.getModel().setValue("newpurgroup", null, i);
                }
                this.getModel().endInit();
                this.getView().updateView("entryentity");
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5904\u7406\u6210\u529f\u3002", (String)"PsscReqPoolAllocatePlugin_1", (String)"scm-pssc-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }
}

